/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.spi;

import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.responses.Response;

public final class LdapMessages {
    private LdapMessages() {
    }

    public static LdapRequestEnvelope newRequestEnvelope(byte messageType, int messageId, int ldapVersion, ByteString rawDn, ASN1Reader reader) {
        return new LdapRequestEnvelope(messageType, messageId, ldapVersion, rawDn, reader);
    }

    public static LdapResponseMessage newResponseMessage(byte messageType, int messageId, Response response) {
        return new LdapResponseMessage(messageType, messageId, response);
    }

    private static abstract class LdapMessageEnvelope<T> {
        private final T content;
        private final int messageId;
        private final byte messageType;

        public LdapMessageEnvelope(byte messageType, int messageId, T content) {
            this.messageType = messageType;
            this.messageId = messageId;
            this.content = content;
        }

        public byte getMessageType() {
            return this.messageType;
        }

        public int getMessageId() {
            return this.messageId;
        }

        public T getContent() {
            return this.content;
        }
    }

    public static final class LdapResponseMessage
    extends LdapMessageEnvelope<Response> {
        private LdapResponseMessage(byte messageType, int messageId, Response content) {
            super(messageType, messageId, content);
        }
    }

    public static final class LdapRequestEnvelope
    extends LdapMessageEnvelope<ASN1Reader> {
        private final ByteString rawDn;
        private final int ldapVersion;

        private LdapRequestEnvelope(byte messageType, int messageId, int ldapVersion, ByteString rawDn, ASN1Reader content) {
            super(messageType, messageId, content);
            this.ldapVersion = ldapVersion;
            this.rawDn = rawDn;
        }

        public int getLdapVersion() {
            return this.ldapVersion;
        }

        public ByteString getRawDn() {
            return this.rawDn;
        }
    }
}

