/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Collection;
import java.util.Collections;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteSequenceReader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.opendj.ldap.spi.Indexer;
import org.forgerock.opendj.ldap.spi.IndexingOptions;

final class UUIDEqualityMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    private static final Collection<? extends Indexer> INDEXERS = Collections.singleton(new Indexer(){

        @Override
        public void createKeys(Schema schema, ByteSequence value, Collection<ByteString> keys) throws DecodeException {
            keys.add(UUIDEqualityMatchingRuleImpl.hash(UUIDEqualityMatchingRuleImpl.normalize(value)));
        }

        @Override
        public String keyToHumanReadableString(ByteSequence key) {
            return key.toByteString().toHexString();
        }

        @Override
        public String getIndexID() {
            return "uuidMatch";
        }
    });

    UUIDEqualityMatchingRuleImpl() {
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        return UUIDEqualityMatchingRuleImpl.normalize(value).toByteString();
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
        final ByteString normalizedAssertionValue = this.normalizeAttributeValue(schema, assertionValue);
        return new Assertion(){

            @Override
            public ConditionResult matches(ByteSequence normalizedAttributeValue) {
                return ConditionResult.valueOf(normalizedAssertionValue.equals(normalizedAttributeValue));
            }

            @Override
            public <T> T createIndexQuery(IndexQueryFactory<T> factory) throws DecodeException {
                return factory.createExactMatchQuery("uuidMatch", UUIDEqualityMatchingRuleImpl.hash(normalizedAssertionValue));
            }
        };
    }

    @Override
    public Collection<? extends Indexer> createIndexers(IndexingOptions options) {
        return INDEXERS;
    }

    static ByteSequence normalize(ByteSequence value) throws DecodeException {
        if (value.length() != 36) {
            throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_UUID_INVALID_LENGTH.get(value, value.length()));
        }
        ByteStringBuilder builder = new ByteStringBuilder(16);
        block3: for (int i = 0; i < 36; ++i) {
            switch (i) {
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    char c = (char)value.byteAt(i);
                    if (c == '-') continue block3;
                    throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_UUID_EXPECTED_DASH.get(value, i, Character.valueOf(c)));
                }
                default: {
                    int high4Bits = UUIDEqualityMatchingRuleImpl.decodeHexByte(value, i++);
                    int low4Bits = UUIDEqualityMatchingRuleImpl.decodeHexByte(value, i);
                    builder.appendByte(high4Bits << 4 | low4Bits);
                }
            }
        }
        return builder;
    }

    private static int decodeHexByte(ByteSequence value, int i) throws DecodeException {
        char c = (char)value.byteAt(i);
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c - 97 + 10;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c - 65 + 10;
            }
        }
        throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_UUID_EXPECTED_HEX.get(value, i, Character.valueOf(c)));
    }

    private static ByteString hash(ByteSequence normalizeAttributeValue) {
        ByteSequenceReader uuid128Bytes = normalizeAttributeValue.asReader();
        long uuidHigh64 = uuid128Bytes.readLong();
        long uuidLow64 = uuid128Bytes.readLong();
        long uuid64 = uuidHigh64 ^ uuidLow64;
        int hash32 = (int)(uuid64 >> 32) ^ (int)uuid64;
        return ByteString.valueOfInt(hash32);
    }
}

