/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class UTCTimeSyntaxImpl
extends AbstractSyntaxImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final Object DATE_FORMAT_LOCK;
    private static final SimpleDateFormat DATE_FORMAT;
    private static Date datum1900;
    private static Date datum2000;

    UTCTimeSyntaxImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String createUTCTimeValue(Date d) {
        Object object = DATE_FORMAT_LOCK;
        synchronized (object) {
            return DATE_FORMAT.format(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Date decodeUTCTimeValue(String valueString) throws DecodeException {
        try {
            Object object = DATE_FORMAT_LOCK;
            synchronized (object) {
                switch (valueString.charAt(0)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': {
                        DATE_FORMAT.set2DigitYearStart(datum2000);
                        break;
                    }
                    default: {
                        DATE_FORMAT.set2DigitYearStart(datum1900);
                    }
                }
                return DATE_FORMAT.parse(valueString);
            }
        }
        catch (Exception e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_CANNOT_PARSE.get(valueString, e);
            DecodeException de = DecodeException.error(message, e);
            logger.debug(LocalizableMessage.raw("%s", de));
            throw de;
        }
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.27";
    }

    @Override
    public String getName() {
        return "UTCTime";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.28";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.4";
    }

    @Override
    public boolean isHumanReadable() {
        return false;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String valueString = value.toString().toUpperCase();
        int length = valueString.length();
        if (length < 11) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_TOO_SHORT.get(valueString);
            invalidReason.append(message);
            return false;
        }
        block56: for (int i = 0; i < 2; ++i) {
            switch (valueString.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block56;
                }
                default: {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_YEAR.get(valueString, String.valueOf(valueString.charAt(i)));
                    invalidReason.append(message);
                    return false;
                }
            }
        }
        char m1 = valueString.charAt(2);
        char m2 = valueString.charAt(3);
        block3 : switch (m1) {
            case '0': {
                switch (m2) {
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block3;
                    }
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_MONTH.get(valueString, valueString.substring(2, 4));
                invalidReason.append(message);
                return false;
            }
            case '1': {
                switch (m2) {
                    case '0': 
                    case '1': 
                    case '2': {
                        break block3;
                    }
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_MONTH.get(valueString, valueString.substring(2, 4));
                invalidReason.append(message);
                return false;
            }
            default: {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_MONTH.get(valueString, valueString.substring(2, 4));
                invalidReason.append(message);
                return false;
            }
        }
        char d1 = valueString.charAt(4);
        char d2 = valueString.charAt(5);
        block13 : switch (d1) {
            case '0': {
                switch (d2) {
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block13;
                    }
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_DAY.get(valueString, valueString.substring(4, 6));
                invalidReason.append(message);
                return false;
            }
            case '1': 
            case '2': {
                switch (d2) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block13;
                    }
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_DAY.get(valueString, valueString.substring(4, 6));
                invalidReason.append(message);
                return false;
            }
            case '3': {
                switch (d2) {
                    case '0': 
                    case '1': {
                        break block13;
                    }
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_DAY.get(valueString, valueString.substring(4, 6));
                invalidReason.append(message);
                return false;
            }
            default: {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_DAY.get(valueString, valueString.substring(4, 6));
                invalidReason.append(message);
                return false;
            }
        }
        char h1 = valueString.charAt(6);
        char h2 = valueString.charAt(7);
        block27 : switch (h1) {
            case '0': 
            case '1': {
                switch (h2) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block27;
                    }
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_HOUR.get(valueString, valueString.substring(6, 8));
                invalidReason.append(message);
                return false;
            }
            case '2': {
                switch (h2) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        break block27;
                    }
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_HOUR.get(valueString, valueString.substring(6, 8));
                invalidReason.append(message);
                return false;
            }
            default: {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_HOUR.get(valueString, valueString.substring(6, 8));
                invalidReason.append(message);
                return false;
            }
        }
        m1 = valueString.charAt(8);
        block37 : switch (m1) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (length < 11) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(m1), 8);
                    invalidReason.append(message);
                    return false;
                }
                switch (valueString.charAt(9)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block37;
                    }
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_MINUTE.get(valueString, valueString.substring(8, 10));
                invalidReason.append(message);
                return false;
            }
            default: {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(m1), 8);
                invalidReason.append(message);
                return false;
            }
        }
        char s1 = valueString.charAt(10);
        block43 : switch (s1) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (length < 13) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 10);
                    invalidReason.append(message);
                    return false;
                }
                switch (valueString.charAt(11)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block43;
                    }
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_SECOND.get(valueString, valueString.substring(10, 12));
                invalidReason.append(message);
                return false;
            }
            case '6': {
                if (length < 13) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 10);
                    invalidReason.append(message);
                    return false;
                }
                if (valueString.charAt(11) == '0') break;
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_SECOND.get(valueString, valueString.substring(10, 12));
                invalidReason.append(message);
                return false;
            }
            case 'Z': {
                if (length == 11) {
                    return true;
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 10);
                invalidReason.append(message);
                return false;
            }
            case '+': 
            case '-': {
                if (length == 15) {
                    return this.hasValidOffset(valueString, 11, invalidReason);
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 10);
                invalidReason.append(message);
                return false;
            }
            default: {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 10);
                invalidReason.append(message);
                return false;
            }
        }
        switch (valueString.charAt(12)) {
            case 'Z': {
                if (length == 13) {
                    return true;
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(valueString.charAt(12)), 12);
                invalidReason.append(message);
                return false;
            }
            case '+': 
            case '-': {
                if (length == 17 || length == 15) {
                    return this.hasValidOffset(valueString, 13, invalidReason);
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(valueString.charAt(12)), 12);
                invalidReason.append(message);
                return false;
            }
        }
        LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(valueString.charAt(12)), 12);
        invalidReason.append(message);
        return false;
    }

    private boolean hasValidOffset(String value, int startPos, LocalizableMessageBuilder invalidReason) {
        int offsetLength = value.length() - startPos;
        if (offsetLength < 2) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_TOO_SHORT.get(value);
            invalidReason.append(message);
            return false;
        }
        block0 : switch (value.charAt(startPos)) {
            case '0': 
            case '1': {
                switch (value.charAt(startPos + 1)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block0;
                    }
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_OFFSET.get(value, value.substring(startPos, startPos + offsetLength));
                invalidReason.append(message);
                return false;
            }
            case '2': {
                switch (value.charAt(startPos + 1)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        break block0;
                    }
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_OFFSET.get(value, value.substring(startPos, startPos + offsetLength));
                invalidReason.append(message);
                return false;
            }
            default: {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_OFFSET.get(value, value.substring(startPos, startPos + offsetLength));
                invalidReason.append(message);
                return false;
            }
        }
        if (offsetLength == 4) {
            block10 : switch (value.charAt(startPos + 2)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': {
                    switch (value.charAt(startPos + 3)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break block10;
                        }
                    }
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_OFFSET.get(value, value.substring(startPos, startPos + offsetLength));
                    invalidReason.append(message);
                    return false;
                }
                default: {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_OFFSET.get(value, value.substring(startPos, startPos + offsetLength));
                    invalidReason.append(message);
                    return false;
                }
            }
        }
        return true;
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("yyMMddHHmmss'Z'");
        DATE_FORMAT.setLenient(false);
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.set(1900, 0, 1);
        datum1900 = cal.getTime();
        cal.clear();
        cal.set(2000, 0, 1);
        datum2000 = cal.getTime();
        DATE_FORMAT_LOCK = new Object();
    }
}

