/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.ObjectIdentifierEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class ObjectIdentifierFirstComponentEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    ObjectIdentifierFirstComponentEqualityMatchingRuleImpl() {
        super("objectIdentifierFirstComponentMatch");
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
        return ObjectIdentifierEqualityMatchingRuleImpl.getAssertion(schema, "objectIdentifierFirstComponentMatch", assertionValue);
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String definition = value.toString();
        SubstringReader reader = new SubstringReader(definition);
        reader.skipWhitespaces();
        if (reader.remaining() <= 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_EMPTY_VALUE.get();
            throw DecodeException.error(message);
        }
        char c = reader.read();
        if (c != '(') {
            throw DecodeException.error(CoreMessages.ERR_ATTR_SYNTAX_EXPECTED_OPEN_PARENTHESIS.get(definition, reader.pos() - 1, Character.valueOf(c)));
        }
        reader.skipWhitespaces();
        String oid = SchemaUtils.readOID(reader, schema.getOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS));
        return ByteString.valueOfUtf8(StaticUtils.toLowerCase(oid, new StringBuilder(oid.length())).toString().trim());
    }
}

