/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Collection;
import java.util.Collections;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.opendj.ldap.spi.Indexer;
import org.forgerock.opendj.ldap.spi.IndexingOptions;

final class KeywordEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    KeywordEqualityMatchingRuleImpl() {
        super("keywordMatch");
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
        final String normalStr = this.normalize(assertionValue);
        return new Assertion(){

            @Override
            public ConditionResult matches(ByteSequence attributeValue) {
                char c;
                String valueStr1 = attributeValue.toString();
                int pos = valueStr1.indexOf(normalStr);
                if (pos < 0) {
                    return ConditionResult.FALSE;
                }
                if (pos > 0 && !this.isAcceptable(c = valueStr1.charAt(pos - 1))) {
                    return ConditionResult.FALSE;
                }
                if (valueStr1.length() > pos + normalStr.length() && !this.isAcceptable(c = valueStr1.charAt(pos + normalStr.length()))) {
                    return ConditionResult.FALSE;
                }
                return ConditionResult.TRUE;
            }

            private boolean isAcceptable(char c) {
                switch (c) {
                    case ' ': 
                    case '#': 
                    case '$': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case '=': 
                    case '_': {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public <T> T createIndexQuery(IndexQueryFactory<T> factory) throws DecodeException {
                return factory.createMatchAllQuery();
            }
        };
    }

    @Override
    public Collection<? extends Indexer> createIndexers(IndexingOptions options) {
        return Collections.emptySet();
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) {
        return ByteString.valueOfUtf8(this.normalize(value));
    }

    private String normalize(ByteSequence value) {
        return SchemaUtils.normalizeStringAttributeValue(value, true, true).toString();
    }
}

