/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class GuideSyntaxImpl
extends AbstractSyntaxImpl {
    GuideSyntaxImpl() {
    }

    static boolean criteriaIsValid(Schema schema, String criteria, String valueStr, LocalizableMessageBuilder invalidReason) {
        int endPos;
        char c = criteria.charAt(0);
        if (c == '!') {
            return GuideSyntaxImpl.criteriaIsValid(schema, criteria.substring(1), valueStr, invalidReason);
        }
        if (c == '(') {
            int length = criteria.length();
            int depth = 1;
            for (int i = 1; i < length; ++i) {
                c = criteria.charAt(i);
                if (c == ')') {
                    if (--depth != 0) continue;
                    String subCriteria = criteria.substring(1, i);
                    if (!GuideSyntaxImpl.criteriaIsValid(schema, subCriteria, valueStr, invalidReason)) {
                        return false;
                    }
                    if (i == length - 1) {
                        return true;
                    }
                    c = criteria.charAt(i + 1);
                    if (c == '|' || c == '&') {
                        return GuideSyntaxImpl.criteriaIsValid(schema, criteria.substring(i + 2), valueStr, invalidReason);
                    }
                    invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_ILLEGAL_CHAR.get(valueStr, criteria, Character.valueOf(c), i + 1));
                    return false;
                }
                if (c != '(') continue;
                ++depth;
            }
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_MISSING_CLOSE_PAREN.get(valueStr, criteria));
            return false;
        }
        if (c == '?') {
            if (criteria.startsWith("?true")) {
                if (criteria.length() == 5) {
                    return true;
                }
                c = criteria.charAt(5);
                if (c == '|' || c == '&') {
                    return GuideSyntaxImpl.criteriaIsValid(schema, criteria.substring(6), valueStr, invalidReason);
                }
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_ILLEGAL_CHAR.get(valueStr, criteria, Character.valueOf(c), 5));
                return false;
            }
            if (criteria.startsWith("?false")) {
                if (criteria.length() == 6) {
                    return true;
                }
                c = criteria.charAt(6);
                if (c == '|' || c == '&') {
                    return GuideSyntaxImpl.criteriaIsValid(schema, criteria.substring(7), valueStr, invalidReason);
                }
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_ILLEGAL_CHAR.get(valueStr, criteria, Character.valueOf(c), 6));
                return false;
            }
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_QUESTION_MARK.get(valueStr, criteria));
            return false;
        }
        if ("true".equals(criteria) || "false".equals(criteria)) {
            return true;
        }
        int dollarPos = criteria.indexOf(36);
        if (dollarPos < 0) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_NO_DOLLAR.get(valueStr, criteria));
            return false;
        }
        if (dollarPos == 0) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_NO_ATTR.get(valueStr, criteria));
            return false;
        }
        if (dollarPos == criteria.length() - 1) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_NO_MATCH_TYPE.get(valueStr, criteria));
            return false;
        }
        try {
            SchemaUtils.readOID(new SubstringReader(criteria.substring(0, dollarPos)), schema.getOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS));
        }
        catch (DecodeException de) {
            invalidReason.append(de.getMessageObject());
            return false;
        }
        c = criteria.charAt(dollarPos + 1);
        switch (c) {
            case 'e': {
                if (criteria.startsWith("eq", dollarPos + 1)) {
                    endPos = dollarPos + 3;
                    break;
                }
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE.get(valueStr, criteria, dollarPos + 1));
                return false;
            }
            case 's': {
                if (criteria.startsWith("substr", dollarPos + 1)) {
                    endPos = dollarPos + 7;
                    break;
                }
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE.get(valueStr, criteria, dollarPos + 1));
                return false;
            }
            case 'g': {
                if (criteria.startsWith("ge", dollarPos + 1)) {
                    endPos = dollarPos + 3;
                    break;
                }
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE.get(valueStr, criteria, dollarPos + 1));
                return false;
            }
            case 'l': {
                if (criteria.startsWith("le", dollarPos + 1)) {
                    endPos = dollarPos + 3;
                    break;
                }
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE.get(valueStr, criteria, dollarPos + 1));
                return false;
            }
            case 'a': {
                if (criteria.startsWith("approx", dollarPos + 1)) {
                    endPos = dollarPos + 7;
                    break;
                }
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE.get(valueStr, criteria, dollarPos + 1));
                return false;
            }
            default: {
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE.get(valueStr, criteria, dollarPos + 1));
                return false;
            }
        }
        if (endPos >= criteria.length()) {
            return true;
        }
        c = criteria.charAt(endPos);
        if (c == '|' || c == '&') {
            return GuideSyntaxImpl.criteriaIsValid(schema, criteria.substring(endPos + 1), valueStr, invalidReason);
        }
        invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_ILLEGAL_CHAR.get(valueStr, criteria, Character.valueOf(c), endPos));
        return false;
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.17";
    }

    @Override
    public String getName() {
        return "Guide";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.18";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String valueStr = StaticUtils.toLowerCase(value.toString());
        int sharpPos = valueStr.indexOf(35);
        if (sharpPos < 0) {
            return GuideSyntaxImpl.criteriaIsValid(schema, valueStr, valueStr, invalidReason);
        }
        String ocName = valueStr.substring(0, sharpPos).trim();
        int ocLength = ocName.length();
        if (ocLength == 0) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_GUIDE_NO_OC1.get(valueStr));
            return false;
        }
        try {
            SchemaUtils.readOID(new SubstringReader(ocName.substring(0, ocLength)), schema.getOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS));
        }
        catch (DecodeException de) {
            invalidReason.append(de.getMessageObject());
            return false;
        }
        return GuideSyntaxImpl.criteriaIsValid(schema, valueStr.substring(sharpPos + 1), valueStr, invalidReason);
    }
}

