/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class AttributeTypeSyntaxImpl
extends AbstractSyntaxImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();

    AttributeTypeSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.30";
    }

    @Override
    public String getName() {
        return "AttributeTypeDescription";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String definition = value.toString();
        try {
            String tokenName;
            char c;
            SubstringReader reader = new SubstringReader(definition);
            boolean allowMalformedNamesAndOptions = schema.getOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                SchemaUtils.throwDecodeException(logger, CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_EMPTY_VALUE1.get(definition));
            }
            if ((c = reader.read()) != '(') {
                SchemaUtils.throwDecodeException(logger, CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_EXPECTED_OPEN_PARENTHESIS.get(definition, reader.pos() - 1, String.valueOf(c)));
            }
            reader.skipWhitespaces();
            SchemaUtils.readOID(reader, allowMalformedNamesAndOptions);
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readNameDescriptors(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) continue;
                if ("sup".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readOID(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if ("equality".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readOID(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if ("ordering".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readOID(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if ("substr".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readOID(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if ("syntax".equalsIgnoreCase(tokenName)) {
                    SchemaUtils.readOIDLen(reader, allowMalformedNamesAndOptions);
                    continue;
                }
                if ("single-definition".equalsIgnoreCase(tokenName) || "single-value".equalsIgnoreCase(tokenName) || "collective".equalsIgnoreCase(tokenName) || "no-user-modification".equalsIgnoreCase(tokenName)) continue;
                if ("usage".equalsIgnoreCase(tokenName)) {
                    int length = 0;
                    reader.skipWhitespaces();
                    reader.mark();
                    while (" )".indexOf(reader.read()) == -1) {
                        ++length;
                    }
                    reader.reset();
                    String usageStr = reader.read(length);
                    if ("userapplications".equalsIgnoreCase(usageStr) || "directoryoperation".equalsIgnoreCase(usageStr) || "distributedoperation".equalsIgnoreCase(usageStr) || "dsaoperation".equalsIgnoreCase(usageStr)) continue;
                    SchemaUtils.throwDecodeException(logger, CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_ATTRIBUTE_USAGE1.get(definition, usageStr));
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    SchemaUtils.readExtensions(reader);
                    continue;
                }
                SchemaUtils.throwDecodeException(logger, CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_TOKEN1.get(definition, tokenName));
            }
            return true;
        }
        catch (DecodeException de) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_INVALID1.get(definition, de.getMessageObject()));
            return false;
        }
    }
}

