/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.BindResultImpl;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.CompareResultImpl;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResultImpl;
import org.forgerock.opendj.ldap.responses.GenericIntermediateResponse;
import org.forgerock.opendj.ldap.responses.GenericIntermediateResponseImpl;
import org.forgerock.opendj.ldap.responses.PasswordModifyExtendedResult;
import org.forgerock.opendj.ldap.responses.PasswordModifyExtendedResultImpl;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.ResultImpl;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultEntryImpl;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.responses.SearchResultReferenceImpl;
import org.forgerock.opendj.ldap.responses.UnmodifiableBindResultImpl;
import org.forgerock.opendj.ldap.responses.UnmodifiableCompareResultImpl;
import org.forgerock.opendj.ldap.responses.UnmodifiableGenericExtendedResultImpl;
import org.forgerock.opendj.ldap.responses.UnmodifiableGenericIntermediateResponseImpl;
import org.forgerock.opendj.ldap.responses.UnmodifiablePasswordModifyExtendedResultImpl;
import org.forgerock.opendj.ldap.responses.UnmodifiableResultImpl;
import org.forgerock.opendj.ldap.responses.UnmodifiableSearchResultEntryImpl;
import org.forgerock.opendj.ldap.responses.UnmodifiableSearchResultReferenceImpl;
import org.forgerock.opendj.ldap.responses.UnmodifiableWhoAmIExtendedResultImpl;
import org.forgerock.opendj.ldap.responses.WhoAmIExtendedResult;
import org.forgerock.opendj.ldap.responses.WhoAmIExtendedResultImpl;
import org.forgerock.util.Reject;

public final class Responses {
    public static BindResult copyOfBindResult(BindResult result) {
        return new BindResultImpl(result);
    }

    public static CompareResult copyOfCompareResult(CompareResult result) {
        return new CompareResultImpl(result);
    }

    public static GenericExtendedResult copyOfGenericExtendedResult(GenericExtendedResult result) {
        return new GenericExtendedResultImpl(result);
    }

    public static GenericIntermediateResponse copyOfGenericIntermediateResponse(GenericIntermediateResponse result) {
        return new GenericIntermediateResponseImpl(result);
    }

    public static PasswordModifyExtendedResult copyOfPasswordModifyExtendedResult(PasswordModifyExtendedResult result) {
        return new PasswordModifyExtendedResultImpl(result);
    }

    public static Result copyOfResult(Result result) {
        return new ResultImpl(result);
    }

    public static SearchResultEntry copyOfSearchResultEntry(SearchResultEntry entry) {
        return new SearchResultEntryImpl(entry);
    }

    public static SearchResultReference copyOfSearchResultReference(SearchResultReference reference) {
        return new SearchResultReferenceImpl(reference);
    }

    public static WhoAmIExtendedResult copyOfWhoAmIExtendedResult(WhoAmIExtendedResult result) {
        return new WhoAmIExtendedResultImpl(result);
    }

    public static BindResult newBindResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new BindResultImpl(resultCode);
    }

    public static CompareResult newCompareResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new CompareResultImpl(resultCode);
    }

    public static GenericExtendedResult newGenericExtendedResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new GenericExtendedResultImpl(resultCode);
    }

    public static GenericIntermediateResponse newGenericIntermediateResponse() {
        return new GenericIntermediateResponseImpl();
    }

    public static GenericIntermediateResponse newGenericIntermediateResponse(String responseName, Object responseValue) {
        return new GenericIntermediateResponseImpl().setOID(responseName).setValue(responseValue);
    }

    public static PasswordModifyExtendedResult newPasswordModifyExtendedResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new PasswordModifyExtendedResultImpl(resultCode);
    }

    public static Result newResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new ResultImpl(resultCode);
    }

    public static SearchResultEntry newSearchResultEntry(DN name) {
        Entry entry = new LinkedHashMapEntry().setName(name);
        return new SearchResultEntryImpl(entry);
    }

    public static SearchResultEntry newSearchResultEntry(Entry entry) {
        Reject.ifNull(entry);
        return new SearchResultEntryImpl(entry);
    }

    public static SearchResultEntry newSearchResultEntry(SearchResultEntry entry) {
        Reject.ifNull(entry);
        return new SearchResultEntryImpl(entry);
    }

    public static SearchResultEntry newSearchResultEntry(String name) {
        Entry entry = new LinkedHashMapEntry().setName(name);
        return new SearchResultEntryImpl(entry);
    }

    public static SearchResultEntry newSearchResultEntry(String ... ldifLines) {
        return Responses.newSearchResultEntry(new LinkedHashMapEntry(ldifLines));
    }

    public static SearchResultReference newSearchResultReference(String uri) {
        Reject.ifNull(uri);
        return new SearchResultReferenceImpl(uri);
    }

    public static WhoAmIExtendedResult newWhoAmIExtendedResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new WhoAmIExtendedResultImpl(ResultCode.SUCCESS);
    }

    public static BindResult unmodifiableBindResult(BindResult result) {
        if (result instanceof UnmodifiableBindResultImpl) {
            return result;
        }
        return new UnmodifiableBindResultImpl(result);
    }

    public static CompareResult unmodifiableCompareResult(CompareResult result) {
        if (result instanceof UnmodifiableCompareResultImpl) {
            return result;
        }
        return new UnmodifiableCompareResultImpl(result);
    }

    public static GenericExtendedResult unmodifiableGenericExtendedResult(GenericExtendedResult result) {
        if (result instanceof UnmodifiableGenericExtendedResultImpl) {
            return result;
        }
        return new UnmodifiableGenericExtendedResultImpl(result);
    }

    public static GenericIntermediateResponse unmodifiableGenericIntermediateResponse(GenericIntermediateResponse response) {
        if (response instanceof UnmodifiableGenericIntermediateResponseImpl) {
            return response;
        }
        return new UnmodifiableGenericIntermediateResponseImpl(response);
    }

    public static PasswordModifyExtendedResult unmodifiablePasswordModifyExtendedResult(PasswordModifyExtendedResult result) {
        if (result instanceof UnmodifiablePasswordModifyExtendedResultImpl) {
            return result;
        }
        return new UnmodifiablePasswordModifyExtendedResultImpl(result);
    }

    public static Result unmodifiableResult(Result result) {
        if (result instanceof UnmodifiableResultImpl) {
            return result;
        }
        return new UnmodifiableResultImpl(result);
    }

    public static SearchResultEntry unmodifiableSearchResultEntry(SearchResultEntry entry) {
        if (entry instanceof UnmodifiableSearchResultEntryImpl) {
            return entry;
        }
        return new UnmodifiableSearchResultEntryImpl(entry);
    }

    public static SearchResultReference unmodifiableSearchResultReference(SearchResultReference reference) {
        if (reference instanceof UnmodifiableSearchResultReferenceImpl) {
            return reference;
        }
        return new UnmodifiableSearchResultReferenceImpl(reference);
    }

    public static WhoAmIExtendedResult unmodifiableWhoAmIExtendedResult(WhoAmIExtendedResult result) {
        if (result instanceof UnmodifiableSearchResultReferenceImpl) {
            return result;
        }
        return new UnmodifiableWhoAmIExtendedResultImpl(result);
    }

    private Responses() {
    }
}

