/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.responses.AbstractExtendedResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;

final class GenericExtendedResultImpl
extends AbstractExtendedResult<GenericExtendedResult>
implements ExtendedResult,
GenericExtendedResult {
    private String responseName;
    private ByteString responseValue;

    GenericExtendedResultImpl(GenericExtendedResult genericExtendedResult) {
        super(genericExtendedResult);
        this.responseName = genericExtendedResult.getOID();
        this.responseValue = genericExtendedResult.getValue();
    }

    GenericExtendedResultImpl(ResultCode resultCode) {
        super(resultCode);
    }

    @Override
    public String getOID() {
        return this.responseName;
    }

    @Override
    public ByteString getValue() {
        return this.responseValue;
    }

    @Override
    public boolean hasValue() {
        return this.responseValue != null;
    }

    @Override
    public GenericExtendedResult setOID(String oid) {
        this.responseName = oid;
        return this;
    }

    @Override
    public GenericExtendedResult setValue(Object value) {
        this.responseValue = value != null ? ByteString.valueOfObject(value) : null;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GenericExtendedResult(resultCode=");
        builder.append(this.getResultCode());
        builder.append(", matchedDN=");
        builder.append(this.getMatchedDN());
        builder.append(", diagnosticMessage=");
        builder.append(this.getDiagnosticMessage());
        builder.append(", referrals=");
        builder.append(this.getReferralURIs());
        builder.append(", responseName=");
        builder.append(this.getOID() == null ? "" : this.getOID());
        if (this.hasValue()) {
            builder.append(", responseValue=");
            builder.append(this.getValue().toHexPlusAsciiString(4));
        }
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }
}

