/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.requests.AbstractBindRequest;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.BindClientImpl;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.util.Reject;

final class SimpleBindRequestImpl
extends AbstractBindRequest<SimpleBindRequest>
implements SimpleBindRequest {
    private String name = "".intern();
    private byte[] password = new byte[0];

    SimpleBindRequestImpl(SimpleBindRequest simpleBindRequest) {
        super(simpleBindRequest);
        this.name = simpleBindRequest.getName();
        this.password = StaticUtils.copyOfBytes(simpleBindRequest.getPassword());
    }

    SimpleBindRequestImpl(String name, byte[] password) {
        this.name = name;
        this.password = password;
    }

    @Override
    public BindClient createBindClient(String serverName) throws LdapException {
        return new BindClientImpl(this).setNextAuthenticationValue(this.password);
    }

    @Override
    public byte getAuthenticationType() {
        return -128;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] getPassword() {
        return this.password;
    }

    @Override
    public SimpleBindRequest setName(String name) {
        Reject.ifNull(name);
        this.name = name;
        return this;
    }

    @Override
    public SimpleBindRequest setPassword(byte[] password) {
        Reject.ifNull((Object)password);
        this.password = password;
        return this;
    }

    @Override
    public SimpleBindRequest setPassword(char[] password) {
        Reject.ifNull((Object)password);
        this.password = StaticUtils.getBytes(password);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SimpleBindRequest(name=");
        builder.append(this.getName());
        builder.append(", authentication=simple");
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }
}

