/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import java.util.LinkedList;
import java.util.List;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.requests.AbstractRequestImpl;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldif.ChangeRecordVisitor;
import org.forgerock.util.Reject;

final class ModifyRequestImpl
extends AbstractRequestImpl<ModifyRequest>
implements ModifyRequest {
    private final List<Modification> changes = new LinkedList<Modification>();
    private DN name;

    ModifyRequestImpl(DN name) {
        this.name = name;
    }

    ModifyRequestImpl(ModifyRequest modifyRequest) {
        super(modifyRequest);
        this.name = modifyRequest.getName();
        for (Modification modification : modifyRequest.getModifications()) {
            ModificationType type = modification.getModificationType();
            LinkedAttribute attribute = new LinkedAttribute(modification.getAttribute());
            Modification copy = new Modification(type, attribute);
            this.changes.add(copy);
        }
    }

    @Override
    public <R, P> R accept(ChangeRecordVisitor<R, P> v, P p) {
        return v.visitChangeRecord(p, this);
    }

    @Override
    public ModifyRequest addModification(Modification change) {
        Reject.ifNull(change);
        this.changes.add(change);
        return this;
    }

    @Override
    public ModifyRequest addModification(ModificationType type, String attributeDescription, Object ... values) {
        Reject.ifNull(type, attributeDescription);
        Reject.ifNull(values);
        this.changes.add(new Modification(type, new LinkedAttribute(attributeDescription, values)));
        return this;
    }

    @Override
    public List<Modification> getModifications() {
        return this.changes;
    }

    @Override
    public DN getName() {
        return this.name;
    }

    @Override
    public ModifyRequest setName(DN dn) {
        Reject.ifNull(dn);
        this.name = dn;
        return this;
    }

    @Override
    public ModifyRequest setName(String dn) {
        Reject.ifNull(dn);
        this.name = DN.valueOf(dn);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModifyRequest(dn=");
        builder.append(this.getName());
        builder.append(", changes=");
        builder.append(this.getModifications());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    ModifyRequest getThis() {
        return this;
    }
}

