/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.requests.AbstractRequestImpl;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldif.ChangeRecordVisitor;
import org.forgerock.util.Reject;

final class DeleteRequestImpl
extends AbstractRequestImpl<DeleteRequest>
implements DeleteRequest {
    private DN name;

    DeleteRequestImpl(DeleteRequest deleteRequest) {
        super(deleteRequest);
        this.name = deleteRequest.getName();
    }

    DeleteRequestImpl(DN name) {
        this.name = name;
    }

    @Override
    public <R, P> R accept(ChangeRecordVisitor<R, P> v, P p) {
        return v.visitChangeRecord(p, this);
    }

    @Override
    public DN getName() {
        return this.name;
    }

    @Override
    public DeleteRequest setName(DN dn) {
        Reject.ifNull(dn);
        this.name = dn;
        return this;
    }

    @Override
    public DeleteRequest setName(String dn) {
        Reject.ifNull(dn);
        this.name = DN.valueOf(dn);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeleteRequest(name=");
        builder.append(this.getName());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    DeleteRequest getThis() {
        return this;
    }
}

