/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class SubtreeDeleteRequestControl
implements Control {
    public static final String OID = "1.2.840.113556.1.4.805";
    private static final SubtreeDeleteRequestControl CRITICAL_INSTANCE = new SubtreeDeleteRequestControl(true);
    private static final SubtreeDeleteRequestControl NONCRITICAL_INSTANCE = new SubtreeDeleteRequestControl(false);
    public static final ControlDecoder<SubtreeDeleteRequestControl> DECODER = new ControlDecoder<SubtreeDeleteRequestControl>(){

        @Override
        public SubtreeDeleteRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull(control);
            if (control instanceof SubtreeDeleteRequestControl) {
                return (SubtreeDeleteRequestControl)control;
            }
            if (!control.getOID().equals(SubtreeDeleteRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_SUBTREE_DELETE_CONTROL_BAD_OID.get(control.getOID(), SubtreeDeleteRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_SUBTREE_DELETE_INVALID_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            return control.isCritical() ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
        }

        @Override
        public String getOID() {
            return SubtreeDeleteRequestControl.OID;
        }
    };
    private final boolean isCritical;

    public static SubtreeDeleteRequestControl newControl(boolean isCritical) {
        return isCritical ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
    }

    private SubtreeDeleteRequestControl(boolean isCritical) {
        this.isCritical = isCritical;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        return null;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SubtreeDeleteRequestControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(")");
        return builder.toString();
    }
}

