/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.util.Reject;

public final class ServerSideSortResponseControl
implements Control {
    public static final String OID = "1.2.840.113556.1.4.474";
    public static final ControlDecoder<ServerSideSortResponseControl> DECODER = new ControlDecoder<ServerSideSortResponseControl>(){

        @Override
        public ServerSideSortResponseControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull(control, options);
            if (control instanceof ServerSideSortResponseControl) {
                return (ServerSideSortResponseControl)control;
            }
            if (!control.getOID().equals(ServerSideSortResponseControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_SORTRES_CONTROL_BAD_OID.get(control.getOID(), ServerSideSortResponseControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.INFO_SORTRES_CONTROL_NO_VALUE.get();
                throw DecodeException.error(message);
            }
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                reader.readStartSequence();
                ResultCode result = ResultCode.valueOf(reader.readEnumerated());
                AttributeDescription attributeDescription = null;
                if (reader.hasNextElement()) {
                    Schema schema = options.getSchemaResolver().resolveSchema("");
                    String ads = reader.readOctetStringAsString();
                    attributeDescription = AttributeDescription.valueOf(ads, schema);
                }
                return new ServerSideSortResponseControl(control.isCritical(), result, attributeDescription);
            }
            catch (IOException | LocalizedIllegalArgumentException e) {
                LocalizableMessage message = CoreMessages.INFO_SORTRES_CONTROL_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message, e);
            }
        }

        @Override
        public String getOID() {
            return ServerSideSortResponseControl.OID;
        }
    };
    private static final byte TYPE_ATTRIBUTE_TYPE = -128;
    private final ResultCode result;
    private final AttributeDescription attributeDescription;
    private final boolean isCritical;

    public static ServerSideSortResponseControl newControl(ResultCode result) {
        Reject.ifNull(result);
        return new ServerSideSortResponseControl(false, result, null);
    }

    public static ServerSideSortResponseControl newControl(ResultCode result, AttributeDescription attributeDescription) {
        Reject.ifNull(result);
        return new ServerSideSortResponseControl(false, result, attributeDescription);
    }

    public static ServerSideSortResponseControl newControl(ResultCode result, String attributeDescription) {
        Reject.ifNull(result);
        if (attributeDescription != null) {
            return new ServerSideSortResponseControl(false, result, AttributeDescription.valueOf(attributeDescription));
        }
        return new ServerSideSortResponseControl(false, result, null);
    }

    private ServerSideSortResponseControl(boolean isCritical, ResultCode result, AttributeDescription attributeDescription) {
        this.isCritical = isCritical;
        this.result = result;
        this.attributeDescription = attributeDescription;
    }

    public AttributeDescription getAttributeDescription() {
        return this.attributeDescription;
    }

    @Override
    public String getOID() {
        return OID;
    }

    public ResultCode getResult() {
        return this.result;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            writer.writeEnumerated(this.result.intValue());
            if (this.attributeDescription != null) {
                writer.writeOctetString((byte)-128, this.attributeDescription.toString());
            }
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ServerSideSortResponseControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", result=");
        builder.append(this.result);
        if (this.attributeDescription != null) {
            builder.append(", attributeDescription=");
            builder.append(this.attributeDescription);
        }
        builder.append(")");
        return builder.toString();
    }
}

