/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.SortKey;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class ServerSideSortRequestControl
implements Control {
    public static final String OID = "1.2.840.113556.1.4.473";
    private static final byte TYPE_ORDERING_RULE_ID = -128;
    private static final byte TYPE_REVERSE_ORDER = -127;
    public static final ControlDecoder<ServerSideSortRequestControl> DECODER = new ControlDecoder<ServerSideSortRequestControl>(){

        @Override
        public ServerSideSortRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull(control);
            if (control instanceof ServerSideSortRequestControl) {
                return (ServerSideSortRequestControl)control;
            }
            if (!control.getOID().equals(ServerSideSortRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_SORTREQ_CONTROL_BAD_OID.get(control.getOID(), ServerSideSortRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.INFO_SORTREQ_CONTROL_NO_VALUE.get();
                throw DecodeException.error(message);
            }
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                reader.readStartSequence();
                if (!reader.hasNextElement()) {
                    LocalizableMessage message = CoreMessages.INFO_SORTREQ_CONTROL_NO_SORT_KEYS.get();
                    throw DecodeException.error(message);
                }
                LinkedList<SortKey> keys = new LinkedList<SortKey>();
                while (reader.hasNextElement()) {
                    reader.readStartSequence();
                    String attrName = reader.readOctetStringAsString();
                    String orderingRule = null;
                    boolean reverseOrder = false;
                    if (reader.hasNextElement() && reader.peekType() == -128) {
                        orderingRule = reader.readOctetStringAsString();
                    }
                    if (reader.hasNextElement() && reader.peekType() == -127) {
                        reverseOrder = reader.readBoolean();
                    }
                    reader.readEndSequence();
                    keys.add(new SortKey(attrName, reverseOrder, orderingRule));
                }
                reader.readEndSequence();
                return new ServerSideSortRequestControl(control.isCritical(), Collections.unmodifiableList(keys));
            }
            catch (IOException e) {
                LocalizableMessage message = CoreMessages.INFO_SORTREQ_CONTROL_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message, e);
            }
        }

        @Override
        public String getOID() {
            return ServerSideSortRequestControl.OID;
        }
    };
    private final List<SortKey> sortKeys;
    private final boolean isCritical;

    public static ServerSideSortRequestControl newControl(boolean isCritical, Collection<SortKey> keys) {
        Reject.ifNull(keys);
        Reject.ifFalse(!keys.isEmpty(), "keys must not be empty");
        return new ServerSideSortRequestControl(isCritical, Collections.unmodifiableList(new ArrayList<SortKey>(keys)));
    }

    public static ServerSideSortRequestControl newControl(boolean isCritical, SortKey ... keys) {
        return ServerSideSortRequestControl.newControl(isCritical, Arrays.asList(keys));
    }

    public static ServerSideSortRequestControl newControl(boolean isCritical, String sortKeys) {
        Reject.ifNull(sortKeys);
        LinkedList<SortKey> keys = new LinkedList<SortKey>();
        StringTokenizer tokenizer = new StringTokenizer(sortKeys, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            keys.add(SortKey.valueOf(token));
        }
        if (keys.isEmpty()) {
            LocalizableMessage message = CoreMessages.ERR_SORT_KEY_NO_SORT_KEYS.get(sortKeys);
            throw new LocalizedIllegalArgumentException(message);
        }
        return new ServerSideSortRequestControl(isCritical, Collections.unmodifiableList(keys));
    }

    private ServerSideSortRequestControl(boolean isCritical, List<SortKey> keys) {
        this.isCritical = isCritical;
        this.sortKeys = keys;
    }

    @Override
    public String getOID() {
        return OID;
    }

    public List<SortKey> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            for (SortKey sortKey : this.sortKeys) {
                writer.writeStartSequence();
                writer.writeOctetString(sortKey.getAttributeDescription());
                if (sortKey.getOrderingMatchingRule() != null) {
                    writer.writeOctetString((byte)-128, sortKey.getOrderingMatchingRule());
                }
                if (sortKey.isReverseOrder()) {
                    writer.writeBoolean((byte)-127, true);
                }
                writer.writeEndSequence();
            }
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ServerSideSortRequestControl(oid=");
        buffer.append(this.getOID());
        buffer.append(", criticality=");
        buffer.append(this.isCritical());
        buffer.append(", sortKeys=");
        buffer.append(this.sortKeys);
        buffer.append(")");
        return buffer.toString();
    }
}

