/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class PostReadRequestControl
implements Control {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String OID = "1.3.6.1.1.13.2";
    private final List<String> attributes;
    private final boolean isCritical;
    private static final PostReadRequestControl CRITICAL_EMPTY_INSTANCE = new PostReadRequestControl(true, Collections.emptyList());
    private static final PostReadRequestControl NONCRITICAL_EMPTY_INSTANCE = new PostReadRequestControl(false, Collections.emptyList());
    public static final ControlDecoder<PostReadRequestControl> DECODER = new ControlDecoder<PostReadRequestControl>(){

        @Override
        public PostReadRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            List<Object> attributes;
            Reject.ifNull(control);
            if (control instanceof PostReadRequestControl) {
                return (PostReadRequestControl)control;
            }
            if (!control.getOID().equals(PostReadRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_POSTREAD_CONTROL_BAD_OID.get(control.getOID(), PostReadRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_POSTREADREQ_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                reader.readStartSequence();
                if (reader.hasNextElement()) {
                    String firstAttribute = reader.readOctetStringAsString();
                    if (reader.hasNextElement()) {
                        attributes = new ArrayList();
                        attributes.add(firstAttribute);
                        do {
                            attributes.add(reader.readOctetStringAsString());
                        } while (reader.hasNextElement());
                        attributes = Collections.unmodifiableList(attributes);
                    } else {
                        attributes = Collections.singletonList(firstAttribute);
                    }
                } else {
                    attributes = Collections.emptyList();
                }
                reader.readEndSequence();
            }
            catch (Exception ae) {
                logger.debug(LocalizableMessage.raw("Unable to read sequence", ae));
                LocalizableMessage message = CoreMessages.ERR_POSTREADREQ_CANNOT_DECODE_VALUE.get(ae.getMessage());
                throw DecodeException.error(message, ae);
            }
            if (attributes.isEmpty()) {
                return control.isCritical() ? CRITICAL_EMPTY_INSTANCE : NONCRITICAL_EMPTY_INSTANCE;
            }
            return new PostReadRequestControl(control.isCritical(), attributes);
        }

        @Override
        public String getOID() {
            return PostReadRequestControl.OID;
        }
    };

    public static PostReadRequestControl newControl(boolean isCritical, Collection<String> attributes) {
        Reject.ifNull(attributes);
        if (attributes.isEmpty()) {
            return isCritical ? CRITICAL_EMPTY_INSTANCE : NONCRITICAL_EMPTY_INSTANCE;
        }
        if (attributes.size() == 1) {
            return new PostReadRequestControl(isCritical, Collections.singletonList(attributes.iterator().next()));
        }
        return new PostReadRequestControl(isCritical, Collections.unmodifiableList(new ArrayList<String>(attributes)));
    }

    public static PostReadRequestControl newControl(boolean isCritical, String ... attributes) {
        Reject.ifNull(attributes);
        if (attributes.length == 0) {
            return isCritical ? CRITICAL_EMPTY_INSTANCE : NONCRITICAL_EMPTY_INSTANCE;
        }
        if (attributes.length == 1) {
            return new PostReadRequestControl(isCritical, Collections.singletonList(attributes[0]));
        }
        return new PostReadRequestControl(isCritical, Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(attributes))));
    }

    private PostReadRequestControl(boolean isCritical, List<String> attributes) {
        this.isCritical = isCritical;
        this.attributes = attributes;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            if (this.attributes != null) {
                for (String attr : this.attributes) {
                    writer.writeOctetString(attr);
                }
            }
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PostReadRequestControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", attributes=");
        builder.append(this.attributes);
        builder.append(")");
        return builder.toString();
    }
}

