/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.controls.PersistentSearchChangeType;
import org.forgerock.util.Reject;

public final class PersistentSearchRequestControl
implements Control {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String OID = "2.16.840.1.113730.3.4.3";
    public static final ControlDecoder<PersistentSearchRequestControl> DECODER = new ControlDecoder<PersistentSearchRequestControl>(){

        @Override
        public PersistentSearchRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            boolean returnECs;
            boolean changesOnly;
            int changeTypes;
            Reject.ifNull(control);
            if (control instanceof PersistentSearchRequestControl) {
                return (PersistentSearchRequestControl)control;
            }
            if (!control.getOID().equals(PersistentSearchRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_PSEARCH_CONTROL_BAD_OID.get(control.getOID(), PersistentSearchRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_PSEARCH_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                reader.readStartSequence();
                changeTypes = (int)reader.readInteger();
                changesOnly = reader.readBoolean();
                returnECs = reader.readBoolean();
                reader.readEndSequence();
            }
            catch (IOException e) {
                logger.debug(LocalizableMessage.raw("Unable to read sequence", e));
                LocalizableMessage message = CoreMessages.ERR_PSEARCH_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message, e);
            }
            EnumSet<PersistentSearchChangeType> changeTypeSet = EnumSet.noneOf(PersistentSearchChangeType.class);
            if ((changeTypes & 0xF) != 0) {
                LocalizableMessage message = CoreMessages.ERR_PSEARCH_BAD_CHANGE_TYPES.get(changeTypes);
                throw DecodeException.error(message);
            }
            if ((changeTypes & 1) != 0) {
                changeTypeSet.add(PersistentSearchChangeType.ADD);
            }
            if ((changeTypes & 2) != 0) {
                changeTypeSet.add(PersistentSearchChangeType.DELETE);
            }
            if ((changeTypes & 4) != 0) {
                changeTypeSet.add(PersistentSearchChangeType.MODIFY);
            }
            if ((changeTypes & 8) != 0) {
                changeTypeSet.add(PersistentSearchChangeType.MODIFY_DN);
            }
            return new PersistentSearchRequestControl(control.isCritical(), changesOnly, returnECs, Collections.unmodifiableSet(changeTypeSet));
        }

        @Override
        public String getOID() {
            return PersistentSearchRequestControl.OID;
        }
    };
    private final boolean changesOnly;
    private final boolean returnECs;
    private final Set<PersistentSearchChangeType> changeTypes;
    private final boolean isCritical;

    public static PersistentSearchRequestControl newControl(boolean isCritical, boolean changesOnly, boolean returnECs, Collection<PersistentSearchChangeType> changeTypes) {
        Reject.ifNull(changeTypes);
        EnumSet<PersistentSearchChangeType> copyOfChangeTypes = EnumSet.noneOf(PersistentSearchChangeType.class);
        copyOfChangeTypes.addAll(changeTypes);
        return new PersistentSearchRequestControl(isCritical, changesOnly, returnECs, Collections.unmodifiableSet(copyOfChangeTypes));
    }

    public static PersistentSearchRequestControl newControl(boolean isCritical, boolean changesOnly, boolean returnECs, PersistentSearchChangeType ... changeTypes) {
        Reject.ifNull(changeTypes);
        return PersistentSearchRequestControl.newControl(isCritical, changesOnly, returnECs, Arrays.asList(changeTypes));
    }

    private PersistentSearchRequestControl(boolean isCritical, boolean changesOnly, boolean returnECs, Set<PersistentSearchChangeType> changeTypes) {
        this.isCritical = isCritical;
        this.changesOnly = changesOnly;
        this.returnECs = returnECs;
        this.changeTypes = changeTypes;
    }

    public Set<PersistentSearchChangeType> getChangeTypes() {
        return this.changeTypes;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            int changeTypesInt = 0;
            for (PersistentSearchChangeType changeType : this.changeTypes) {
                changeTypesInt |= changeType.intValue();
            }
            writer.writeInteger(changeTypesInt);
            writer.writeBoolean(this.changesOnly);
            writer.writeBoolean(this.returnECs);
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    public boolean isChangesOnly() {
        return this.changesOnly;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public boolean isReturnECs() {
        return this.returnECs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PersistentSearchRequestControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", changeTypes=[");
        boolean comma = false;
        for (PersistentSearchChangeType type : this.changeTypes) {
            if (comma) {
                builder.append(", ");
            }
            builder.append((Object)type);
            comma = true;
        }
        builder.append("](");
        builder.append(this.changeTypes);
        builder.append("), changesOnly=");
        builder.append(this.changesOnly);
        builder.append(", returnECs=");
        builder.append(this.returnECs);
        builder.append(")");
        return builder.toString();
    }
}

