/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class PermissiveModifyRequestControl
implements Control {
    public static final String OID = "1.2.840.113556.1.4.1413";
    private static final PermissiveModifyRequestControl CRITICAL_INSTANCE = new PermissiveModifyRequestControl(true);
    private static final PermissiveModifyRequestControl NONCRITICAL_INSTANCE = new PermissiveModifyRequestControl(false);
    public static final ControlDecoder<PermissiveModifyRequestControl> DECODER = new ControlDecoder<PermissiveModifyRequestControl>(){

        @Override
        public PermissiveModifyRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull(control);
            if (control instanceof PermissiveModifyRequestControl) {
                return (PermissiveModifyRequestControl)control;
            }
            if (!control.getOID().equals(PermissiveModifyRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_PERMISSIVE_MODIFY_CONTROL_BAD_OID.get(control.getOID(), PermissiveModifyRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_PERMISSIVE_MODIFY_INVALID_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            return control.isCritical() ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
        }

        @Override
        public String getOID() {
            return PermissiveModifyRequestControl.OID;
        }
    };
    private final boolean isCritical;

    public static PermissiveModifyRequestControl newControl(boolean isCritical) {
        return isCritical ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
    }

    private PermissiveModifyRequestControl(boolean isCritical) {
        this.isCritical = isCritical;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        return null;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PermissiveModifyRequestControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(")");
        return builder.toString();
    }
}

