/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class PasswordPolicyRequestControl
implements Control {
    public static final String OID = "1.3.6.1.4.1.42.2.27.8.5.1";
    private final boolean isCritical;
    private static final PasswordPolicyRequestControl CRITICAL_INSTANCE = new PasswordPolicyRequestControl(true);
    private static final PasswordPolicyRequestControl NONCRITICAL_INSTANCE = new PasswordPolicyRequestControl(false);
    public static final ControlDecoder<PasswordPolicyRequestControl> DECODER = new ControlDecoder<PasswordPolicyRequestControl>(){

        @Override
        public PasswordPolicyRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull(control);
            if (control instanceof PasswordPolicyRequestControl) {
                return (PasswordPolicyRequestControl)control;
            }
            if (!control.getOID().equals(PasswordPolicyRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_PWPOLICYREQ_CONTROL_BAD_OID.get(control.getOID(), PasswordPolicyRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_PWPOLICYREQ_CONTROL_HAS_VALUE.get();
                throw DecodeException.error(message);
            }
            return control.isCritical() ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
        }

        @Override
        public String getOID() {
            return PasswordPolicyRequestControl.OID;
        }
    };

    public static PasswordPolicyRequestControl newControl(boolean isCritical) {
        return isCritical ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
    }

    private PasswordPolicyRequestControl(boolean isCritical) {
        this.isCritical = isCritical;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        return null;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PasswordPolicyRequestControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(")");
        return builder.toString();
    }
}

