/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.io.LDAP;
import org.forgerock.opendj.ldap.AbstractFilterVisitor;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class MatchedValuesRequestControl
implements Control {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String OID = "1.2.826.0.1.3344810.2.3";
    public static final ControlDecoder<MatchedValuesRequestControl> DECODER = new ControlDecoder<MatchedValuesRequestControl>(){

        @Override
        public MatchedValuesRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull(control);
            if (control instanceof MatchedValuesRequestControl) {
                return (MatchedValuesRequestControl)control;
            }
            if (!control.getOID().equals(MatchedValuesRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_MATCHEDVALUES_CONTROL_BAD_OID.get(control.getOID(), MatchedValuesRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_MATCHEDVALUES_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                reader.readStartSequence();
                if (!reader.hasNextElement()) {
                    LocalizableMessage message = CoreMessages.ERR_MATCHEDVALUES_NO_FILTERS.get();
                    throw DecodeException.error(message);
                }
                LinkedList<Filter> filters = new LinkedList<Filter>();
                do {
                    Filter filter = LDAP.readFilter(reader);
                    try {
                        MatchedValuesRequestControl.validateFilter(filter);
                    }
                    catch (LocalizedIllegalArgumentException e) {
                        throw DecodeException.error(e.getMessageObject());
                    }
                    filters.add(filter);
                } while (reader.hasNextElement());
                reader.readEndSequence();
                return new MatchedValuesRequestControl(control.isCritical(), Collections.unmodifiableList(filters));
            }
            catch (IOException e) {
                logger.debug(LocalizableMessage.raw("%s", e));
                LocalizableMessage message = CoreMessages.ERR_MATCHEDVALUES_CANNOT_DECODE_VALUE_AS_SEQUENCE.get(StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message);
            }
        }

        @Override
        public String getOID() {
            return MatchedValuesRequestControl.OID;
        }
    };
    private static final FilterValidator FILTER_VALIDATOR = new FilterValidator();
    private final Collection<Filter> filters;
    private final boolean isCritical;

    public static MatchedValuesRequestControl newControl(boolean isCritical, Collection<Filter> filters) {
        List<Object> copyOfFilters;
        Reject.ifNull(filters);
        Reject.ifFalse(filters.size() > 0, "filters is empty");
        if (filters.size() == 1) {
            copyOfFilters = Collections.singletonList(MatchedValuesRequestControl.validateFilter(filters.iterator().next()));
        } else {
            copyOfFilters = new ArrayList(filters.size());
            for (Filter filter : filters) {
                copyOfFilters.add(MatchedValuesRequestControl.validateFilter(filter));
            }
            copyOfFilters = Collections.unmodifiableList(copyOfFilters);
        }
        return new MatchedValuesRequestControl(isCritical, copyOfFilters);
    }

    public static MatchedValuesRequestControl newControl(boolean isCritical, String ... filters) {
        Reject.ifFalse(filters.length > 0, "filters is empty");
        ArrayList<Filter> parsedFilters = new ArrayList<Filter>(filters.length);
        for (String filter : filters) {
            parsedFilters.add(MatchedValuesRequestControl.validateFilter(Filter.valueOf(filter)));
        }
        return new MatchedValuesRequestControl(isCritical, Collections.unmodifiableList(parsedFilters));
    }

    private static Filter validateFilter(Filter filter) {
        LocalizedIllegalArgumentException e = filter.accept(FILTER_VALIDATOR, filter);
        if (e != null) {
            throw e;
        }
        return filter;
    }

    private MatchedValuesRequestControl(boolean isCritical, Collection<Filter> filters) {
        this.isCritical = isCritical;
        this.filters = filters;
    }

    public Collection<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            for (Filter f : this.filters) {
                LDAP.writeFilter(writer, f);
            }
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MatchedValuesRequestControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(")");
        return builder.toString();
    }

    private static final class FilterValidator
    extends AbstractFilterVisitor<LocalizedIllegalArgumentException, Filter> {
        private FilterValidator() {
        }

        @Override
        public LocalizedIllegalArgumentException visitAndFilter(Filter p, List<Filter> subFilters) {
            LocalizableMessage message = CoreMessages.ERR_MVFILTER_BAD_FILTER_AND.get(p.toString());
            return new LocalizedIllegalArgumentException(message);
        }

        @Override
        public LocalizedIllegalArgumentException visitExtensibleMatchFilter(Filter p, String matchingRule, String attributeDescription, ByteString assertionValue, boolean dnAttributes) {
            if (dnAttributes) {
                LocalizableMessage message = CoreMessages.ERR_MVFILTER_BAD_FILTER_EXT.get(p.toString());
                return new LocalizedIllegalArgumentException(message);
            }
            return null;
        }

        @Override
        public LocalizedIllegalArgumentException visitNotFilter(Filter p, Filter subFilter) {
            LocalizableMessage message = CoreMessages.ERR_MVFILTER_BAD_FILTER_NOT.get(p.toString());
            return new LocalizedIllegalArgumentException(message);
        }

        @Override
        public LocalizedIllegalArgumentException visitOrFilter(Filter p, List<Filter> subFilters) {
            LocalizableMessage message = CoreMessages.ERR_MVFILTER_BAD_FILTER_OR.get(p.toString());
            return new LocalizedIllegalArgumentException(message);
        }

        @Override
        public LocalizedIllegalArgumentException visitUnrecognizedFilter(Filter p, byte filterTag, ByteString filterBytes) {
            LocalizableMessage message = CoreMessages.ERR_MVFILTER_BAD_FILTER_UNRECOGNIZED.get(p.toString(), filterTag);
            return new LocalizedIllegalArgumentException(message);
        }
    }
}

