/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.util.Reject;

public final class SortKey {
    private final String attributeDescription;
    private final String orderingMatchingRule;
    private final boolean isReverseOrder;

    public static Comparator<Entry> comparator(Collection<SortKey> keys) {
        return SortKey.comparator(Schema.getDefaultSchema(), keys);
    }

    public static Comparator<Entry> comparator(Schema schema, Collection<SortKey> keys) {
        Reject.ifNull(schema, keys);
        Reject.ifFalse(!keys.isEmpty(), "keys must not be empty");
        ArrayList<Comparator<Entry>> comparators = new ArrayList<Comparator<Entry>>(keys.size());
        for (SortKey key : keys) {
            comparators.add(key.comparator(schema));
        }
        return new CompositeEntryComparator(comparators);
    }

    public static Comparator<Entry> comparator(Schema schema, SortKey ... keys) {
        return SortKey.comparator(schema, Arrays.asList(keys));
    }

    public static Comparator<Entry> comparator(SortKey ... keys) {
        return SortKey.comparator(Schema.getDefaultSchema(), keys);
    }

    public static Comparator<Entry> comparator(String sortKeys) {
        Reject.ifNull(sortKeys);
        LinkedList<Comparator<Entry>> comparators = new LinkedList<Comparator<Entry>>();
        StringTokenizer tokenizer = new StringTokenizer(sortKeys, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            comparators.add(SortKey.valueOf(token).comparator());
        }
        if (comparators.isEmpty()) {
            LocalizableMessage message = CoreMessages.ERR_SORT_KEY_NO_SORT_KEYS.get(sortKeys);
            throw new LocalizedIllegalArgumentException(message);
        }
        return new CompositeEntryComparator(comparators);
    }

    public static SortKey valueOf(String sortKey) {
        Reject.ifNull(sortKey);
        boolean reverseOrder = false;
        if (sortKey.startsWith("-")) {
            reverseOrder = true;
            sortKey = sortKey.substring(1);
        } else if (sortKey.startsWith("+")) {
            sortKey = sortKey.substring(1);
        }
        int colonPos = sortKey.indexOf(58);
        if (colonPos < 0) {
            if (sortKey.length() == 0) {
                LocalizableMessage message = CoreMessages.ERR_SORT_KEY_NO_ATTR_NAME.get(sortKey);
                throw new LocalizedIllegalArgumentException(message);
            }
            return new SortKey(sortKey, reverseOrder, null);
        }
        if (colonPos == 0) {
            LocalizableMessage message = CoreMessages.ERR_SORT_KEY_NO_ATTR_NAME.get(sortKey);
            throw new LocalizedIllegalArgumentException(message);
        }
        if (colonPos == sortKey.length() - 1) {
            LocalizableMessage message = CoreMessages.ERR_SORT_KEY_NO_MATCHING_RULE.get(sortKey);
            throw new LocalizedIllegalArgumentException(message);
        }
        String attrName = sortKey.substring(0, colonPos);
        String ruleID = sortKey.substring(colonPos + 1);
        return new SortKey(attrName, reverseOrder, ruleID);
    }

    public SortKey(AttributeDescription attributeDescription, boolean isReverseOrder, MatchingRule orderingMatchingRule) {
        Reject.ifNull(attributeDescription);
        this.attributeDescription = attributeDescription.toString();
        this.orderingMatchingRule = orderingMatchingRule != null ? orderingMatchingRule.getNameOrOID() : null;
        this.isReverseOrder = isReverseOrder;
    }

    public SortKey(String attributeDescription) {
        this(attributeDescription, false, null);
    }

    public SortKey(String attributeDescription, boolean isReverseOrder) {
        this(attributeDescription, isReverseOrder, null);
    }

    public SortKey(String attributeDescription, boolean isReverseOrder, String orderingMatchingRule) {
        Reject.ifNull(attributeDescription);
        this.attributeDescription = attributeDescription;
        this.orderingMatchingRule = orderingMatchingRule;
        this.isReverseOrder = isReverseOrder;
    }

    public Comparator<Entry> comparator() {
        return this.comparator(Schema.getDefaultSchema());
    }

    public Comparator<Entry> comparator(Schema schema) {
        MatchingRule mrule;
        Reject.ifNull(schema);
        AttributeDescription ad = AttributeDescription.valueOf(this.attributeDescription, schema);
        if (this.orderingMatchingRule != null) {
            mrule = schema.getMatchingRule(this.orderingMatchingRule);
            if (mrule == null) {
                LocalizableMessage message = CoreMessages.ERR_SORT_KEY_MRULE_NOT_FOUND.get(this.toString(), this.orderingMatchingRule);
                throw new LocalizedIllegalArgumentException(message);
            }
        } else {
            mrule = ad.getAttributeType().getOrderingMatchingRule();
            if (mrule == null) {
                LocalizableMessage message = CoreMessages.ERR_SORT_KEY_DEFAULT_MRULE_NOT_FOUND.get(this.toString(), this.attributeDescription);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
        return new EntryComparator(ad, mrule, this.isReverseOrder);
    }

    public String getAttributeDescription() {
        return this.attributeDescription;
    }

    public String getOrderingMatchingRule() {
        return this.orderingMatchingRule;
    }

    public boolean isReverseOrder() {
        return this.isReverseOrder;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortKey)) {
            return false;
        }
        SortKey s = (SortKey)o;
        return this.isReverseOrder == s.isReverseOrder && this.attributeDescription.equalsIgnoreCase(s.attributeDescription) && this.equalsIgnoreCase(this.orderingMatchingRule, s.orderingMatchingRule);
    }

    private boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equalsIgnoreCase(s2);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isReverseOrder) {
            builder.append('-');
        }
        builder.append(this.attributeDescription);
        if (this.orderingMatchingRule != null) {
            builder.append(':');
            builder.append(this.orderingMatchingRule);
        }
        return builder.toString();
    }

    private static final class EntryComparator
    implements Comparator<Entry> {
        private final AttributeDescription attributeDescription;
        private final MatchingRule matchingRule;
        private final boolean isReverseOrder;

        private EntryComparator(AttributeDescription attributeDescription, MatchingRule matchingRule, boolean isReverseOrder) {
            this.attributeDescription = attributeDescription;
            this.matchingRule = matchingRule;
            this.isReverseOrder = isReverseOrder;
        }

        @Override
        public int compare(Entry entry1, Entry entry2) {
            ByteString normalizedValue1 = this.lowestValueOf(entry1);
            ByteString normalizedValue2 = this.lowestValueOf(entry2);
            if (normalizedValue1 == null) {
                return normalizedValue2 != null ? 1 : 0;
            }
            if (normalizedValue2 == null) {
                return -1;
            }
            if (this.isReverseOrder) {
                return normalizedValue2.compareTo(normalizedValue1);
            }
            return normalizedValue1.compareTo(normalizedValue2);
        }

        private ByteString lowestValueOf(Entry entry) {
            ByteString normalizedValue = null;
            for (Attribute attribute : entry.getAllAttributes(this.attributeDescription)) {
                for (ByteString value : attribute) {
                    try {
                        ByteString tmp = this.matchingRule.normalizeAttributeValue(value);
                        if (normalizedValue != null && tmp.compareTo(normalizedValue) >= 0) continue;
                        normalizedValue = tmp;
                    }
                    catch (DecodeException decodeException) {}
                }
            }
            return normalizedValue;
        }
    }

    private static final class CompositeEntryComparator
    implements Comparator<Entry> {
        private final List<Comparator<Entry>> comparators;

        private CompositeEntryComparator(List<Comparator<Entry>> comparators) {
            this.comparators = comparators;
        }

        @Override
        public int compare(Entry entry1, Entry entry2) {
            for (Comparator<Entry> comparator : this.comparators) {
                int result = comparator.compare(entry1, entry2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }
}

