/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.Iterators;
import com.forgerock.opendj.util.SubstringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Reject;

public final class RDN
implements Iterable<AVA>,
Comparable<RDN> {
    private static final RDN MIN_VALUE = new RDN();
    private static final RDN MAX_VALUE = new RDN();
    private final AVA[] avas;
    private String stringValue;

    public static RDN minValue() {
        return MIN_VALUE;
    }

    public static RDN maxValue() {
        return MAX_VALUE;
    }

    public static RDN valueOf(String rdn) {
        return RDN.valueOf(rdn, Schema.getDefaultSchema());
    }

    public static RDN valueOf(String rdn, Schema schema) {
        RDN parsedRdn;
        SubstringReader reader = new SubstringReader(rdn);
        try {
            parsedRdn = RDN.decode(reader, schema);
        }
        catch (UnknownSchemaElementException e) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_RDN_TYPE_NOT_FOUND.get(rdn, e.getMessageObject()));
        }
        if (reader.remaining() > 0) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_RDN_TRAILING_GARBAGE.get(rdn, reader.read(reader.remaining())));
        }
        return parsedRdn;
    }

    static RDN decode(SubstringReader reader, Schema schema) {
        AVA firstAVA = AVA.decode(reader, schema);
        reader.skipWhitespaces();
        reader.mark();
        if (reader.remaining() > 0 && reader.read() == '+') {
            ArrayList<AVA> avas = new ArrayList<AVA>();
            avas.add(firstAVA);
            do {
                avas.add(AVA.decode(reader, schema));
                reader.skipWhitespaces();
                reader.mark();
            } while (reader.remaining() > 0 && reader.read() == '+');
            reader.reset();
            return new RDN(avas);
        }
        reader.reset();
        return new RDN(firstAVA);
    }

    public RDN(AttributeType attributeType, Object attributeValue) {
        this.avas = new AVA[]{new AVA(attributeType, attributeValue)};
    }

    public RDN(String attributeType, Object attributeValue) {
        this.avas = new AVA[]{new AVA(attributeType, attributeValue)};
    }

    public RDN(AVA ... avas) {
        Reject.ifNull(avas);
        this.avas = this.validateAvas(avas);
    }

    private AVA[] validateAvas(AVA[] avas) {
        switch (avas.length) {
            case 0: {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_RDN_NO_AVAS.get());
            }
            case 1: {
                break;
            }
            case 2: {
                if (!avas[0].getAttributeType().equals(avas[1].getAttributeType())) break;
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_RDN_DUPLICATE_AVA_TYPES.get(avas[0].getAttributeName()));
            }
            default: {
                Object[] sortedAVAs = Arrays.copyOf(avas, avas.length);
                Arrays.sort(sortedAVAs);
                AttributeType previousAttributeType = null;
                for (Object ava : sortedAVAs) {
                    if (((AVA)ava).getAttributeType().equals(previousAttributeType)) {
                        throw new LocalizedIllegalArgumentException(CoreMessages.ERR_RDN_DUPLICATE_AVA_TYPES.get(((AVA)ava).getAttributeName()));
                    }
                    previousAttributeType = ((AVA)ava).getAttributeType();
                }
            }
        }
        return avas;
    }

    public RDN(Collection<AVA> avas) {
        Reject.ifNull(avas);
        this.avas = this.validateAvas(avas.toArray(new AVA[avas.size()]));
    }

    private RDN() {
        this.avas = new AVA[0];
        this.stringValue = "";
    }

    @Override
    public int compareTo(RDN rdn) {
        if (this == rdn) {
            return 0;
        }
        if (this == MAX_VALUE) {
            return 1;
        }
        if (rdn == MAX_VALUE) {
            return -1;
        }
        if (this == MIN_VALUE) {
            return -1;
        }
        if (rdn == MIN_VALUE) {
            return 1;
        }
        int sz1 = this.avas.length;
        int sz2 = rdn.avas.length;
        if (sz1 != sz2) {
            return sz1 - sz2 > 0 ? 1 : -1;
        }
        if (sz1 == 1) {
            return this.avas[0].compareTo(rdn.avas[0]);
        }
        Object[] a1 = new AVA[sz1];
        System.arraycopy(this.avas, 0, a1, 0, sz1);
        Arrays.sort(a1);
        Object[] a2 = new AVA[sz1];
        System.arraycopy(rdn.avas, 0, a2, 0, sz1);
        Arrays.sort(a2);
        for (int i = 0; i < sz1; ++i) {
            int result = ((AVA)a1[i]).compareTo((AVA)a2[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RDN) {
            return this.compareTo((RDN)obj) == 0;
        }
        return false;
    }

    public ByteString getAttributeValue(AttributeType attributeType) {
        for (AVA ava : this.avas) {
            if (!ava.getAttributeType().equals(attributeType)) continue;
            return ava.getAttributeValue();
        }
        return null;
    }

    public AVA getFirstAVA() {
        return this.avas[0];
    }

    public int hashCode() {
        int hash = 0;
        for (AVA ava : this.avas) {
            hash += ava.hashCode();
        }
        return hash;
    }

    public boolean isMultiValued() {
        return this.avas.length > 1;
    }

    public boolean hasAttributeType(AttributeType attributeType) {
        for (AVA ava : this.avas) {
            if (!ava.getAttributeType().equals(attributeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<AVA> iterator() {
        return Iterators.arrayIterator(this.avas);
    }

    public int size() {
        return this.avas.length;
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder builder = new StringBuilder();
            this.avas[0].toString(builder);
            for (int i = 1; i < this.avas.length; ++i) {
                builder.append('+');
                this.avas[i].toString(builder);
            }
            this.stringValue = builder.toString();
        }
        return this.stringValue;
    }

    ByteStringBuilder toNormalizedByteString(ByteStringBuilder builder) {
        switch (this.size()) {
            case 0: {
                if (this == MIN_VALUE) {
                    builder.appendByte(0);
                    break;
                }
                builder.appendByte(1);
                break;
            }
            case 1: {
                builder.appendByte(0);
                this.getFirstAVA().toNormalizedByteString(builder);
                break;
            }
            default: {
                builder.appendByte(0);
                Iterator<AVA> it = this.getSortedAvas();
                it.next().toNormalizedByteString(builder);
                while (it.hasNext()) {
                    builder.appendByte(1);
                    it.next().toNormalizedByteString(builder);
                }
                break block0;
            }
        }
        return builder;
    }

    StringBuilder toNormalizedUrlSafeString(StringBuilder builder) {
        switch (this.size()) {
            case 0: {
                if (this == MIN_VALUE) {
                    builder.append(',');
                    break;
                }
                builder.append('+');
                break;
            }
            case 1: {
                this.getFirstAVA().toNormalizedUrlSafe(builder);
                break;
            }
            default: {
                Iterator<AVA> it = this.getSortedAvas();
                it.next().toNormalizedUrlSafe(builder);
                while (it.hasNext()) {
                    builder.append('+');
                    it.next().toNormalizedUrlSafe(builder);
                }
                break block0;
            }
        }
        return builder;
    }

    private Iterator<AVA> getSortedAvas() {
        TreeSet sortedAvas = new TreeSet();
        Collections.addAll(sortedAvas, this.avas);
        return sortedAvas.iterator();
    }
}

