/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.LinkedHashMap;
import org.forgerock.opendj.ldap.AbstractMapEntry;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.EntryFactory;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.util.Reject;

public final class LinkedHashMapEntry
extends AbstractMapEntry {
    public static final EntryFactory FACTORY = new EntryFactory(){

        @Override
        public Entry newEntry(DN name) {
            return new LinkedHashMapEntry(name);
        }
    };

    public static LinkedHashMapEntry deepCopyOfEntry(Entry entry) {
        LinkedHashMapEntry copy = new LinkedHashMapEntry(entry.getName());
        for (Attribute attribute : entry.getAllAttributes()) {
            copy.addAttribute(new LinkedAttribute(attribute));
        }
        return copy;
    }

    public LinkedHashMapEntry() {
        this(DN.rootDN());
    }

    public LinkedHashMapEntry(DN name) {
        super(Reject.checkNotNull(name), new LinkedHashMap<AttributeDescription, Attribute>());
    }

    public LinkedHashMapEntry(Entry entry) {
        this(entry.getName());
        for (Attribute attribute : entry.getAllAttributes()) {
            this.addAttribute(attribute);
        }
    }

    public LinkedHashMapEntry(String name) {
        this(DN.valueOf(name));
    }

    public LinkedHashMapEntry(String ... ldifLines) {
        this(Requests.newAddRequest(ldifLines));
    }
}

