/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageDescriptor;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.util.Reject;

public final class GeneralizedTime
implements Comparable<GeneralizedTime> {
    private static final TimeZone TIME_ZONE_UTC_OBJ = TimeZone.getTimeZone("UTC");
    public static final GeneralizedTime MIN_GENERALIZED_TIME = GeneralizedTime.valueOf("00010101000000Z");
    public static final long MIN_GENERALIZED_TIME_MS = MIN_GENERALIZED_TIME.getTimeInMillis();
    private volatile Calendar calendar;
    private volatile Date date;
    private volatile String stringValue;
    private volatile long timeMS;

    public static GeneralizedTime currentTime() {
        return GeneralizedTime.valueOf(Calendar.getInstance());
    }

    public static GeneralizedTime valueOf(Calendar calendar) {
        Reject.ifNull(calendar);
        return new GeneralizedTime((Calendar)calendar.clone(), null, Long.MIN_VALUE, null);
    }

    public static GeneralizedTime valueOf(Date date) {
        Reject.ifNull(date);
        return new GeneralizedTime(null, (Date)date.clone(), Long.MIN_VALUE, null);
    }

    public static GeneralizedTime valueOf(long timeMS) {
        Reject.ifTrue(timeMS < MIN_GENERALIZED_TIME_MS, "timeMS is too old to represent as a generalized time");
        return new GeneralizedTime(null, null, timeMS, null);
    }

    public static GeneralizedTime valueOf(String time) {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        String valueString = time.toUpperCase();
        int length = valueString.length();
        if (length < 11) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_TOO_SHORT.get(valueString);
            throw new LocalizedIllegalArgumentException(message);
        }
        for (int i = 0; i < 4; ++i) {
            char c = valueString.charAt(i);
            int val = GeneralizedTime.toInt(c, CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_YEAR, valueString, String.valueOf(c));
            year = year * 10 + val;
        }
        char m1 = valueString.charAt(4);
        char m2 = valueString.charAt(5);
        String monthValue = valueString.substring(4, 6);
        block0 : switch (m1) {
            case '0': {
                switch (m2) {
                    case '1': {
                        month = 0;
                        break block0;
                    }
                    case '2': {
                        month = 1;
                        break block0;
                    }
                    case '3': {
                        month = 2;
                        break block0;
                    }
                    case '4': {
                        month = 3;
                        break block0;
                    }
                    case '5': {
                        month = 4;
                        break block0;
                    }
                    case '6': {
                        month = 5;
                        break block0;
                    }
                    case '7': {
                        month = 6;
                        break block0;
                    }
                    case '8': {
                        month = 7;
                        break block0;
                    }
                    case '9': {
                        month = 8;
                        break block0;
                    }
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MONTH.get(valueString, monthValue));
            }
            case '1': {
                switch (m2) {
                    case '0': {
                        month = 9;
                        break block0;
                    }
                    case '1': {
                        month = 10;
                        break block0;
                    }
                    case '2': {
                        month = 11;
                        break block0;
                    }
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MONTH.get(valueString, monthValue));
            }
            default: {
                throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MONTH.get(valueString, monthValue));
            }
        }
        char d1 = valueString.charAt(6);
        char d2 = valueString.charAt(7);
        String dayValue = valueString.substring(6, 8);
        block20 : switch (d1) {
            case '0': {
                day = GeneralizedTime.toInt(d2, CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY, valueString, dayValue);
                if (day != 0) break;
                throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY.get(valueString, dayValue));
            }
            case '1': {
                day = 10 + GeneralizedTime.toInt(d2, CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY, valueString, dayValue);
                break;
            }
            case '2': {
                day = 20 + GeneralizedTime.toInt(d2, CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY, valueString, dayValue);
                break;
            }
            case '3': {
                switch (d2) {
                    case '0': {
                        day = 30;
                        break block20;
                    }
                    case '1': {
                        day = 31;
                        break block20;
                    }
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY.get(valueString, dayValue));
            }
            default: {
                throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY.get(valueString, dayValue));
            }
        }
        char h1 = valueString.charAt(8);
        char h2 = valueString.charAt(9);
        String hourValue = valueString.substring(8, 10);
        block30 : switch (h1) {
            case '0': {
                hour = GeneralizedTime.toInt(h2, CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR, valueString, hourValue);
                break;
            }
            case '1': {
                hour = 10 + GeneralizedTime.toInt(h2, CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR, valueString, hourValue);
                break;
            }
            case '2': {
                switch (h2) {
                    case '0': {
                        hour = 20;
                        break block30;
                    }
                    case '1': {
                        hour = 21;
                        break block30;
                    }
                    case '2': {
                        hour = 22;
                        break block30;
                    }
                    case '3': {
                        hour = 23;
                        break block30;
                    }
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR.get(valueString, hourValue));
            }
            default: {
                throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR.get(valueString, hourValue));
            }
        }
        m1 = valueString.charAt(10);
        switch (m1) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (length < 13) {
                    throw GeneralizedTime.invalidChar(valueString, m1, 10);
                }
                minute = 10 * (m1 - 48);
                minute += GeneralizedTime.toInt(valueString.charAt(11), CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MINUTE, valueString, valueString.substring(10, 12));
                break;
            }
            case 'Z': 
            case 'z': {
                if (length == 11) {
                    TimeZone tz = TIME_ZONE_UTC_OBJ;
                    return GeneralizedTime.createTime(valueString, year, month, day, hour, minute, second, tz);
                }
                throw GeneralizedTime.invalidChar(valueString, m1, 10);
            }
            case '+': 
            case '-': {
                if (length == 13 || length == 15) {
                    TimeZone tz = GeneralizedTime.getTimeZoneForOffset(valueString, 10);
                    return GeneralizedTime.createTime(valueString, year, month, day, hour, minute, second, tz);
                }
                throw GeneralizedTime.invalidChar(valueString, m1, 10);
            }
            case ',': 
            case '.': {
                return GeneralizedTime.finishDecodingFraction(valueString, 11, year, month, day, hour, minute, second, 3600000);
            }
            default: {
                throw GeneralizedTime.invalidChar(valueString, m1, 10);
            }
        }
        char s1 = valueString.charAt(12);
        switch (s1) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (length < 15) {
                    throw GeneralizedTime.invalidChar(valueString, s1, 12);
                }
                second = 10 * (s1 - 48);
                second += GeneralizedTime.toInt(valueString.charAt(13), CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MINUTE, valueString, valueString.substring(12, 14));
                break;
            }
            case '6': {
                if (length < 15) {
                    throw GeneralizedTime.invalidChar(valueString, s1, 12);
                }
                if (valueString.charAt(13) != '0') {
                    throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_SECOND.get(valueString, valueString.substring(12, 14)));
                }
                second = 60;
                break;
            }
            case 'Z': 
            case 'z': {
                if (length == 13) {
                    TimeZone tz = TIME_ZONE_UTC_OBJ;
                    return GeneralizedTime.createTime(valueString, year, month, day, hour, minute, second, tz);
                }
                throw GeneralizedTime.invalidChar(valueString, s1, 12);
            }
            case '+': 
            case '-': {
                if (length == 15 || length == 17) {
                    TimeZone tz = GeneralizedTime.getTimeZoneForOffset(valueString, 12);
                    return GeneralizedTime.createTime(valueString, year, month, day, hour, minute, second, tz);
                }
                throw GeneralizedTime.invalidChar(valueString, s1, 12);
            }
            case ',': 
            case '.': {
                return GeneralizedTime.finishDecodingFraction(valueString, 13, year, month, day, hour, minute, second, 60000);
            }
            default: {
                throw GeneralizedTime.invalidChar(valueString, s1, 12);
            }
        }
        switch (valueString.charAt(14)) {
            case ',': 
            case '.': {
                return GeneralizedTime.finishDecodingFraction(valueString, 15, year, month, day, hour, minute, second, 1000);
            }
            case 'Z': 
            case 'z': {
                if (length == 15) {
                    TimeZone tz = TIME_ZONE_UTC_OBJ;
                    return GeneralizedTime.createTime(valueString, year, month, day, hour, minute, second, tz);
                }
                throw GeneralizedTime.invalidChar(valueString, valueString.charAt(14), 14);
            }
            case '+': 
            case '-': {
                if (length == 17 || length == 19) {
                    TimeZone tz = GeneralizedTime.getTimeZoneForOffset(valueString, 14);
                    return GeneralizedTime.createTime(valueString, year, month, day, hour, minute, second, tz);
                }
                throw GeneralizedTime.invalidChar(valueString, valueString.charAt(14), 14);
            }
        }
        throw GeneralizedTime.invalidChar(valueString, valueString.charAt(14), 14);
    }

    private static LocalizedIllegalArgumentException invalidChar(String valueString, char c, int pos) {
        return new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get(valueString, String.valueOf(c), pos));
    }

    private static int toInt(char c, LocalizableMessageDescriptor.Arg2<Object, Object> invalidSyntaxMsg, String valueString, String unitValue) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        throw new LocalizedIllegalArgumentException(invalidSyntaxMsg.get(valueString, unitValue));
    }

    private static GeneralizedTime createTime(String value, int year, int month, int day, int hour, int minute, int second, TimeZone tz) {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setLenient(false);
            calendar.setTimeZone(tz);
            calendar.set(year, month, day, hour, minute, second);
            calendar.set(14, 0);
            return new GeneralizedTime(calendar, null, Long.MIN_VALUE, value);
        }
        catch (Exception e) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_TIME.get(value, String.valueOf(e));
            throw new LocalizedIllegalArgumentException(message, (Throwable)e);
        }
    }

    private static GeneralizedTime finishDecodingFraction(String value, int startPos, int year, int month, int day, int hour, int minute, int second, int multiplier) {
        int length = value.length();
        StringBuilder fractionBuffer = new StringBuilder(2 + length - startPos);
        fractionBuffer.append("0.");
        TimeZone timeZone = null;
        block7: for (int i = startPos; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    fractionBuffer.append(c);
                    continue block7;
                }
                case 'Z': 
                case 'z': {
                    if (i != value.length() - 1) {
                        LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_FRACTION_CHAR.get(value, String.valueOf(c));
                        throw new LocalizedIllegalArgumentException(message);
                    }
                    timeZone = TIME_ZONE_UTC_OBJ;
                    break block7;
                }
                case '+': 
                case '-': {
                    timeZone = GeneralizedTime.getTimeZoneForOffset(value, i);
                    break block7;
                }
                default: {
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_FRACTION_CHAR.get(value, String.valueOf(c));
                    throw new LocalizedIllegalArgumentException(message);
                }
            }
        }
        if (fractionBuffer.length() == 2) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_EMPTY_FRACTION.get(value);
            throw new LocalizedIllegalArgumentException(message);
        }
        if (timeZone == null) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_NO_TIME_ZONE_INFO.get(value);
            throw new LocalizedIllegalArgumentException(message);
        }
        Double fractionValue = Double.parseDouble(fractionBuffer.toString());
        int additionalMilliseconds = (int)Math.round(fractionValue * (double)multiplier);
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setLenient(false);
            calendar.setTimeZone(timeZone);
            calendar.set(year, month, day, hour, minute, second);
            calendar.set(14, additionalMilliseconds);
            return new GeneralizedTime(calendar, null, Long.MIN_VALUE, value);
        }
        catch (Exception e) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_TIME.get(value, String.valueOf(e));
            throw new LocalizedIllegalArgumentException(message, (Throwable)e);
        }
    }

    private static TimeZone getTimeZoneForOffset(String value, int startPos) {
        String offSetStr = value.substring(startPos);
        int len = offSetStr.length();
        if (len != 3 && len != 5) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
            throw new LocalizedIllegalArgumentException(message);
        }
        switch (offSetStr.charAt(0)) {
            case '+': 
            case '-': {
                break;
            }
            default: {
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
        block3 : switch (offSetStr.charAt(1)) {
            case '0': 
            case '1': {
                switch (offSetStr.charAt(2)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block3;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
                throw new LocalizedIllegalArgumentException(message);
            }
            case '2': {
                switch (offSetStr.charAt(2)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        break block3;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
                throw new LocalizedIllegalArgumentException(message);
            }
            default: {
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
        if (offSetStr.length() == 5) {
            block13 : switch (offSetStr.charAt(3)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': {
                    switch (offSetStr.charAt(4)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break block13;
                        }
                    }
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
                    throw new LocalizedIllegalArgumentException(message);
                }
                default: {
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get(value, offSetStr);
                    throw new LocalizedIllegalArgumentException(message);
                }
            }
        }
        return TimeZone.getTimeZone("GMT" + offSetStr);
    }

    private GeneralizedTime(Calendar calendar, Date date, long time, String stringValue) {
        this.calendar = calendar;
        this.date = date;
        this.timeMS = time;
        this.stringValue = stringValue;
    }

    @Override
    public int compareTo(GeneralizedTime o) {
        Long timeMS1 = this.getTimeInMillis();
        Long timeMS2 = o.getTimeInMillis();
        return timeMS1.compareTo(timeMS2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GeneralizedTime) {
            return this.getTimeInMillis() == ((GeneralizedTime)obj).getTimeInMillis();
        }
        return false;
    }

    public long getTimeInMillis() {
        long tmpTimeMS = this.timeMS;
        if (tmpTimeMS == Long.MIN_VALUE) {
            tmpTimeMS = this.date != null ? this.date.getTime() : this.calendar.getTimeInMillis();
            this.timeMS = tmpTimeMS;
        }
        return tmpTimeMS;
    }

    public int hashCode() {
        return Long.valueOf(this.getTimeInMillis()).hashCode();
    }

    public Calendar toCalendar() {
        return (Calendar)this.getCalendar().clone();
    }

    public Date toDate() {
        Date tmpDate = this.date;
        if (tmpDate == null) {
            this.date = tmpDate = new Date(this.getTimeInMillis());
        }
        return (Date)tmpDate.clone();
    }

    public String toString() {
        String tmpString = this.stringValue;
        if (tmpString == null) {
            StringBuilder sb = new StringBuilder(19);
            Calendar tmpCalendar = this.getCalendar();
            int n = tmpCalendar.get(1);
            if (n > 9999) {
                n = 9999;
            }
            if (n < 0) {
                throw new IllegalArgumentException("Year cannot be < 0:" + n);
            }
            if (n < 10) {
                sb.append("000");
            } else if (n < 100) {
                sb.append("00");
            } else if (n < 1000) {
                sb.append("0");
            }
            sb.append(n);
            n = tmpCalendar.get(2) + 1;
            if (n < 10) {
                sb.append("0");
            }
            sb.append(n);
            n = tmpCalendar.get(5);
            if (n < 10) {
                sb.append("0");
            }
            sb.append(n);
            n = tmpCalendar.get(11);
            if (n < 10) {
                sb.append("0");
            }
            sb.append(n);
            n = tmpCalendar.get(12);
            if (n < 10) {
                sb.append("0");
            }
            sb.append(n);
            n = tmpCalendar.get(13);
            if (n < 10) {
                sb.append("0");
            }
            sb.append(n);
            n = tmpCalendar.get(14);
            if (n != 0) {
                sb.append('.');
                if (n < 10) {
                    sb.append("00");
                } else if (n < 100) {
                    sb.append("0");
                }
                sb.append(n);
            }
            if ((n = tmpCalendar.get(15) + tmpCalendar.get(16)) == 0) {
                sb.append('Z');
            } else {
                if (n < 0) {
                    sb.append('-');
                    n = -n;
                } else {
                    sb.append('+');
                }
                int h = (n /= 60000) / 60;
                if (h < 10) {
                    sb.append("0");
                }
                sb.append(h);
                int m = n % 60;
                if (m < 10) {
                    sb.append("0");
                }
                sb.append(m);
            }
            this.stringValue = tmpString = sb.toString();
        }
        return tmpString;
    }

    private Calendar getCalendar() {
        Calendar tmpCalendar = this.calendar;
        if (tmpCalendar == null) {
            tmpCalendar = new GregorianCalendar(TIME_ZONE_UTC_OBJ);
            tmpCalendar.setLenient(false);
            tmpCalendar.setTimeInMillis(this.getTimeInMillis());
            this.calendar = tmpCalendar;
        }
        return tmpCalendar;
    }
}

