/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.AttributeFilter;
import org.forgerock.opendj.ldap.AttributeParser;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.TreeMapEntry;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.opendj.ldif.LDIF;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;

public final class Entries {
    private static final Comparator<Entry> COMPARATOR = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final AttributeFilter USER_ATTRIBUTES_ONLY_FILTER = new AttributeFilter();
    private static final DiffOptions DEFAULT_DIFF_OPTIONS = new DiffOptions();
    private static final Function<Attribute, Attribute, NeverThrowsException> UNMODIFIABLE_ATTRIBUTE_FUNCTION = new Function<Attribute, Attribute, NeverThrowsException>(){

        @Override
        public Attribute apply(Attribute value) {
            return Attributes.unmodifiableAttribute(value);
        }
    };

    public static Comparator<Entry> compareByName() {
        return COMPARATOR;
    }

    public static boolean conformsToSchema(Entry entry, Schema schema, SchemaValidationPolicy policy, Collection<LocalizableMessage> errorMessages) {
        return schema.validateEntry(entry, policy, errorMessages);
    }

    public static boolean conformsToSchema(Entry entry, SchemaValidationPolicy policy, Collection<LocalizableMessage> errorMessages) {
        return Entries.conformsToSchema(entry, Schema.getDefaultSchema(), policy, errorMessages);
    }

    public static boolean containsObjectClass(Entry entry, ObjectClass objectClass) {
        return Entries.containsObjectClass(entry, Schema.getDefaultSchema(), objectClass);
    }

    public static boolean containsObjectClass(Entry entry, Schema schema, ObjectClass objectClass) {
        return Entries.getObjectClasses(entry, schema).contains(objectClass);
    }

    public static ModifyRequest diffEntries(Entry fromEntry, Entry toEntry) {
        return Entries.diffEntries(fromEntry, toEntry, DEFAULT_DIFF_OPTIONS);
    }

    public static ModifyRequest diffEntries(Entry fromEntry, Entry toEntry, DiffOptions options) {
        Attribute ato;
        Reject.ifNull(fromEntry, toEntry, options);
        ModifyRequest request = Requests.newModifyRequest(fromEntry.getName());
        Entry tfrom = Entries.toFilteredTreeMapEntry(fromEntry, options);
        Entry tto = Entries.toFilteredTreeMapEntry(toEntry, options);
        Iterator<Attribute> ifrom = tfrom.getAllAttributes().iterator();
        Iterator<Attribute> ito = tto.getAllAttributes().iterator();
        Attribute afrom = ifrom.hasNext() ? ifrom.next() : null;
        Attribute attribute = ato = ito.hasNext() ? ito.next() : null;
        while (afrom != null && ato != null) {
            AttributeDescription adto;
            AttributeDescription adfrom = afrom.getAttributeDescription();
            int cmp = adfrom.compareTo(adto = ato.getAttributeDescription());
            if (cmp == 0) {
                if (options.useReplaceMaxValues >= ato.size()) {
                    if (Entries.diffAttributeNeedsReplacing(afrom, ato, options)) {
                        request.addModification(new Modification(ModificationType.REPLACE, ato));
                    }
                } else if (afrom.size() == 1 && ato.size() == 1) {
                    if (Entries.diffFirstValuesAreDifferent(options, afrom, ato)) {
                        Entries.diffDeleteValues(request, afrom);
                        Entries.diffAddValues(request, ato);
                    }
                } else if (options.useExactMatching) {
                    LinkedHashSet<ByteString> oldValues = new LinkedHashSet<ByteString>(afrom);
                    LinkedHashSet<ByteString> newValues = new LinkedHashSet<ByteString>(ato);
                    LinkedHashSet<ByteString> deletedValues = new LinkedHashSet<ByteString>(oldValues);
                    deletedValues.removeAll(newValues);
                    Entries.diffDeleteValues(request, deletedValues.size() == afrom.size() ? afrom : new LinkedAttribute(adfrom, deletedValues));
                    LinkedHashSet<ByteString> addedValues = newValues;
                    addedValues.removeAll(oldValues);
                    Entries.diffAddValues(request, addedValues.size() == ato.size() ? ato : new LinkedAttribute(adto, addedValues));
                } else {
                    LinkedAttribute deletedValues = new LinkedAttribute(afrom);
                    deletedValues.removeAll(ato);
                    Entries.diffDeleteValues(request, deletedValues);
                    LinkedAttribute addedValues = new LinkedAttribute(ato);
                    addedValues.removeAll(afrom);
                    Entries.diffAddValues(request, addedValues);
                }
                afrom = ifrom.hasNext() ? ifrom.next() : null;
                ato = ito.hasNext() ? ito.next() : null;
                continue;
            }
            if (cmp < 0) {
                Entries.diffDeleteAttribute(request, afrom, options);
                afrom = ifrom.hasNext() ? ifrom.next() : null;
                continue;
            }
            Entries.diffAddAttribute(request, ato, options);
            ato = ito.hasNext() ? ito.next() : null;
        }
        if (afrom != null) {
            Entries.diffDeleteAttribute(request, afrom, options);
        }
        while (ifrom.hasNext()) {
            Entries.diffDeleteAttribute(request, ifrom.next(), options);
        }
        if (ato != null) {
            Entries.diffAddAttribute(request, ato, options);
        }
        while (ito.hasNext()) {
            Entries.diffAddAttribute(request, ito.next(), options);
        }
        return request;
    }

    public static DiffOptions diffOptions() {
        return new DiffOptions();
    }

    public static Set<ObjectClass> getObjectClasses(Entry entry) {
        return Entries.getObjectClasses(entry, Schema.getDefaultSchema());
    }

    public static Set<ObjectClass> getObjectClasses(Entry entry, Schema schema) {
        Attribute objectClassAttribute = entry.getAttribute(AttributeDescription.objectClass());
        if (objectClassAttribute == null) {
            return Collections.emptySet();
        }
        HashSet<ObjectClass> objectClasses = new HashSet<ObjectClass>(objectClassAttribute.size());
        for (ByteString v : objectClassAttribute) {
            String objectClassName = v.toString();
            try {
                ObjectClass objectClass = schema.asStrictSchema().getObjectClass(objectClassName);
                objectClasses.add(objectClass);
            }
            catch (UnknownSchemaElementException e) {}
        }
        return Collections.unmodifiableSet(objectClasses);
    }

    public static ObjectClass getStructuralObjectClass(Entry entry) {
        return Entries.getStructuralObjectClass(entry, Schema.getDefaultSchema());
    }

    public static Entry makeEntry(String ... ldifLines) {
        return LDIF.makeEntry(ldifLines);
    }

    public static List<Entry> makeEntries(String ... ldifLines) {
        return LDIF.makeEntries(ldifLines);
    }

    public static ObjectClass getStructuralObjectClass(Entry entry, Schema schema) {
        ObjectClass structuralObjectClass = null;
        Attribute objectClassAttribute = entry.getAttribute(AttributeDescription.objectClass());
        if (objectClassAttribute == null) {
            return null;
        }
        for (ByteString v : objectClassAttribute) {
            ObjectClass objectClass;
            String objectClassName = v.toString();
            try {
                objectClass = schema.asStrictSchema().getObjectClass(objectClassName);
            }
            catch (UnknownSchemaElementException e) {
                continue;
            }
            if (objectClass.getObjectClassType() != ObjectClassType.STRUCTURAL || structuralObjectClass != null && !objectClass.isDescendantOf(structuralObjectClass)) continue;
            structuralObjectClass = objectClass;
        }
        return structuralObjectClass;
    }

    public static Entry modifyEntry(Entry entry, Modification change) throws LdapException {
        return Entries.modifyEntry(entry, change, null);
    }

    public static Entry modifyEntry(Entry entry, Modification change, Collection<? super ByteString> conflictingValues) throws LdapException {
        return Entries.modifyEntry0(entry, change, conflictingValues, true);
    }

    public static Entry modifyEntry(Entry entry, ModifyRequest changes) throws LdapException {
        boolean isPermissive = changes.containsControl("1.2.840.113556.1.4.1413");
        return Entries.modifyEntry0(entry, changes.getModifications(), isPermissive);
    }

    public static Entry modifyEntryPermissive(Entry entry, Collection<Modification> changes) throws LdapException {
        return Entries.modifyEntry0(entry, changes, true);
    }

    public static Entry modifyEntryStrict(Entry entry, Collection<Modification> changes) throws LdapException {
        return Entries.modifyEntry0(entry, changes, false);
    }

    public static String toLDIF(Entry entry) {
        return LDIF.toLDIF(entry);
    }

    public static Entry unmodifiableEntry(Entry entry) {
        if (entry instanceof UnmodifiableEntry) {
            return entry;
        }
        return new UnmodifiableEntry(entry);
    }

    private static void diffAddAttribute(ModifyRequest request, Attribute ato, DiffOptions diffOptions) {
        if (diffOptions.useReplaceMaxValues > 0) {
            request.addModification(new Modification(ModificationType.REPLACE, ato));
        } else {
            request.addModification(new Modification(ModificationType.ADD, ato));
        }
    }

    private static void diffAddValues(ModifyRequest request, Attribute addedValues) {
        if (addedValues != null && !addedValues.isEmpty()) {
            request.addModification(new Modification(ModificationType.ADD, addedValues));
        }
    }

    private static boolean diffAttributeNeedsReplacing(Attribute afrom, Attribute ato, DiffOptions options) {
        if (afrom.size() != ato.size()) {
            return true;
        }
        if (afrom.size() == 1) {
            return Entries.diffFirstValuesAreDifferent(options, afrom, ato);
        }
        if (options.useExactMatching) {
            LinkedHashSet<ByteString> oldValues = new LinkedHashSet<ByteString>(afrom);
            return !oldValues.containsAll(ato);
        }
        return !afrom.equals(ato);
    }

    private static void diffDeleteAttribute(ModifyRequest request, Attribute afrom, DiffOptions diffOptions) {
        if (diffOptions.useReplaceMaxValues > 0) {
            request.addModification(new Modification(ModificationType.REPLACE, Attributes.emptyAttribute(afrom.getAttributeDescription())));
        } else {
            request.addModification(new Modification(ModificationType.DELETE, afrom));
        }
    }

    private static void diffDeleteValues(ModifyRequest request, Attribute deletedValues) {
        if (deletedValues != null && !deletedValues.isEmpty()) {
            request.addModification(new Modification(ModificationType.DELETE, deletedValues));
        }
    }

    private static boolean diffFirstValuesAreDifferent(DiffOptions diffOptions, Attribute afrom, Attribute ato) {
        if (diffOptions.useExactMatching) {
            return !afrom.firstValue().equals(ato.firstValue());
        }
        return !afrom.contains(ato.firstValue());
    }

    private static void incrementAttribute(Entry entry, Attribute change) throws LdapException {
        long delta;
        AttributeDescription deltaAd = change.getAttributeDescription();
        if (change.size() != 1) {
            throw LdapException.newLdapException(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_ENTRY_INCREMENT_INVALID_VALUE_COUNT.get(deltaAd.toString()).toString());
        }
        try {
            delta = change.parse().asLong();
        }
        catch (Exception e) {
            throw LdapException.newLdapException(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_ENTRY_INCREMENT_CANNOT_PARSE_AS_INT.get(deltaAd.toString()).toString());
        }
        Attribute oldAttribute = entry.getAttribute(deltaAd);
        if (oldAttribute == null) {
            throw LdapException.newLdapException(ResultCode.NO_SUCH_ATTRIBUTE, CoreMessages.ERR_ENTRY_INCREMENT_NO_SUCH_ATTRIBUTE.get(deltaAd.toString()).toString());
        }
        LinkedAttribute newAttribute = new LinkedAttribute(oldAttribute.getAttributeDescription());
        try {
            for (Long value : oldAttribute.parse().asSetOfLong(new Long[0])) {
                newAttribute.add(new Object[]{value + delta});
            }
        }
        catch (Exception e) {
            throw LdapException.newLdapException(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_ENTRY_INCREMENT_CANNOT_PARSE_AS_INT.get(deltaAd.toString()).toString());
        }
        entry.replaceAttribute(newAttribute);
    }

    private static Entry modifyEntry0(Entry entry, Collection<Modification> changes, boolean isPermissive) throws LdapException {
        ArrayList conflictingValues = isPermissive ? null : new ArrayList(0);
        for (Modification change : changes) {
            Entries.modifyEntry0(entry, change, conflictingValues, isPermissive);
        }
        return entry;
    }

    private static Entry modifyEntry0(Entry entry, Modification change, Collection<? super ByteString> conflictingValues, boolean isPermissive) throws LdapException {
        ModificationType modType = change.getModificationType();
        if (modType.equals(ModificationType.ADD)) {
            entry.addAttribute(change.getAttribute(), conflictingValues);
            if (!isPermissive && !conflictingValues.isEmpty()) {
                throw LdapException.newLdapException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, CoreMessages.ERR_ENTRY_DUPLICATE_VALUES.get(change.getAttribute().getAttributeDescriptionAsString()).toString());
            }
        } else if (modType.equals(ModificationType.DELETE)) {
            boolean hasChanged = entry.removeAttribute(change.getAttribute(), conflictingValues);
            if (!(isPermissive || hasChanged && conflictingValues.isEmpty())) {
                throw LdapException.newLdapException(ResultCode.NO_SUCH_ATTRIBUTE, CoreMessages.ERR_ENTRY_NO_SUCH_VALUE.get(change.getAttribute().getAttributeDescriptionAsString()).toString());
            }
        } else if (modType.equals(ModificationType.REPLACE)) {
            entry.replaceAttribute(change.getAttribute());
        } else if (modType.equals(ModificationType.INCREMENT)) {
            Entries.incrementAttribute(entry, change.getAttribute());
        } else {
            throw LdapException.newLdapException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_ENTRY_UNKNOWN_MODIFICATION_TYPE.get(String.valueOf(modType)).toString());
        }
        return entry;
    }

    private static Entry toFilteredTreeMapEntry(Entry entry, DiffOptions options) {
        if (entry instanceof TreeMapEntry) {
            return options.filter(entry);
        }
        return new TreeMapEntry(options.filter(entry));
    }

    private Entries() {
    }

    static /* synthetic */ AttributeFilter access$000() {
        return USER_ATTRIBUTES_ONLY_FILTER;
    }

    private static final class UnmodifiableEntry
    implements Entry {
        private final Entry entry;

        private UnmodifiableEntry(Entry entry) {
            this.entry = entry;
        }

        @Override
        public boolean addAttribute(Attribute attribute) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAttribute(Attribute attribute, Collection<? super ByteString> duplicateValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Entry addAttribute(String attributeDescription, Object ... values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Entry clearAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
            return this.entry.containsAttribute(attribute, missingValues);
        }

        @Override
        public boolean containsAttribute(String attributeDescription, Object ... values) {
            return this.entry.containsAttribute(attributeDescription, values);
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.entry.equals(object);
        }

        @Override
        public Iterable<Attribute> getAllAttributes() {
            return Iterables.unmodifiableIterable(Iterables.transformedIterable(this.entry.getAllAttributes(), UNMODIFIABLE_ATTRIBUTE_FUNCTION));
        }

        @Override
        public Iterable<Attribute> getAllAttributes(AttributeDescription attributeDescription) {
            return Iterables.unmodifiableIterable(Iterables.transformedIterable(this.entry.getAllAttributes(attributeDescription), UNMODIFIABLE_ATTRIBUTE_FUNCTION));
        }

        @Override
        public Iterable<Attribute> getAllAttributes(String attributeDescription) {
            return Iterables.unmodifiableIterable(Iterables.transformedIterable(this.entry.getAllAttributes(attributeDescription), UNMODIFIABLE_ATTRIBUTE_FUNCTION));
        }

        @Override
        public Attribute getAttribute(AttributeDescription attributeDescription) {
            Attribute attribute = this.entry.getAttribute(attributeDescription);
            if (attribute != null) {
                return Attributes.unmodifiableAttribute(attribute);
            }
            return null;
        }

        @Override
        public Attribute getAttribute(String attributeDescription) {
            Attribute attribute = this.entry.getAttribute(attributeDescription);
            if (attribute != null) {
                return Attributes.unmodifiableAttribute(attribute);
            }
            return null;
        }

        @Override
        public int getAttributeCount() {
            return this.entry.getAttributeCount();
        }

        @Override
        public DN getName() {
            return this.entry.getName();
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }

        @Override
        public AttributeParser parseAttribute(AttributeDescription attributeDescription) {
            return this.entry.parseAttribute(attributeDescription);
        }

        @Override
        public AttributeParser parseAttribute(String attributeDescription) {
            return this.entry.parseAttribute(attributeDescription);
        }

        @Override
        public boolean removeAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAttribute(AttributeDescription attributeDescription) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Entry removeAttribute(String attributeDescription, Object ... values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replaceAttribute(Attribute attribute) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Entry replaceAttribute(String attributeDescription, Object ... values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Entry setName(DN dn) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Entry setName(String dn) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this.entry.toString();
        }
    }

    public static final class DiffOptions {
        private AttributeFilter attributeFilter = Entries.access$000();
        private boolean useExactMatching;
        private int useReplaceMaxValues;

        private DiffOptions() {
        }

        public DiffOptions attributes(AttributeFilter attributeFilter) {
            Reject.ifNull(attributeFilter);
            this.attributeFilter = attributeFilter;
            return this;
        }

        public DiffOptions attributes(String ... attributeDescriptions) {
            return this.attributes(new AttributeFilter(attributeDescriptions));
        }

        public DiffOptions useExactMatching() {
            this.useExactMatching = true;
            return this;
        }

        public DiffOptions alwaysReplaceAttributes() {
            return this.replaceMaxValues(Integer.MAX_VALUE);
        }

        public DiffOptions replaceSingleValuedAttributes() {
            return this.replaceMaxValues(1);
        }

        private DiffOptions replaceMaxValues(int maxValues) {
            Reject.ifFalse(maxValues >= 0, "maxValues must be >= 0");
            this.useReplaceMaxValues = maxValues;
            return this;
        }

        private Entry filter(Entry entry) {
            return this.attributeFilter.filteredViewOf(entry);
        }
    }
}

