/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.ldap.controls.AffinityControl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.AbstractConnectionWrapper;
import org.forgerock.opendj.ldap.CachedConnectionPool;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ConnectionLoadBalancer;
import org.forgerock.opendj.ldap.ConnectionPool;
import org.forgerock.opendj.ldap.ConsistentHashDistributionLoadBalancer;
import org.forgerock.opendj.ldap.ConsistentHashMap;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.InternalConnection;
import org.forgerock.opendj.ldap.InternalConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LoadBalancerEventListener;
import org.forgerock.opendj.ldap.RequestContext;
import org.forgerock.opendj.ldap.RequestHandler;
import org.forgerock.opendj.ldap.RequestHandlerFactory;
import org.forgerock.opendj.ldap.RequestHandlerFactoryAdapter;
import org.forgerock.opendj.ldap.RequestLoadBalancer;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.CRAMMD5SASLBindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.DigestMD5SASLBindRequest;
import org.forgerock.opendj.ldap.requests.GSSAPISASLBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.PasswordModifyExtendedRequest;
import org.forgerock.opendj.ldap.requests.PlainSASLBindRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.util.Function;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.time.Duration;

public final class Connections {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final Option<Duration> LOAD_BALANCER_MONITORING_INTERVAL = Option.withDefault(Duration.duration("1 seconds"));
    public static final Option<LoadBalancerEventListener> LOAD_BALANCER_EVENT_LISTENER = Option.of(LoadBalancerEventListener.class, LoadBalancerEventListener.LOG_EVENTS);
    public static final Option<ScheduledExecutorService> LOAD_BALANCER_SCHEDULER = Option.of(ScheduledExecutorService.class, null);
    private static final DecodeOptions CONTROL_DECODE_OPTIONS = new DecodeOptions();
    static final Function<Integer, Void, NeverThrowsException> NOOP_END_OF_REQUEST_FUNCTION = new Function<Integer, Void, NeverThrowsException>(){

        @Override
        public Void apply(Integer index) {
            return null;
        }
    };

    public static ConnectionPool newCachedConnectionPool(ConnectionFactory factory) {
        return new CachedConnectionPool(factory, 0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, null);
    }

    public static ConnectionPool newCachedConnectionPool(ConnectionFactory factory, int corePoolSize, int maximumPoolSize, long idleTimeout, TimeUnit unit) {
        return new CachedConnectionPool(factory, corePoolSize, maximumPoolSize, idleTimeout, unit, null);
    }

    public static ConnectionPool newCachedConnectionPool(ConnectionFactory factory, int corePoolSize, int maximumPoolSize, long idleTimeout, TimeUnit unit, ScheduledExecutorService scheduler) {
        return new CachedConnectionPool(factory, corePoolSize, maximumPoolSize, idleTimeout, unit, scheduler);
    }

    public static ConnectionPool newFixedConnectionPool(ConnectionFactory factory, int poolSize) {
        return new CachedConnectionPool(factory, poolSize, poolSize, 0L, null, null);
    }

    public static Connection newInternalConnection(RequestHandler<RequestContext> requestHandler) {
        Reject.ifNull(requestHandler);
        return Connections.newInternalConnection(RequestHandlerFactoryAdapter.adaptRequestHandler(requestHandler));
    }

    public static Connection newInternalConnection(ServerConnection<Integer> serverConnection) {
        Reject.ifNull(serverConnection);
        return new InternalConnection(serverConnection);
    }

    public static ConnectionFactory newInternalConnectionFactory(RequestHandler<RequestContext> requestHandler) {
        Reject.ifNull(requestHandler);
        return new InternalConnectionFactory<Object>(Connections.newServerConnectionFactory(requestHandler), null);
    }

    public static <C> ConnectionFactory newInternalConnectionFactory(RequestHandlerFactory<C, RequestContext> factory, C clientContext) {
        Reject.ifNull(factory);
        return new InternalConnectionFactory<C>(Connections.newServerConnectionFactory(factory), clientContext);
    }

    public static <C> ConnectionFactory newInternalConnectionFactory(ServerConnectionFactory<C, Integer> factory, C clientContext) {
        Reject.ifNull(factory);
        return new InternalConnectionFactory<C>(factory, clientContext);
    }

    public static ConnectionFactory newRoundRobinLoadBalancer(final Collection<? extends ConnectionFactory> factories, Options options) {
        return new ConnectionLoadBalancer("RoundRobinLoadBalancer", factories, options){
            private final int maxIndex;
            private final AtomicInteger nextIndex;
            {
                super(loadBalancerName, factories2, options);
                this.maxIndex = factories.size();
                this.nextIndex = new AtomicInteger(-1);
            }

            @Override
            int getInitialConnectionFactoryIndex() {
                int newNextIndex;
                int oldNextIndex;
                if (this.maxIndex == 1) {
                    return 0;
                }
                do {
                    if ((newNextIndex = (oldNextIndex = this.nextIndex.get()) + 1) != this.maxIndex) continue;
                    newNextIndex = 0;
                } while (!this.nextIndex.compareAndSet(oldNextIndex, newNextIndex));
                return newNextIndex;
            }
        };
    }

    public static ConnectionFactory newFailoverLoadBalancer(Collection<? extends ConnectionFactory> factories, Options options) {
        return new ConnectionLoadBalancer("FailoverLoadBalancer", (Collection)factories, options){

            @Override
            int getInitialConnectionFactoryIndex() {
                return 0;
            }
        };
    }

    public static ConnectionFactory newAffinityRequestLoadBalancer(Collection<? extends ConnectionFactory> factories, Options options) {
        return new RequestLoadBalancer("AffinityRequestLoadBalancer", factories, options, Connections.newAffinityRequestLoadBalancerNextFunction(factories), NOOP_END_OF_REQUEST_FUNCTION);
    }

    static Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException> newAffinityRequestLoadBalancerNextFunction(final Collection<? extends ConnectionFactory> factories) {
        return new Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>(){
            private final int maxPartitionId;
            {
                this.maxPartitionId = factories.size();
            }

            @Override
            public RequestLoadBalancer.PartitionedRequest apply(Request request) {
                int partitionId = Connections.computePartitionIdFromDN(Connections.dnOfRequest(request), this.maxPartitionId);
                return new RequestLoadBalancer.PartitionedRequest(request, partitionId);
            }
        };
    }

    private static int computePartitionIdFromDN(DN dn, int numberOfPartitions) {
        int partitionId = dn != null ? dn.hashCode() : ThreadLocalRandom.current().nextInt(0, numberOfPartitions);
        return partitionId == Integer.MIN_VALUE ? 0 : Math.abs(partitionId) % numberOfPartitions;
    }

    static DN dnOfRequest(Request request) {
        if (request instanceof SearchRequest) {
            return ((SearchRequest)request).getName();
        }
        if (request instanceof ModifyRequest) {
            return ((ModifyRequest)request).getName();
        }
        if (request instanceof SimpleBindRequest) {
            return Connections.dnOf(((SimpleBindRequest)request).getName());
        }
        if (request instanceof AddRequest) {
            return ((AddRequest)request).getName();
        }
        if (request instanceof DeleteRequest) {
            return ((DeleteRequest)request).getName();
        }
        if (request instanceof CompareRequest) {
            return ((CompareRequest)request).getName();
        }
        if (request instanceof ModifyDNRequest) {
            return ((ModifyDNRequest)request).getName();
        }
        if (request instanceof PasswordModifyExtendedRequest) {
            return Connections.dnOfAuthzid(((PasswordModifyExtendedRequest)request).getUserIdentityAsString());
        }
        if (request instanceof PlainSASLBindRequest) {
            return Connections.dnOfAuthzid(((PlainSASLBindRequest)request).getAuthenticationID());
        }
        if (request instanceof DigestMD5SASLBindRequest) {
            return Connections.dnOfAuthzid(((DigestMD5SASLBindRequest)request).getAuthenticationID());
        }
        if (request instanceof GSSAPISASLBindRequest) {
            return Connections.dnOfAuthzid(((GSSAPISASLBindRequest)request).getAuthenticationID());
        }
        if (request instanceof CRAMMD5SASLBindRequest) {
            return Connections.dnOfAuthzid(((CRAMMD5SASLBindRequest)request).getAuthenticationID());
        }
        return null;
    }

    private static DN dnOfAuthzid(String authzid) {
        if (authzid != null && authzid.startsWith("dn:")) {
            return Connections.dnOf(authzid.substring(3));
        }
        return null;
    }

    private static DN dnOf(String dnString) {
        try {
            return DN.valueOf(dnString);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static ConnectionFactory newFixedSizeDistributionLoadBalancer(DN partitionBaseDN, ConsistentHashMap<? extends ConnectionFactory> partitions, Options options) {
        return new ConsistentHashDistributionLoadBalancer(partitionBaseDN, partitions);
    }

    public static ConnectionFactory newLeastRequestsLoadBalancer(Collection<? extends ConnectionFactory> factories, Options options) {
        LeastRequestsDispatcher dispatcher = new LeastRequestsDispatcher(factories.size());
        return new RequestLoadBalancer("SaturationBasedRequestLoadBalancer", factories, options, Connections.newLeastRequestsLoadBalancerNextFunction(dispatcher), Connections.newLeastRequestsLoadBalancerEndOfRequestFunction(dispatcher));
    }

    static Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException> newLeastRequestsLoadBalancerNextFunction(final LeastRequestsDispatcher dispatcher) {
        return new Function<Request, RequestLoadBalancer.PartitionedRequest, NeverThrowsException>(){
            private final int maxIndex;
            {
                this.maxIndex = dispatcher.size();
            }

            @Override
            public RequestLoadBalancer.PartitionedRequest apply(Request request) {
                int affinityBasedIndex = this.parseAffinityRequestControl(request);
                int finalIndex = dispatcher.selectServer(affinityBasedIndex);
                Request cleanedRequest = affinityBasedIndex == -1 ? request : Requests.shallowCopyOfRequest(request, "1.3.6.1.4.1.36733.2.1.5.2");
                return new RequestLoadBalancer.PartitionedRequest(cleanedRequest, finalIndex);
            }

            private int parseAffinityRequestControl(Request request) {
                try {
                    AffinityControl control = request.getControl(AffinityControl.DECODER, CONTROL_DECODE_OPTIONS);
                    if (control != null) {
                        int index = control.getAffinityValue().hashCode();
                        return index == Integer.MIN_VALUE ? 0 : Math.abs(index) % this.maxIndex;
                    }
                }
                catch (DecodeException e) {
                    logger.warn(CoreMessages.WARN_DECODING_AFFINITY_CONTROL.get(e.getMessage()));
                }
                return -1;
            }
        };
    }

    static Function<Integer, Void, NeverThrowsException> newLeastRequestsLoadBalancerEndOfRequestFunction(final LeastRequestsDispatcher dispatcher) {
        return new Function<Integer, Void, NeverThrowsException>(){

            @Override
            public Void apply(Integer index) {
                dispatcher.terminatedRequest(index);
                return null;
            }
        };
    }

    public static ConnectionFactory newNamedConnectionFactory(final ConnectionFactory factory, final String name) {
        Reject.ifNull(factory, name);
        return new ConnectionFactory(){

            @Override
            public void close() {
                factory.close();
            }

            @Override
            public Connection getConnection() throws LdapException {
                return factory.getConnection();
            }

            @Override
            public Promise<Connection, LdapException> getConnectionAsync() {
                return factory.getConnectionAsync();
            }

            public String toString() {
                return name;
            }
        };
    }

    public static <C> ServerConnectionFactory<C, Integer> newServerConnectionFactory(final RequestHandler<RequestContext> requestHandler) {
        Reject.ifNull(requestHandler);
        return new RequestHandlerFactoryAdapter(new RequestHandlerFactory<C, RequestContext>(){

            @Override
            public RequestHandler<RequestContext> handleAccept(C clientContext) {
                return requestHandler;
            }
        });
    }

    public static <C> ServerConnectionFactory<C, Integer> newServerConnectionFactory(RequestHandlerFactory<C, RequestContext> factory) {
        Reject.ifNull(factory);
        return new RequestHandlerFactoryAdapter<C>(factory);
    }

    public static Connection uncloseable(Connection connection) {
        return new AbstractConnectionWrapper<Connection>(connection){

            @Override
            public void close() {
            }

            @Override
            public void close(UnbindRequest request, String reason) {
            }
        };
    }

    public static ConnectionFactory uncloseable(final ConnectionFactory factory) {
        return new ConnectionFactory(){

            @Override
            public Promise<Connection, LdapException> getConnectionAsync() {
                return factory.getConnectionAsync();
            }

            @Override
            public Connection getConnection() throws LdapException {
                return factory.getConnection();
            }

            @Override
            public void close() {
            }
        };
    }

    public static String getHostString(InetSocketAddress socketAddress) {
        if (socketAddress.isUnresolved()) {
            return socketAddress.getHostName();
        }
        InetAddress address = socketAddress.getAddress();
        String hostSlashIp = address.toString();
        int slashPos = hostSlashIp.indexOf(47);
        if (slashPos == 0) {
            return hostSlashIp.substring(1);
        }
        return hostSlashIp.substring(0, slashPos);
    }

    private Connections() {
    }

    static class LeastRequestsDispatcher {
        private final AtomicLongArray serversCounters;

        LeastRequestsDispatcher(int numberOfServers) {
            this.serversCounters = new AtomicLongArray(numberOfServers);
        }

        int size() {
            return this.serversCounters.length();
        }

        int selectServer(int forceIndex) {
            int index = forceIndex == -1 ? this.getLessSaturatedIndex() : forceIndex;
            this.serversCounters.incrementAndGet(index);
            return index;
        }

        void terminatedRequest(Integer index) {
            this.serversCounters.decrementAndGet(index);
        }

        private int getLessSaturatedIndex() {
            long min = Long.MAX_VALUE;
            int minIndex = -1;
            for (int i = 0; i < this.serversCounters.length(); ++i) {
                long count = this.serversCounters.get(i);
                if (count >= min) continue;
                min = count;
                minIndex = i;
            }
            return minIndex;
        }
    }
}

