/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Collection;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.SubtreeDeleteRequestControl;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordVisitor;
import org.forgerock.opendj.ldif.ConnectionEntryReader;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;

public abstract class AbstractConnection
implements Connection {
    private static final ChangeRecordVisitor<Object, Connection> SYNC_VISITOR = new ChangeRecordVisitor<Object, Connection>(){

        @Override
        public Object visitChangeRecord(Connection p, AddRequest change) {
            try {
                return p.add(change);
            }
            catch (LdapException e) {
                return e;
            }
        }

        @Override
        public Object visitChangeRecord(Connection p, DeleteRequest change) {
            try {
                return p.delete(change);
            }
            catch (LdapException e) {
                return e;
            }
        }

        @Override
        public Object visitChangeRecord(Connection p, ModifyDNRequest change) {
            try {
                return p.modifyDN(change);
            }
            catch (LdapException e) {
                return e;
            }
        }

        @Override
        public Object visitChangeRecord(Connection p, ModifyRequest change) {
            try {
                return p.modify(change);
            }
            catch (LdapException e) {
                return e;
            }
        }
    };

    protected AbstractConnection() {
    }

    @Override
    public Result add(Entry entry) throws LdapException {
        return this.add(Requests.newAddRequest(entry));
    }

    @Override
    public Result add(String ... ldifLines) throws LdapException {
        return this.add(Requests.newAddRequest(ldifLines));
    }

    @Override
    public LdapPromise<Result> addAsync(AddRequest request) {
        return this.addAsync(request, null);
    }

    @Override
    public Result applyChange(ChangeRecord request) throws LdapException {
        Object result = request.accept(SYNC_VISITOR, this);
        if (result instanceof Result) {
            return (Result)result;
        }
        throw (LdapException)result;
    }

    @Override
    public LdapPromise<Result> applyChangeAsync(ChangeRecord request) {
        return this.applyChangeAsync(request, null);
    }

    @Override
    public LdapPromise<Result> applyChangeAsync(ChangeRecord request, final IntermediateResponseHandler intermediateResponseHandler) {
        ChangeRecordVisitor<LdapPromise<Result>, Connection> visitor = new ChangeRecordVisitor<LdapPromise<Result>, Connection>(){

            @Override
            public LdapPromise<Result> visitChangeRecord(Connection p, AddRequest change) {
                return p.addAsync(change, intermediateResponseHandler);
            }

            @Override
            public LdapPromise<Result> visitChangeRecord(Connection p, DeleteRequest change) {
                return p.deleteAsync(change, intermediateResponseHandler);
            }

            @Override
            public LdapPromise<Result> visitChangeRecord(Connection p, ModifyDNRequest change) {
                return p.modifyDNAsync(change, intermediateResponseHandler);
            }

            @Override
            public LdapPromise<Result> visitChangeRecord(Connection p, ModifyRequest change) {
                return p.modifyAsync(change, intermediateResponseHandler);
            }
        };
        return request.accept(visitor, this);
    }

    @Override
    public BindResult bind(String name, char[] password) throws LdapException {
        return this.bind(Requests.newSimpleBindRequest(name, password));
    }

    @Override
    public LdapPromise<BindResult> bindAsync(BindRequest request) {
        return this.bindAsync(request, null);
    }

    @Override
    public void close() {
        this.close(Requests.newUnbindRequest(), null);
    }

    @Override
    public CompareResult compare(String name, String attributeDescription, String assertionValue) throws LdapException {
        return this.compare(Requests.newCompareRequest(name, attributeDescription, (Object)assertionValue));
    }

    @Override
    public LdapPromise<CompareResult> compareAsync(CompareRequest request) {
        return this.compareAsync(request, null);
    }

    @Override
    public Result delete(String name) throws LdapException {
        return this.delete(Requests.newDeleteRequest(name));
    }

    @Override
    public LdapPromise<Result> deleteAsync(DeleteRequest request) {
        return this.deleteAsync(request, null);
    }

    @Override
    public Result deleteSubtree(String name) throws LdapException {
        return this.delete(Requests.newDeleteRequest(name).addControl(SubtreeDeleteRequestControl.newControl(true)));
    }

    @Override
    public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request) throws LdapException {
        return this.extendedRequest(request, null);
    }

    @Override
    public GenericExtendedResult extendedRequest(String requestName, ByteString requestValue) throws LdapException {
        return this.extendedRequest(Requests.newGenericExtendedRequest(requestName, requestValue));
    }

    @Override
    public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request) {
        return this.extendedRequestAsync(request, null);
    }

    @Override
    public Result modify(String ... ldifLines) throws LdapException {
        return this.modify(Requests.newModifyRequest(ldifLines));
    }

    @Override
    public LdapPromise<Result> modifyAsync(ModifyRequest request) {
        return this.modifyAsync(request, null);
    }

    @Override
    public Result modifyDN(String name, String newRDN) throws LdapException {
        return this.modifyDN(Requests.newModifyDNRequest(name, newRDN));
    }

    @Override
    public LdapPromise<Result> modifyDNAsync(ModifyDNRequest request) {
        return this.modifyDNAsync(request, null);
    }

    @Override
    public SearchResultEntry readEntry(DN baseObject, String ... attributeDescriptions) throws LdapException {
        SearchRequest request = Requests.newSingleEntrySearchRequest(baseObject, SearchScope.BASE_OBJECT, Filter.objectClassPresent(), attributeDescriptions);
        return this.searchSingleEntry(request);
    }

    @Override
    public SearchResultEntry readEntry(String baseObject, String ... attributeDescriptions) throws LdapException {
        return this.readEntry(DN.valueOf(baseObject), attributeDescriptions);
    }

    @Override
    public LdapPromise<SearchResultEntry> readEntryAsync(DN name, Collection<String> attributeDescriptions) {
        SearchRequest request = Requests.newSingleEntrySearchRequest(name, SearchScope.BASE_OBJECT, Filter.objectClassPresent(), new String[0]);
        if (attributeDescriptions != null) {
            request.getAttributes().addAll(attributeDescriptions);
        }
        return this.searchSingleEntryAsync(request);
    }

    @Override
    public ConnectionEntryReader search(SearchRequest request) {
        return new ConnectionEntryReader(this, request);
    }

    @Override
    public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries) throws LdapException {
        return this.search(request, entries, null);
    }

    @Override
    public Result search(SearchRequest request, final Collection<? super SearchResultEntry> entries, final Collection<? super SearchResultReference> references) throws LdapException {
        Reject.ifNull(request, entries);
        SearchResultHandler handler = new SearchResultHandler(){

            @Override
            public boolean handleEntry(SearchResultEntry entry) {
                entries.add(entry);
                return true;
            }

            @Override
            public boolean handleReference(SearchResultReference reference) {
                if (references != null) {
                    references.add(reference);
                }
                return true;
            }
        };
        return this.search(request, handler);
    }

    @Override
    public ConnectionEntryReader search(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) {
        return this.search(Requests.newSearchRequest(baseObject, scope, filter, attributeDescriptions));
    }

    @Override
    public LdapPromise<Result> searchAsync(SearchRequest request, SearchResultHandler resultHandler) {
        return this.searchAsync(request, null, resultHandler);
    }

    @Override
    public SearchResultEntry searchSingleEntry(SearchRequest request) throws LdapException {
        SingleEntryHandler handler = new SingleEntryHandler();
        try {
            this.search(this.enforceSingleEntrySearchRequest(request), handler);
            return handler.getSingleEntry();
        }
        catch (LdapException e) {
            throw handler.filterError(e);
        }
    }

    @Override
    public SearchResultEntry searchSingleEntry(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) throws LdapException {
        SearchRequest request = Requests.newSingleEntrySearchRequest(baseObject, scope, filter, attributeDescriptions);
        return this.searchSingleEntry(request);
    }

    @Override
    public LdapPromise<SearchResultEntry> searchSingleEntryAsync(SearchRequest request) {
        final SingleEntryHandler handler = new SingleEntryHandler();
        return LdapPromises.asPromise(this.searchAsync(this.enforceSingleEntrySearchRequest(request), handler).then(new Function<Result, SearchResultEntry, LdapException>(){

            @Override
            public SearchResultEntry apply(Result value) throws LdapException {
                return handler.getSingleEntry();
            }
        }, new Function<LdapException, SearchResultEntry, LdapException>(){

            @Override
            public SearchResultEntry apply(LdapException error) throws LdapException {
                throw handler.filterError(error);
            }
        }));
    }

    private SearchRequest enforceSingleEntrySearchRequest(SearchRequest request) {
        if (request.isSingleEntrySearch()) {
            return request;
        }
        return Requests.copyOfSearchRequest(request).setSizeLimit(1);
    }

    public abstract String toString();

    private static final class SingleEntryHandler
    implements SearchResultHandler {
        private volatile SearchResultEntry firstEntry;
        private volatile SearchResultReference firstReference;
        private volatile int entryCount;

        private SingleEntryHandler() {
        }

        @Override
        public boolean handleEntry(SearchResultEntry entry) {
            if (this.firstEntry == null) {
                this.firstEntry = entry;
            }
            ++this.entryCount;
            return true;
        }

        @Override
        public boolean handleReference(SearchResultReference reference) {
            if (this.firstReference == null) {
                this.firstReference = reference;
            }
            return true;
        }

        private LdapException filterError(LdapException error) {
            if (error.getResult().getResultCode().equals(ResultCode.SIZE_LIMIT_EXCEEDED)) {
                return LdapException.newLdapException(ResultCode.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED, CoreMessages.ERR_UNEXPECTED_SEARCH_RESULT_ENTRIES_NO_COUNT.get().toString());
            }
            return error;
        }

        private SearchResultEntry getSingleEntry() throws LdapException {
            if (this.entryCount == 0) {
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_NO_RESULTS_RETURNED, CoreMessages.ERR_NO_SEARCH_RESULT_ENTRIES.get().toString());
            }
            if (this.entryCount > 1) {
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED, CoreMessages.ERR_UNEXPECTED_SEARCH_RESULT_ENTRIES.get(this.entryCount).toString());
            }
            if (this.firstReference != null) {
                throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED, CoreMessages.ERR_UNEXPECTED_SEARCH_RESULT_REFERENCES.get(this.firstReference.getURIs().iterator().next()).toString());
            }
            return this.firstEntry;
        }
    }
}

