/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Reject;

public final class AVA
implements Comparable<AVA> {
    private final AttributeType attributeType;
    private final String attributeName;
    private final ByteString attributeValue;
    private ByteString equalityNormalizedAttributeValue;
    private ByteString orderingNormalizedAttributeValue;

    public static AVA valueOf(String ava) {
        return AVA.valueOf(ava, Schema.getDefaultSchema());
    }

    public static AVA valueOf(String ava, Schema schema) {
        SubstringReader reader = new SubstringReader(ava);
        try {
            return AVA.decode(reader, schema);
        }
        catch (UnknownSchemaElementException e) {
            LocalizableMessage message = CoreMessages.ERR_RDN_TYPE_NOT_FOUND.get(ava, e.getMessageObject());
            throw new LocalizedIllegalArgumentException(message);
        }
    }

    static AVA decode(SubstringReader reader, Schema schema) {
        reader.skipWhitespaces();
        if (reader.remaining() == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_NO_NAME.get(reader.getString());
            throw new LocalizedIllegalArgumentException(message);
        }
        String nameOrOid = AVA.readAttributeName(reader);
        AttributeType attribute = schema.getAttributeType(nameOrOid);
        reader.skipWhitespaces();
        if (reader.remaining() == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_END_WITH_ATTR_NAME.get(reader.getString(), attribute.getNameOrOID());
            throw new LocalizedIllegalArgumentException(message);
        }
        char c = reader.read();
        if (c != '=') {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_NO_EQUAL.get(reader.getString(), attribute.getNameOrOID(), Character.valueOf(c));
            throw new LocalizedIllegalArgumentException(message);
        }
        reader.skipWhitespaces();
        ByteString value = AVA.readAttributeValue(reader);
        return new AVA(attribute, nameOrOid, value);
    }

    static void escapeAttributeValue(String str, StringBuilder builder) {
        if (str.length() > 0) {
            char c = str.charAt(0);
            int startPos = 0;
            if (c == ' ' || c == '#') {
                builder.append('\\');
                builder.append(c);
                startPos = 1;
            }
            int length = str.length();
            for (int si = startPos; si < length; ++si) {
                c = str.charAt(si);
                if (c < ' ') {
                    for (byte b : StaticUtils.getBytes(String.valueOf(c))) {
                        builder.append('\\');
                        builder.append(StaticUtils.byteToLowerHex(b));
                    }
                    continue;
                }
                if (c == ' ' && si == length - 1 || c == '\"' || c == '+' || c == ',' || c == ';' || c == '<' || c == '>' || c == '\\' || c == '\u0000' || c == '=') {
                    builder.append('\\');
                }
                builder.append(c);
            }
        }
    }

    private static String readAttributeName(SubstringReader reader) {
        int length = 1;
        reader.mark();
        char c = reader.read();
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (reader.remaining() > 0 && (c = reader.read()) != '=' && c != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        throw AVA.illegalCharacter(reader, c);
                    }
                    lastWasPeriod = true;
                } else {
                    if (!StaticUtils.isDigit(c)) {
                        throw AVA.illegalCharacter(reader, c);
                    }
                    lastWasPeriod = false;
                }
                ++length;
            }
            if (lastWasPeriod) {
                throw AVA.illegalCharacter(reader, '.');
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (reader.remaining() > 0 && (c = reader.read()) != '=' && c != ' ') {
                if (!StaticUtils.isAlpha(c) && !StaticUtils.isDigit(c) && c != '-') {
                    throw AVA.illegalCharacter(reader, c);
                }
                ++length;
            }
        } else {
            throw AVA.illegalCharacter(reader, c);
        }
        reader.reset();
        return reader.read(length);
    }

    private static LocalizedIllegalArgumentException illegalCharacter(SubstringReader reader, char c) {
        return new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get(reader.getString(), Character.valueOf(c), reader.pos() - 1));
    }

    private static ByteString readAttributeValue(SubstringReader reader) {
        if (reader.remaining() == 0) {
            return ByteString.empty();
        }
        reader.mark();
        char c = reader.read();
        if (c == '+') {
            reader.reset();
            return ByteString.empty();
        }
        if (c == '#') {
            return AVA.readAttributeValueAsBER(reader);
        }
        if (c == '\"') {
            reader.mark();
            return AVA.readAttributeValue(reader, true);
        }
        return AVA.readAttributeValue(reader, false);
    }

    private static ByteString readAttributeValueAsBER(SubstringReader reader) {
        reader.mark();
        if (reader.remaining() < 2) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_HEX_VALUE_TOO_SHORT.get(reader.getString()));
        }
        int length = 0;
        for (int i = 0; i < 2; ++i) {
            char c = reader.read();
            if (StaticUtils.isHexDigit(c)) {
                ++length;
                continue;
            }
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT.get(reader.getString(), Character.valueOf(c)));
        }
        while (reader.remaining() > 0) {
            char c = reader.read();
            if (StaticUtils.isHexDigit(c)) {
                ++length;
                if (reader.remaining() > 0) {
                    c = reader.read();
                    if (StaticUtils.isHexDigit(c)) {
                        ++length;
                        continue;
                    }
                    throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT.get(reader.getString(), Character.valueOf(c)));
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_HEX_VALUE_TOO_SHORT.get(reader.getString()));
            }
            if (c == ' ' || c == ',' || c == ';') break;
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT.get(reader.getString(), Character.valueOf(c)));
        }
        try {
            reader.reset();
            return ByteString.valueOfHex(reader.read(length));
        }
        catch (LocalizedIllegalArgumentException e) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_VALUE_DECODE_FAILURE.get(reader.getString(), e.getMessageObject()));
        }
    }

    private static ByteString readAttributeValue(SubstringReader reader, boolean isQuoted) {
        reader.reset();
        ByteString bytes = AVA.delimitAndEvaluateEscape(reader, isQuoted);
        if (bytes.length() == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_INVALID_REQUIRES_ESCAPE_CHAR.get(reader.getString(), reader.pos());
            throw new LocalizedIllegalArgumentException(message);
        }
        return bytes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ByteString delimitAndEvaluateEscape(SubstringReader reader, boolean isQuoted) {
        StringBuilder valueBuffer = new StringBuilder();
        StringBuilder hexBuffer = null;
        boolean escaped = false;
        int trailingSpaces = 0;
        while (reader.remaining() > 0) {
            char c = reader.read();
            if (escaped) {
                if (StaticUtils.isHexDigit(c)) {
                    if (reader.remaining() <= 0) {
                        throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_ESCAPED_HEX_VALUE_INVALID.get(reader.getString()));
                    }
                    char c2 = reader.read();
                    if (!StaticUtils.isHexDigit(c2)) throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_ESCAPED_HEX_VALUE_INVALID.get(reader.getString()));
                    if (hexBuffer == null) {
                        hexBuffer = new StringBuilder();
                    }
                    hexBuffer.append(c);
                    hexBuffer.append(c2);
                    if (reader.remaining() == 0) {
                        AVA.appendHexChars(reader, valueBuffer, hexBuffer);
                    }
                } else {
                    AVA.appendHexChars(reader, valueBuffer, hexBuffer);
                    valueBuffer.append(c);
                }
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
                trailingSpaces = 0;
            } else {
                if (isQuoted && c == '\"') {
                    AVA.appendHexChars(reader, valueBuffer, hexBuffer);
                    reader.skipWhitespaces();
                    return ByteString.valueOfUtf8(valueBuffer);
                }
                if (!(isQuoted || c != '+' && c != ',' && c != ';')) {
                    reader.reset();
                    AVA.appendHexChars(reader, valueBuffer, hexBuffer);
                    valueBuffer.setLength(valueBuffer.length() - trailingSpaces);
                    return ByteString.valueOfUtf8(valueBuffer);
                }
                AVA.appendHexChars(reader, valueBuffer, hexBuffer);
                valueBuffer.append(c);
                trailingSpaces = c != ' ' ? 0 : trailingSpaces + 1;
            }
            reader.mark();
        }
        if (isQuoted) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_UNMATCHED_QUOTE.get(reader.getString()));
        }
        reader.reset();
        valueBuffer.setLength(valueBuffer.length() - trailingSpaces);
        return ByteString.valueOfUtf8(valueBuffer);
    }

    private static void appendHexChars(SubstringReader reader, StringBuilder valueBuffer, StringBuilder hexBuffer) {
        if (hexBuffer == null) {
            return;
        }
        ByteString bytes = ByteString.valueOfHex(hexBuffer.toString());
        try {
            valueBuffer.append(new String(bytes.toByteArray(), "UTF-8"));
        }
        catch (Exception e) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_VALUE_DECODE_FAILURE.get(reader.getString(), String.valueOf(e)));
        }
        hexBuffer.setLength(0);
    }

    public AVA(AttributeType attributeType, Object attributeValue) {
        this(attributeType, null, attributeValue);
    }

    public AVA(AttributeType attributeType, String attributeName, Object attributeValue) {
        this.attributeType = Reject.checkNotNull(attributeType);
        this.attributeName = this.computeAttributeName(attributeName, attributeType);
        this.attributeValue = ByteString.valueOfObject(Reject.checkNotNull(attributeValue));
    }

    public AVA(String attributeType, Object attributeValue) {
        this.attributeName = Reject.checkNotNull(attributeType);
        this.attributeType = Schema.getDefaultSchema().getAttributeType(attributeType);
        this.attributeValue = ByteString.valueOfObject(Reject.checkNotNull(attributeValue));
    }

    private String computeAttributeName(String attributeName, AttributeType attributeType) {
        return attributeName != null ? attributeName : attributeType.getNameOrOID();
    }

    @Override
    public int compareTo(AVA ava) {
        int result = this.attributeType.compareTo(ava.attributeType);
        if (result != 0) {
            return result > 0 ? 1 : -1;
        }
        ByteString normalizedValue = this.getOrderingNormalizedValue();
        ByteString otherNormalizedValue = ava.getOrderingNormalizedValue();
        return normalizedValue.compareTo(otherNormalizedValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AVA) {
            AVA ava = (AVA)obj;
            if (!this.attributeType.equals(ava.attributeType)) {
                return false;
            }
            ByteString normalizedValue = this.getEqualityNormalizedValue();
            ByteString otherNormalizedValue = ava.getEqualityNormalizedValue();
            return normalizedValue.equals(otherNormalizedValue);
        }
        return false;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public ByteString getAttributeValue() {
        return this.attributeValue;
    }

    public int hashCode() {
        return this.attributeType.hashCode() * 31 + this.getEqualityNormalizedValue().hashCode();
    }

    public Attribute toAttribute() {
        AttributeDescription ad = AttributeDescription.create(this.attributeType);
        return new LinkedAttribute(ad, (Object)this.attributeValue);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        return this.toString(builder).toString();
    }

    StringBuilder toString(StringBuilder builder) {
        if (this.attributeName.equals(this.attributeType.getOID())) {
            builder.append(this.attributeType.getOID());
            builder.append("=#");
            builder.append(this.attributeValue.toHexString());
        } else {
            builder.append(this.attributeName);
            builder.append("=");
            if (!this.attributeType.getSyntax().isHumanReadable()) {
                builder.append("#");
                builder.append(this.attributeValue.toHexString());
            } else {
                AVA.escapeAttributeValue(this.attributeValue.toString(), builder);
            }
        }
        return builder;
    }

    private ByteString getEqualityNormalizedValue() {
        ByteString normalizedValue = this.equalityNormalizedAttributeValue;
        if (normalizedValue != null) {
            return normalizedValue;
        }
        MatchingRule matchingRule = this.attributeType.getEqualityMatchingRule();
        if (matchingRule != null) {
            try {
                this.equalityNormalizedAttributeValue = matchingRule.normalizeAttributeValue(this.attributeValue);
            }
            catch (DecodeException de) {
                this.equalityNormalizedAttributeValue = this.attributeValue;
            }
        } else {
            this.equalityNormalizedAttributeValue = this.attributeValue;
        }
        return this.equalityNormalizedAttributeValue;
    }

    private ByteString getOrderingNormalizedValue() {
        ByteString normalizedValue = this.orderingNormalizedAttributeValue;
        if (normalizedValue != null) {
            return normalizedValue;
        }
        MatchingRule matchingRule = this.attributeType.getEqualityMatchingRule();
        if (matchingRule != null) {
            try {
                this.orderingNormalizedAttributeValue = matchingRule.normalizeAttributeValue(this.attributeValue);
            }
            catch (DecodeException de) {
                this.orderingNormalizedAttributeValue = this.getEqualityNormalizedValue();
            }
        } else {
            this.orderingNormalizedAttributeValue = this.getEqualityNormalizedValue();
        }
        return this.orderingNormalizedAttributeValue;
    }

    ByteStringBuilder toNormalizedByteString(ByteStringBuilder builder) {
        builder.appendUtf8(StaticUtils.toLowerCase(this.attributeType.getNameOrOID()));
        builder.appendUtf8("=");
        ByteString value = this.getEqualityNormalizedValue();
        if (value.length() > 0) {
            builder.appendBytes(this.escapeBytes(value));
        }
        return builder;
    }

    StringBuilder toNormalizedUrlSafe(StringBuilder builder) {
        builder.append(StaticUtils.toLowerCase(this.attributeType.getNameOrOID()));
        builder.append('=');
        ByteString value = this.getEqualityNormalizedValue();
        if (value.length() == 0) {
            return builder;
        }
        boolean hasAttributeName = !this.attributeType.getNames().isEmpty();
        boolean isHumanReadable = this.attributeType.getSyntax().isHumanReadable();
        if (!hasAttributeName || !isHumanReadable) {
            builder.append(value.toPercentHexString());
        } else {
            CharsetDecoder decoder;
            CharBuffer buffer = CharBuffer.allocate(value.length());
            if (value.copyTo(buffer, decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT))) {
                buffer.flip();
                try {
                    String val = URLEncoder.encode(buffer.toString(), "UTF-8").replaceAll("\\+", "%20");
                    builder.append(val);
                }
                catch (UnsupportedEncodingException e) {
                    builder.append(value.toPercentHexString());
                }
            } else {
                builder.append(value.toPercentHexString());
            }
        }
        return builder;
    }

    private ByteString escapeBytes(ByteString value) {
        if (!this.needEscaping(value)) {
            return value;
        }
        ByteStringBuilder builder = new ByteStringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            byte b = value.byteAt(i);
            if (this.isByteToEscape(b)) {
                builder.appendByte(2);
            }
            builder.appendByte(b);
        }
        return builder.toByteString();
    }

    private boolean needEscaping(ByteString value) {
        for (int i = 0; i < value.length(); ++i) {
            if (!this.isByteToEscape(value.byteAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isByteToEscape(byte b) {
        return b == 0 || b == 1 || b == 2;
    }
}

