/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.io;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;

public abstract class AbstractASN1Reader
implements ASN1Reader {
    protected AbstractASN1Reader() {
    }

    @Override
    public boolean readBoolean(byte type) throws IOException {
        if (type == 0) {
            type = 1;
        }
        this.checkType(type);
        return this.readBoolean();
    }

    @Override
    public int readEnumerated(byte type) throws IOException {
        if (type == 0) {
            type = (byte)10;
        }
        this.checkType(type);
        return this.readEnumerated();
    }

    @Override
    public long readInteger(byte type) throws IOException {
        if (type == 0) {
            type = (byte)2;
        }
        this.checkType(type);
        return this.readInteger();
    }

    @Override
    public void readNull(byte type) throws IOException {
        if (type == 0) {
            type = (byte)5;
        }
        this.checkType(type);
        this.readNull();
    }

    @Override
    public ByteString readOctetString(byte type) throws IOException {
        if (type == 0) {
            type = (byte)4;
        }
        this.checkType(type);
        return this.readOctetString();
    }

    @Override
    public ByteStringBuilder readOctetString(byte type, ByteStringBuilder builder) throws IOException {
        if (type == 0) {
            type = (byte)4;
        }
        this.checkType(type);
        this.readOctetString(builder);
        return builder;
    }

    @Override
    public String readOctetStringAsString(byte type) throws IOException {
        if (type == 0) {
            type = (byte)4;
        }
        this.checkType(type);
        return this.readOctetStringAsString();
    }

    @Override
    public void readStartExplicitTag(byte type) throws IOException {
        if (type == 0) {
            type = (byte)-96;
        }
        this.checkType(type);
        this.readStartExplicitTag();
    }

    @Override
    public void readStartSequence(byte type) throws IOException {
        if (type == 0) {
            type = (byte)48;
        }
        this.checkType(type);
        this.readStartSequence();
    }

    @Override
    public void readStartSet(byte type) throws IOException {
        if (type == 0) {
            type = (byte)49;
        }
        this.checkType(type);
        this.readStartSet();
    }

    @Override
    public ASN1Reader skipElement(byte expectedType) throws IOException {
        if (this.peekType() != expectedType) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_UNEXPECTED_TAG.get(expectedType, this.peekType());
            throw DecodeException.fatalError(message);
        }
        this.skipElement();
        return this;
    }

    private void checkType(byte expectedType) throws IOException {
        if (this.peekType() != expectedType) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_UNEXPECTED_TAG.get(expectedType, this.peekType());
            throw DecodeException.fatalError(message);
        }
    }
}

