/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.io;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import java.util.LinkedList;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.AbstractASN1Reader;
import org.forgerock.opendj.ldap.ByteSequenceReader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;

final class ASN1ByteSequenceReader
extends AbstractASN1Reader {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private int state = 0;
    private byte peekType;
    private int peekLength = -1;
    private final int maxElementSize;
    private ByteSequenceReader reader;
    private final LinkedList<ByteSequenceReader> readerStack = new LinkedList();

    ASN1ByteSequenceReader(ByteSequenceReader reader, int maxElementSize) {
        this.reader = reader;
        this.maxElementSize = maxElementSize;
    }

    @Override
    public void close() throws IOException {
        this.readerStack.clear();
    }

    @Override
    public boolean elementAvailable() throws IOException {
        return !(this.state == 0 && !this.needTypeState(false) || this.state == 1 && !this.needFirstLengthByteState(false) || this.peekLength > this.reader.remaining());
    }

    @Override
    public boolean hasNextElement() throws IOException {
        return this.state != 0 || this.needTypeState(false);
    }

    @Override
    public int peekLength() throws IOException {
        this.peekType();
        if (this.state == 1) {
            this.needFirstLengthByteState(true);
        }
        return this.peekLength;
    }

    @Override
    public byte peekType() throws IOException {
        if (this.state == 0) {
            if (this.reader.remaining() <= 0) {
                LocalizableMessage message = CoreMessages.ERR_ASN1_TRUCATED_TYPE_BYTE.get();
                throw DecodeException.fatalError(message);
            }
            byte type = this.reader.readByte();
            this.peekType = type;
            this.state = 1;
        }
        return this.peekType;
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.peekLength();
        if (this.peekLength != 1) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_BOOLEAN_INVALID_LENGTH.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        if (this.reader.remaining() < this.peekLength) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_BOOLEAN_TRUNCATED_VALUE.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        byte readByte = this.reader.readByte();
        this.state = 0;
        return readByte != 0;
    }

    @Override
    public void readEndSequence() throws IOException {
        if (this.readerStack.isEmpty()) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_SEQUENCE_READ_NOT_STARTED.get();
            throw new IllegalStateException(message.toString());
        }
        if (this.reader.remaining() > 0) {
            logger.debug(LocalizableMessage.raw("Ignoring %d unused trailing bytes in ASN.1 SEQUENCE", this.reader.remaining()));
        }
        this.reader = this.readerStack.removeFirst();
        this.state = 0;
    }

    @Override
    public void readEndExplicitTag() throws DecodeException, IOException {
        this.readEndSequence();
    }

    @Override
    public void readEndSet() throws IOException {
        this.readEndSequence();
    }

    @Override
    public int readEnumerated() throws IOException {
        this.peekLength();
        if (this.peekLength < 1 || this.peekLength > 4) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_INTEGER_INVALID_LENGTH.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        return (int)this.readInteger();
    }

    @Override
    public long readInteger() throws IOException {
        this.peekLength();
        if (this.peekLength < 1 || this.peekLength > 8) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_INTEGER_INVALID_LENGTH.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        if (this.reader.remaining() < this.peekLength) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_INTEGER_TRUNCATED_VALUE.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        if (this.peekLength > 4) {
            long longValue = 0L;
            for (int i = 0; i < this.peekLength; ++i) {
                byte readByte = this.reader.readByte();
                if (i == 0 && readByte < 0) {
                    longValue = -1L;
                }
                longValue = longValue << 8 | (long)(readByte & 0xFF);
            }
            this.state = 0;
            return longValue;
        }
        int intValue = 0;
        for (int i = 0; i < this.peekLength; ++i) {
            byte readByte = this.reader.readByte();
            if (i == 0 && readByte < 0) {
                intValue = -1;
            }
            intValue = intValue << 8 | readByte & 0xFF;
        }
        this.state = 0;
        return intValue;
    }

    @Override
    public void readNull() throws IOException {
        this.peekLength();
        if (this.peekLength != 0) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_NULL_INVALID_LENGTH.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        this.state = 0;
    }

    @Override
    public ByteString readOctetString() throws IOException {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        this.state = 0;
        return this.reader.readByteString(this.peekLength);
    }

    @Override
    public ByteStringBuilder readOctetString(ByteStringBuilder builder) throws IOException {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        builder.appendBytes(this.reader, this.peekLength);
        this.state = 0;
        return builder;
    }

    @Override
    public String readOctetStringAsString() throws IOException {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        this.state = 0;
        return this.reader.readStringUtf8(this.peekLength);
    }

    @Override
    public void readStartSequence() throws IOException {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_SEQUENCE_SET_TRUNCATED_VALUE.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        ByteSequenceReader subByteString = this.reader.readByteSequence(this.peekLength).asReader();
        this.readerStack.addFirst(this.reader);
        this.reader = subByteString;
        this.state = 0;
    }

    @Override
    public void readStartExplicitTag() throws DecodeException, IOException {
        this.readStartSequence();
    }

    @Override
    public void readStartSet() throws IOException {
        this.readStartSequence();
    }

    @Override
    public ASN1Reader skipElement() throws IOException {
        this.peekLength();
        if (this.reader.remaining() < this.peekLength) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_SKIP_TRUNCATED_VALUE.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        this.state = 0;
        this.reader.skip(this.peekLength);
        return this;
    }

    private boolean needFirstLengthByteState(boolean throwEofException) throws IOException {
        if (this.reader.remaining() <= 0) {
            if (throwEofException) {
                LocalizableMessage message = CoreMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTE.get();
                throw DecodeException.fatalError(message);
            }
            return false;
        }
        byte readByte = this.reader.readByte();
        this.peekLength = readByte & 0x7F;
        if (this.peekLength != readByte) {
            int lengthBytesNeeded = this.peekLength;
            if (lengthBytesNeeded > 4) {
                LocalizableMessage message = CoreMessages.ERR_ASN1_INVALID_NUM_LENGTH_BYTES.get(lengthBytesNeeded);
                throw DecodeException.fatalError(message);
            }
            this.peekLength = 0;
            if (this.reader.remaining() < lengthBytesNeeded) {
                if (throwEofException) {
                    LocalizableMessage message = CoreMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTES.get(lengthBytesNeeded);
                    throw DecodeException.fatalError(message);
                }
                return false;
            }
            while (lengthBytesNeeded > 0) {
                readByte = this.reader.readByte();
                this.peekLength = this.peekLength << 8 | readByte & 0xFF;
                --lengthBytesNeeded;
            }
        }
        if (this.maxElementSize > 0 && this.peekLength > this.maxElementSize) {
            LocalizableMessage message = CoreMessages.ERR_LDAP_CLIENT_DECODE_MAX_REQUEST_SIZE_EXCEEDED.get(this.peekLength, this.maxElementSize);
            throw DecodeException.fatalError(message);
        }
        this.state = 3;
        return true;
    }

    private boolean needTypeState(boolean throwEofException) throws IOException {
        if (this.reader.remaining() <= 0) {
            if (throwEofException) {
                LocalizableMessage message = CoreMessages.ERR_ASN1_TRUCATED_TYPE_BYTE.get();
                throw DecodeException.fatalError(message);
            }
            return false;
        }
        byte type = this.reader.readByte();
        this.peekType = type;
        this.state = 1;
        return true;
    }
}

