/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.reactive.Action;
import com.forgerock.reactive.Completable;
import com.forgerock.reactive.ReactiveHandler;
import com.forgerock.reactive.RxJavaStreams;
import com.forgerock.reactive.Stream;
import io.reactivex.internal.util.BackpressureHelper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslServer;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.grizzly.LdapCodec;
import org.forgerock.opendj.grizzly.LdapResponseMessageWriter;
import org.forgerock.opendj.grizzly.SaslFilter;
import org.forgerock.opendj.grizzly.StartTLSFilter;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.AbstractLDAPMessageHandler;
import org.forgerock.opendj.io.LDAP;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LDAPClientContextEventListener;
import org.forgerock.opendj.ldap.LDAPListener;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Response;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.spi.LdapMessages;
import org.forgerock.util.Function;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.promise.RuntimeExceptionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class LDAPServerFilter
extends BaseFilter {
    private final Function<LDAPClientContext, ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>>, LdapException> connectionHandlerFactory;
    private static final Object[][] CIPHER_KEY_SIZES = new Object[][]{{"_WITH_AES_256_CBC_", 256}, {"_WITH_CAMELLIA_256_CBC_", 256}, {"_WITH_AES_256_GCM_", 256}, {"_WITH_3DES_EDE_CBC_", 112}, {"_WITH_AES_128_GCM_", 128}, {"_WITH_SEED_CBC_", 128}, {"_WITH_CAMELLIA_128_CBC_", 128}, {"_WITH_AES_128_CBC_", 128}, {"_WITH_IDEA_CBC_", 128}, {"_WITH_RC4_128_", 128}, {"_WITH_FORTEZZA_CBC_", 96}, {"_WITH_DES_CBC_", 56}, {"_WITH_RC4_56_", 56}, {"_WITH_RC2_CBC_40_", 40}, {"_WITH_DES_CBC_40_", 40}, {"_WITH_RC4_40_", 40}, {"_WITH_DES40_CBC_", 40}, {"_WITH_NULL_", 0}};
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final int maxConcurrentRequests;
    private final Options connectionOptions;
    private DecodeOptions decodeOptions;

    LDAPServerFilter(Function<LDAPClientContext, ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>>, LdapException> connectionHandlerFactory, Options connectionOptions, DecodeOptions options, int maxPendingRequests) {
        this.connectionHandlerFactory = connectionHandlerFactory;
        this.connectionOptions = connectionOptions;
        this.decodeOptions = options;
        this.maxConcurrentRequests = maxPendingRequests;
    }

    @Override
    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        final Connection connection = ctx.getConnection();
        GrizzlyUtils.configureConnection(connection, logger, this.connectionOptions);
        connection.configureBlocking(false);
        final ClientConnectionImpl clientContext = new ClientConnectionImpl(connection);
        connection.setProcessor(FilterChainBuilder.stateless().addAll((FilterChain)connection.getProcessor()).add(new LdapCodec(this.connectionOptions.get(LDAPListener.REQUEST_MAX_SIZE_IN_BYTES), this.decodeOptions){

            @Override
            protected void onLdapCodecError(FilterChainContext ctx, Throwable error) {
                clientContext.exceptionOccurred(ctx, error);
            }
        }).add(clientContext).build());
        final ReactiveHandler<LDAPClientContext, LdapMessages.LdapRequestEnvelope, Stream<Response>> requestHandler = this.connectionHandlerFactory.apply(clientContext);
        clientContext.read().flatMap(new Function<LdapMessages.LdapRequestEnvelope, Publisher<Void>, Exception>(){

            @Override
            public Publisher<Void> apply(final LdapMessages.LdapRequestEnvelope rawRequest) throws Exception {
                Stream response;
                if (rawRequest.getMessageType() == 66) {
                    clientContext.notifyConnectionClosedRawUnbind(rawRequest);
                    return RxJavaStreams.emptyStream();
                }
                try {
                    response = (Stream)requestHandler.handle(clientContext, rawRequest);
                }
                catch (Exception e) {
                    response = RxJavaStreams.streamError(e);
                }
                return clientContext.write(response.map(LDAPServerFilter.this.toLdapResponseMessage(rawRequest))).onErrorResumeWith(new Function<Throwable, Completable, Exception>(){

                    @Override
                    public Completable apply(Throwable error) throws Exception {
                        if (!(error instanceof LdapException)) {
                            return RxJavaStreams.completableError(error);
                        }
                        LdapException exception = (LdapException)error;
                        return clientContext.write(RxJavaStreams.singleFrom(LDAPServerFilter.this.toLdapResponseMessage(rawRequest, exception.getResult())));
                    }
                });
            }
        }, this.maxConcurrentRequests).onErrorResumeWith(new Function<Throwable, Publisher<Void>, Exception>(){

            @Override
            public Publisher<Void> apply(Throwable error) throws Exception {
                clientContext.notifyConnectionError(error);
                return RxJavaStreams.emptyStream();
            }
        }).onComplete(new Action(){

            @Override
            public void run() throws Exception {
                connection.closeSilently();
            }
        }).subscribe();
        return ctx.getStopAction();
    }

    private final LdapMessages.LdapResponseMessage toLdapResponseMessage(LdapMessages.LdapRequestEnvelope rawRequest, Result result) {
        byte resultType = LDAP.OP_TO_RESULT_TYPE[rawRequest.getMessageType()];
        if (resultType == 0) {
            throw new IllegalArgumentException("Unknown request: " + rawRequest.getMessageType());
        }
        return LdapMessages.newResponseMessage(resultType, rawRequest.getMessageId(), result);
    }

    private Function<Response, LdapMessages.LdapResponseMessage, Exception> toLdapResponseMessage(final LdapMessages.LdapRequestEnvelope rawRequest) {
        return new Function<Response, LdapMessages.LdapResponseMessage, Exception>(){

            @Override
            public LdapMessages.LdapResponseMessage apply(Response response) {
                if (response instanceof Result) {
                    return LDAPServerFilter.this.toLdapResponseMessage(rawRequest, (Result)response);
                }
                if (response instanceof IntermediateResponse) {
                    return LdapMessages.newResponseMessage((byte)121, rawRequest.getMessageId(), response);
                }
                if (response instanceof SearchResultEntry) {
                    return LdapMessages.newResponseMessage((byte)100, rawRequest.getMessageId(), response);
                }
                if (response instanceof SearchResultReference) {
                    return LdapMessages.newResponseMessage((byte)115, rawRequest.getMessageId(), response);
                }
                throw new IllegalArgumentException("Not implemented for a response of type " + (response != null ? response.getClass() : null));
            }
        };
    }

    final class ClientConnectionImpl
    extends BaseFilter
    implements LDAPClientContext {
        private final Connection<?> connection;
        private volatile boolean isClosed;
        private final List<LDAPClientContextEventListener> connectionEventListeners = new LinkedList<LDAPClientContextEventListener>();
        private GrizzlyBackpressureSubscription downstream;

        private ClientConnectionImpl(Connection<?> connection) {
            this.connection = connection;
        }

        @Override
        public NextAction handleRead(FilterChainContext ctx) {
            return this.downstream.handleRead(ctx);
        }

        @Override
        public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
            GrizzlyBackpressureSubscription immutableRef = this.downstream;
            if (immutableRef != null) {
                immutableRef.onError(error);
            } else {
                ctx.getConnection().closeSilently();
            }
        }

        @Override
        public NextAction handleClose(FilterChainContext ctx) {
            this.isClosed = true;
            GrizzlyBackpressureSubscription immutableRef = this.downstream;
            if (immutableRef != null) {
                immutableRef.onComplete();
            }
            this.notifyConnectionClosedRawUnbind(null);
            return ctx.getStopAction();
        }

        Stream<LdapMessages.LdapRequestEnvelope> read() {
            return RxJavaStreams.streamFromPublisher(new Publisher<LdapMessages.LdapRequestEnvelope>(){

                @Override
                public void subscribe(Subscriber<? super LdapMessages.LdapRequestEnvelope> subscriber) {
                    if (ClientConnectionImpl.this.downstream != null) {
                        subscriber.onSubscribe(new Subscription(){

                            @Override
                            public void request(long n) {
                            }

                            @Override
                            public void cancel() {
                            }
                        });
                        subscriber.onError(new IllegalStateException("read() cannot be subscribed multiple times"));
                        return;
                    }
                    ClientConnectionImpl.this.downstream = new GrizzlyBackpressureSubscription(subscriber);
                }
            });
        }

        Completable write(final Publisher<LdapMessages.LdapResponseMessage> messages) {
            return RxJavaStreams.newCompletable(new Completable.Emitter(){

                @Override
                public void subscribe(Completable.Subscriber e) {
                    messages.subscribe(new LdapResponseMessageWriter(ClientConnectionImpl.this.connection, e));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean enableTLS(SSLEngine sslEngine, boolean startTls) {
            Reject.ifNull(sslEngine, "sslEngine must not be null");
            ClientConnectionImpl clientConnectionImpl = this;
            synchronized (clientConnectionImpl) {
                if (this.filterExists(SSLFilter.class)) {
                    return false;
                }
                SSLUtils.setSSLEngine(this.connection, sslEngine);
                Properties props = System.getProperties();
                String keyStoreFile = props.getProperty("javax.net.ssl.keyStore");
                if ("none".equalsIgnoreCase(keyStoreFile)) {
                    System.setProperty("javax.net.ssl.trustStore", "NONE");
                }
                SSLFilter sslFilter = new SSLFilter();
                sslFilter.setHandshakeTimeout(GrizzlyUtils.getLongProperty("org.forgerock.opendj.grizzly.handshakeTimeout", sslFilter.getHandshakeTimeout(TimeUnit.MILLISECONDS)), TimeUnit.MILLISECONDS);
                this.installFilter(startTls ? new StartTLSFilter(sslFilter) : sslFilter);
                return true;
            }
        }

        @Override
        public SSLSession getSSLSession() {
            SSLEngine sslEngine = SSLUtils.getSSLEngine(this.connection);
            return sslEngine != null ? sslEngine.getSession() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean enableSASL(SaslServer saslServer) {
            Reject.ifNull(saslServer, "saslServer must not be null");
            ClientConnectionImpl clientConnectionImpl = this;
            synchronized (clientConnectionImpl) {
                if (this.filterExists(SaslFilter.class)) {
                    return false;
                }
                SaslFilter.setSaslServer(this.connection, saslServer);
                this.installFilter(new SaslFilter());
                return true;
            }
        }

        @Override
        public SaslServer getSASLServer() {
            return SaslFilter.getSaslServer(this.connection);
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return (InetSocketAddress)this.connection.getLocalAddress();
        }

        @Override
        public InetSocketAddress getPeerAddress() {
            return (InetSocketAddress)this.connection.getPeerAddress();
        }

        @Override
        public int getSecurityStrengthFactor() {
            return Math.max(this.getSSLSecurityStrengthFactor(), this.getSaslSecurityStrengthFactor());
        }

        private int getSSLSecurityStrengthFactor() {
            SSLSession sslSession = this.getSSLSession();
            if (sslSession != null) {
                String cipherString = sslSession.getCipherSuite();
                for (Object[] cipher : CIPHER_KEY_SIZES) {
                    if (!cipherString.contains((String)cipher[0])) continue;
                    return (Integer)cipher[1];
                }
            }
            return 0;
        }

        private int getSaslSecurityStrengthFactor() {
            SaslServer saslServer = this.getSASLServer();
            if (saslServer == null) {
                return 0;
            }
            int ssf = 0;
            String qop = (String)saslServer.getNegotiatedProperty("javax.security.sasl.qop");
            if ("auth-int".equalsIgnoreCase(qop)) {
                return 1;
            }
            if ("auth-conf".equalsIgnoreCase(qop)) {
                String negStrength = (String)saslServer.getNegotiatedProperty("javax.security.sasl.strength");
                if ("low".equalsIgnoreCase(negStrength)) {
                    return 40;
                }
                if ("medium".equalsIgnoreCase(negStrength)) {
                    return 56;
                }
                if ("high".equalsIgnoreCase(negStrength)) {
                    return 128;
                }
            }
            return ssf;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LDAPClientContext(");
            builder.append(this.getLocalAddress());
            builder.append(',');
            builder.append(this.getPeerAddress());
            builder.append(')');
            return builder.toString();
        }

        private void installFilter(Filter filter) {
            GrizzlyUtils.addFilterToConnection(filter, this.connection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean filterExists(Class<?> filterKlass) {
            ClientConnectionImpl clientConnectionImpl = this;
            synchronized (clientConnectionImpl) {
                FilterChain currentFilterChain = (FilterChain)this.connection.getProcessor();
                for (Filter filter : currentFilterChain) {
                    if (!filterKlass.isAssignableFrom(filter.getClass())) continue;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(LDAPClientContextEventListener listener) {
            Reject.ifNull(listener, "listener must not be null");
            List<LDAPClientContextEventListener> list = this.connectionEventListeners;
            synchronized (list) {
                this.connectionEventListeners.add(listener);
            }
        }

        @Override
        public void disconnect() {
            this.notifyConnectionDisconnected(null, null);
            this.connection.closeSilently();
        }

        @Override
        public void disconnect(ResultCode resultCode, String diagnosticMessage) {
            this.notifyConnectionDisconnected(resultCode, diagnosticMessage);
            this.sendUnsolicitedNotification(Responses.newGenericExtendedResult(resultCode).setOID("1.3.6.1.4.1.1466.20036").setDiagnosticMessage(diagnosticMessage)).doAfterTerminate(new Action(){

                @Override
                public void run() throws Exception {
                    ClientConnectionImpl.this.connection.closeSilently();
                }
            }).subscribe();
        }

        private void notifyConnectionClosedRawUnbind(LdapMessages.LdapRequestEnvelope rawUnbindRequest) {
            if (rawUnbindRequest == null) {
                this.notifyConnectionClosed(null);
            } else {
                try {
                    LDAP.getReader((ASN1Reader)rawUnbindRequest.getContent(), new DecodeOptions()).readMessage(new AbstractLDAPMessageHandler(){

                        @Override
                        public void unbindRequest(int messageID, UnbindRequest unbindRequest) throws DecodeException, IOException {
                            ClientConnectionImpl.this.notifyConnectionClosed(unbindRequest);
                        }
                    });
                }
                catch (Exception e) {
                    this.notifyConnectionClosed(null);
                }
            }
        }

        private void notifyConnectionDisconnected(ResultCode resultCode, String diagnosticMessage) {
            for (LDAPClientContextEventListener listener : this.getAndClearListeners()) {
                try {
                    listener.handleConnectionDisconnected(this, resultCode, diagnosticMessage);
                }
                catch (Exception e) {
                    logger.traceException(e);
                }
            }
        }

        private void notifyConnectionClosed(UnbindRequest unbindRequest) {
            for (LDAPClientContextEventListener listener : this.getAndClearListeners()) {
                try {
                    listener.handleConnectionClosed(this, unbindRequest);
                }
                catch (Exception e) {
                    logger.traceException(e);
                }
            }
        }

        private void notifyConnectionError(Throwable error) {
            for (LDAPClientContextEventListener listener : this.getAndClearListeners()) {
                try {
                    listener.handleConnectionError(this, error);
                }
                catch (Exception e) {
                    logger.traceException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<LDAPClientContextEventListener> getAndClearListeners() {
            List<LDAPClientContextEventListener> list = this.connectionEventListeners;
            synchronized (list) {
                ArrayList<LDAPClientContextEventListener> listeners = new ArrayList<LDAPClientContextEventListener>(this.connectionEventListeners);
                this.connectionEventListeners.clear();
                return listeners;
            }
        }

        @Override
        public boolean isClosed() {
            return this.isClosed;
        }

        @Override
        public Completable sendUnsolicitedNotification(ExtendedResult notification) {
            final PromiseImpl promise = PromiseImpl.create();
            this.connection.write(LdapMessages.newResponseMessage((byte)120, 0, notification), new EmptyCompletionHandler(){

                @Override
                public void cancelled() {
                    promise.handleException(new CancellationException());
                }

                @Override
                public void failed(Throwable throwable) {
                    if (throwable instanceof Exception) {
                        promise.handleException((Exception)throwable);
                    } else {
                        promise.handleException(new Exception(throwable));
                    }
                }

                @Override
                public void completed(Object result) {
                    promise.handleResult(Boolean.TRUE);
                }
            });
            return RxJavaStreams.newCompletable(new Completable.Emitter(){

                @Override
                public void subscribe(final Completable.Subscriber s) throws Exception {
                    promise.thenOnResult(new ResultHandler<Boolean>(){

                        @Override
                        public void handleResult(Boolean result) {
                            s.onComplete();
                        }
                    }).thenOnException(new ExceptionHandler<Exception>(){

                        @Override
                        public void handleException(Exception exception) {
                            s.onError(exception);
                        }
                    }).thenOnRuntimeException(new RuntimeExceptionHandler(){

                        @Override
                        public void handleRuntimeException(RuntimeException exception) {
                            s.onError(exception);
                        }
                    });
                }
            });
        }

        final class GrizzlyBackpressureSubscription
        implements Subscription {
            private final AtomicLong pendingRequests = new AtomicLong();
            private final Subscriber<? super LdapMessages.LdapRequestEnvelope> subscriber;
            private FilterChainContext suspendedCtx;

            GrizzlyBackpressureSubscription(Subscriber<? super LdapMessages.LdapRequestEnvelope> subscriber) {
                this.subscriber = subscriber;
                subscriber.onSubscribe(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            NextAction handleRead(FilterChainContext ctx) {
                if (this.pendingRequests.get() == 1L) {
                    this.subscriber.onNext((LdapMessages.LdapRequestEnvelope)ctx.getMessage());
                    GrizzlyBackpressureSubscription grizzlyBackpressureSubscription = this;
                    synchronized (grizzlyBackpressureSubscription) {
                        if (this.pendingRequests.compareAndSet(1L, 0L)) {
                            ctx.suspend();
                            this.suspendedCtx = ctx;
                            return ctx.getSuspendAction();
                        }
                    }
                    return ctx.getStopAction();
                }
                if (BackpressureHelper.producedCancel(this.pendingRequests, 1L) == Long.MIN_VALUE) {
                    ctx.suspend();
                    return ctx.getSuspendAction();
                }
                this.subscriber.onNext((LdapMessages.LdapRequestEnvelope)ctx.getMessage());
                return ctx.getStopAction();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void request(long n) {
                if (BackpressureHelper.addCancel(this.pendingRequests, n) == 0L) {
                    GrizzlyBackpressureSubscription grizzlyBackpressureSubscription = this;
                    synchronized (grizzlyBackpressureSubscription) {
                        if (this.suspendedCtx != null) {
                            this.suspendedCtx.resume();
                            this.suspendedCtx = null;
                        }
                    }
                }
            }

            public void onError(Throwable error) {
                if (this.pendingRequests.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                    this.subscriber.onError(error);
                }
            }

            public void onComplete() {
                if (this.pendingRequests.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                    this.subscriber.onComplete();
                }
            }

            @Override
            public void cancel() {
                this.pendingRequests.set(Long.MIN_VALUE);
            }
        }
    }
}

