/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.ASN1BufferReader;
import org.forgerock.opendj.grizzly.ASN1BufferWriter;
import org.forgerock.opendj.grizzly.SaslFilter;
import org.forgerock.opendj.grizzly.StartTLSFilter;
import org.forgerock.opendj.io.LDAP;
import org.forgerock.opendj.io.LDAPReader;
import org.forgerock.opendj.io.LDAPWriter;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.util.Options;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainEnabledTransport;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.memory.BuffersBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.ssl.SSLFilter;

final class GrizzlyUtils {
    private static final ThreadCache.CachedTypeIndex<LDAPWriter> WRITER_INDEX = ThreadCache.obtainIndex(LDAPWriter.class, 1);
    private static final ThreadCache.CachedTypeIndex<LDAPWriter> WRITER_INDEX_V2 = ThreadCache.obtainIndex(LDAPWriter.class.getName() + ".ldapV2", LDAPWriter.class, 1);

    static FilterChain buildFilterChain(Processor<?> processor, Filter ... filters) {
        if (processor instanceof FilterChain) {
            return FilterChainBuilder.stateless().addAll((FilterChain)processor).addAll(filters).build();
        }
        if (processor instanceof FilterChainEnabledTransport) {
            return FilterChainBuilder.stateless().add(((FilterChainEnabledTransport)((Object)processor)).getTransportFilter()).addAll(filters).build();
        }
        return FilterChainBuilder.stateless().add(new TransportFilter()).addAll(filters).build();
    }

    static void addFilterToConnection(Filter filter, Connection<?> connection) {
        FilterChain currentChain = (FilterChain)connection.getProcessor();
        FilterChain newChain = GrizzlyUtils.addFilterToChain(filter, currentChain);
        connection.setProcessor(newChain);
    }

    static FilterChain addFilterToChain(Filter filter, FilterChain chain) {
        if (filter instanceof SSLFilter || filter instanceof StartTLSFilter) {
            return FilterChainBuilder.stateless().addAll(chain).add(1, filter).build();
        }
        if (filter instanceof SaslFilter) {
            int pos = chain.get(1) instanceof SSLFilter || chain.get(1) instanceof StartTLSFilter ? 2 : 1;
            return FilterChainBuilder.stateless().addAll(chain).add(pos, filter).build();
        }
        return FilterChainBuilder.stateless().addAll(chain).add(chain.size() - 1, filter).build();
    }

    static LDAPReader<ASN1BufferReader> createReader(DecodeOptions decodeOptions, int maxASN1ElementSize, MemoryManager<?> memoryManager) {
        ASN1BufferReader asn1Reader = new ASN1BufferReader(maxASN1ElementSize, BuffersBuffer.create(memoryManager));
        return LDAP.getReader(asn1Reader, decodeOptions);
    }

    static LDAPWriter<ASN1BufferWriter> getWriter(MemoryManager memoryManager, int protocolVersion) {
        LDAPWriter<ASN1BufferWriter> writer;
        LDAPWriter<ASN1BufferWriter> lDAPWriter = writer = protocolVersion >= 3 ? ThreadCache.takeFromCache(WRITER_INDEX) : ThreadCache.takeFromCache(WRITER_INDEX_V2);
        if (writer == null) {
            writer = LDAP.getWriter(new ASN1BufferWriter(), protocolVersion);
        }
        ((ASN1BufferWriter)writer.getASN1Writer()).reset(memoryManager);
        return writer;
    }

    static void recycleWriter(LDAPWriter<ASN1BufferWriter> writer) {
        writer.getASN1Writer().recycle();
        ThreadCache.putToCache(writer.getProtocolVersion() >= 3 ? WRITER_INDEX : WRITER_INDEX_V2, writer);
    }

    static void configureConnection(Connection<?> connection, LocalizedLogger logger, Options options) {
        connection.configureBlocking(false);
        SocketChannel channel = (SocketChannel)((TCPNIOConnection)connection).getChannel();
        Socket socket = channel.socket();
        boolean tcpNoDelay = (Boolean)options.get(LDAPConnectionFactory.TCP_NO_DELAY);
        boolean keepAlive = (Boolean)options.get(LDAPConnectionFactory.SO_KEEPALIVE);
        boolean reuseAddress = (Boolean)options.get(LDAPConnectionFactory.SO_REUSE_ADDRESS);
        int linger = (Integer)options.get(LDAPConnectionFactory.SO_LINGER_IN_SECONDS);
        try {
            socket.setTcpNoDelay(tcpNoDelay);
        }
        catch (SocketException e) {
            logger.traceException((Throwable)e, "Unable to set TCP_NODELAY to %d on client connection", (Object)tcpNoDelay);
        }
        try {
            socket.setKeepAlive(keepAlive);
        }
        catch (SocketException e) {
            logger.traceException((Throwable)e, "Unable to set SO_KEEPALIVE to %d on client connection", (Object)keepAlive);
        }
        try {
            socket.setReuseAddress(reuseAddress);
        }
        catch (SocketException e) {
            logger.traceException((Throwable)e, "Unable to set SO_REUSEADDR to %d on client connection", (Object)reuseAddress);
        }
        try {
            if (linger < 0) {
                socket.setSoLinger(false, 0);
            } else {
                socket.setSoLinger(true, linger);
            }
        }
        catch (SocketException e) {
            logger.traceException((Throwable)e, "Unable to set SO_LINGER to %d on client connection", (Object)linger);
        }
    }

    static long getLongProperty(String name, long defaultValue) {
        String value = System.getProperty(name);
        try {
            return value != null ? Long.parseLong(value) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private GrizzlyUtils() {
    }
}

