/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.util.ReferenceCountedObject;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.glassfish.grizzly.memory.PooledMemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

final class DefaultTCPNIOTransport
extends ReferenceCountedObject<TCPNIOTransport> {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    static final DefaultTCPNIOTransport DEFAULT_TRANSPORT = new DefaultTCPNIOTransport();

    private DefaultTCPNIOTransport() {
    }

    @Override
    protected void destroyInstance(TCPNIOTransport instance) {
        try {
            instance.shutdownNow();
        }
        catch (IOException e) {
            logger.warn(LocalizableMessage.raw("An error occurred while shutting down the Grizzly transport", e));
        }
    }

    @Override
    protected TCPNIOTransport newInstance() {
        String reuseAddressStr;
        String tcpNoDelayStr;
        String lingerStr;
        TCPNIOTransportBuilder builder = TCPNIOTransportBuilder.newInstance();
        String useWorkerThreadsStr = System.getProperty("org.forgerock.opendj.transport.useWorkerThreads");
        boolean useWorkerThreadStrategy = useWorkerThreadsStr != null ? Boolean.parseBoolean(useWorkerThreadsStr) : true;
        if (useWorkerThreadStrategy) {
            builder.setIOStrategy(WorkerThreadIOStrategy.getInstance());
        } else {
            builder.setIOStrategy(SameThreadIOStrategy.getInstance());
        }
        int cpus = Runtime.getRuntime().availableProcessors();
        String selectorsStr = System.getProperty("org.forgerock.opendj.transport.selectors");
        int selectorThreadCount = selectorsStr != null ? Integer.parseInt(selectorsStr) : (useWorkerThreadStrategy ? Math.max(2, cpus / 4) : Math.max(5, cpus / 2 - 1));
        builder.setSelectorThreadPoolConfig(ThreadPoolConfig.defaultConfig().setCorePoolSize(selectorThreadCount).setMaxPoolSize(selectorThreadCount).setPoolName("OpenDJ LDAP SDK Grizzly selector thread"));
        if (builder.getWorkerThreadPoolConfig() != null) {
            String workersStr = System.getProperty("org.forgerock.opendj.transport.workers");
            int workerThreadCount = workersStr != null ? Integer.parseInt(workersStr) : (useWorkerThreadStrategy ? Math.max(5, cpus * 2) : 0);
            builder.setWorkerThreadPoolConfig(ThreadPoolConfig.defaultConfig().setCorePoolSize(workerThreadCount).setMaxPoolSize(workerThreadCount).setPoolName("OpenDJ LDAP SDK Grizzly worker thread"));
        }
        if ((lingerStr = System.getProperty("org.forgerock.opendj.transport.linger")) != null) {
            builder.setLinger(Integer.parseInt(lingerStr));
        }
        if ((tcpNoDelayStr = System.getProperty("org.forgerock.opendj.transport.tcpNoDelay")) != null) {
            builder.setTcpNoDelay(Boolean.parseBoolean(tcpNoDelayStr));
        }
        if ((reuseAddressStr = System.getProperty("org.forgerock.opendj.transport.reuseAddress")) != null) {
            builder.setReuseAddress(Boolean.parseBoolean(reuseAddressStr));
        }
        builder.setMemoryManager(new PooledMemoryManager(true));
        TCPNIOTransport transport = builder.build();
        transport.setSelectorRunnersCount(selectorThreadCount);
        try {
            transport.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return transport;
    }
}

