/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import org.forgerock.opendj.ldap.ConnectionSecurityLayer;
import org.forgerock.opendj.ldap.LdapException;
import org.glassfish.grizzly.AbstractTransformer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.AbstractCodecFilter;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

final class ConnectionSecurityLayerFilter
extends AbstractCodecFilter<Buffer, Buffer> {
    ConnectionSecurityLayerFilter(ConnectionSecurityLayer layer, MemoryManager<?> memoryManager) {
        super(new Decoder(layer, memoryManager), new Encoder(layer, memoryManager));
    }

    private static final class Encoder
    extends AbstractTransformer<Buffer, Buffer> {
        private static final int BUFFER_SIZE = 4096;
        private final byte[] buffer = new byte[4096];
        private final ConnectionSecurityLayer layer;

        private Encoder(ConnectionSecurityLayer layer, MemoryManager<?> memoryManager) {
            this.layer = layer;
            this.setMemoryManager(memoryManager);
        }

        @Override
        public String getName() {
            return this.getClass().getName();
        }

        @Override
        public boolean hasInputRemaining(AttributeStorage storage, Buffer input) {
            return input != null && input.hasRemaining();
        }

        @Override
        public TransformationResult<Buffer, Buffer> transformImpl(AttributeStorage storage, Buffer input) {
            MemoryManager memoryManager = this.obtainMemoryManager(storage);
            int len = Math.min(this.buffer.length, input.remaining());
            input.get(this.buffer, 0, len);
            try {
                Buffer output = Buffers.wrap(memoryManager, this.layer.wrap(this.buffer, 0, len));
                return TransformationResult.createCompletedResult(output, input);
            }
            catch (LdapException e) {
                return TransformationResult.createErrorResult(e.getResult().getResultCode().intValue(), e.getMessage());
            }
        }
    }

    private static final class Decoder
    extends AbstractTransformer<Buffer, Buffer> {
        private static final int BUFFER_SIZE = 4096;
        private final byte[] buffer = new byte[4096];
        private final ConnectionSecurityLayer layer;

        public Decoder(ConnectionSecurityLayer layer, MemoryManager<?> memoryManager) {
            this.layer = layer;
            this.setMemoryManager(memoryManager);
        }

        @Override
        public String getName() {
            return this.getClass().getName();
        }

        @Override
        public boolean hasInputRemaining(AttributeStorage storage, Buffer input) {
            return input != null && input.hasRemaining();
        }

        @Override
        public TransformationResult<Buffer, Buffer> transformImpl(AttributeStorage storage, Buffer input) {
            MemoryManager memoryManager = this.obtainMemoryManager(storage);
            int len = Math.min(this.buffer.length, input.remaining());
            input.get(this.buffer, 0, len);
            try {
                Buffer output = Buffers.wrap(memoryManager, this.layer.unwrap(this.buffer, 0, len));
                return TransformationResult.createCompletedResult(output, input);
            }
            catch (LdapException e) {
                return TransformationResult.createErrorResult(e.getResult().getResultCode().intValue(), e.getMessage());
            }
        }
    }
}

