/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.io.AbstractASN1Writer;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.memory.MemoryManager;

final class ASN1BufferWriter
extends AbstractASN1Writer
implements Cacheable {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final int BUFFER_INIT_SIZE = 1024;
    private static final int DEFAULT_MAX_INTERNAL_BUFFER_SIZE = 32768;
    private MemoryManager<Buffer> memoryManager;
    private SequenceBuffer sequenceBuffer;
    private Buffer outBuffer;
    private final RootSequenceBuffer rootBuffer = new RootSequenceBuffer();

    ASN1BufferWriter() {
    }

    void reset(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
        this.sequenceBuffer = this.rootBuffer;
        this.outBuffer = memoryManager.allocate(1024);
    }

    void ensureAdditionalCapacity(int size) {
        int newCount = this.outBuffer.position() + size;
        if (newCount > this.outBuffer.limit()) {
            this.outBuffer = this.memoryManager.reallocate(this.outBuffer, Math.max(this.outBuffer.limit() << 1, newCount));
        }
    }

    @Override
    public void close() throws IOException {
        this.outBuffer = null;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void recycle() {
        this.memoryManager = null;
        this.sequenceBuffer = null;
        this.outBuffer = null;
    }

    @Override
    public ASN1Writer writeBoolean(byte type, boolean booleanValue) throws IOException {
        this.sequenceBuffer.writeByte(type);
        this.writeLength(this.sequenceBuffer, 1);
        this.sequenceBuffer.writeByte(booleanValue ? (byte)-1 : 0);
        if (logger.isTraceEnabled()) {
            logger.trace("WRITE ASN.1 BOOLEAN(type=0x%x, length=%d, value=%s)", (Object)type, (Object)1, (Object)booleanValue);
        }
        return this;
    }

    @Override
    public ASN1Writer writeEndSequence() throws IOException {
        this.sequenceBuffer = this.sequenceBuffer.endSequence();
        return this;
    }

    @Override
    public ASN1Writer writeEndSet() throws IOException {
        return this.writeEndSequence();
    }

    @Override
    public ASN1Writer writeEnumerated(byte type, int intValue) throws IOException {
        return this.writeInteger(type, intValue);
    }

    @Override
    public ASN1Writer writeInteger(byte type, int intValue) throws IOException {
        this.sequenceBuffer.writeByte(type);
        if (intValue < 0 && (intValue & 0xFFFFFF80) == -128 || (intValue & 0x7F) == intValue) {
            this.writeLength(this.sequenceBuffer, 1);
            this.sequenceBuffer.writeByte((byte)intValue);
            if (logger.isTraceEnabled()) {
                logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)1, (Object)intValue);
            }
        } else if (intValue < 0 && (intValue & Short.MIN_VALUE) == Short.MIN_VALUE || (intValue & Short.MAX_VALUE) == intValue) {
            this.writeLength(this.sequenceBuffer, 2);
            this.sequenceBuffer.writeByte((byte)(intValue >> 8));
            this.sequenceBuffer.writeByte((byte)intValue);
            if (logger.isTraceEnabled()) {
                logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)2, (Object)intValue);
            }
        } else if (intValue < 0 && (intValue & 0xFF800000) == -8388608 || (intValue & 0x7FFFFF) == intValue) {
            this.writeLength(this.sequenceBuffer, 3);
            this.sequenceBuffer.writeByte((byte)(intValue >> 16));
            this.sequenceBuffer.writeByte((byte)(intValue >> 8));
            this.sequenceBuffer.writeByte((byte)intValue);
            if (logger.isTraceEnabled()) {
                logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)3, (Object)intValue);
            }
        } else {
            this.writeLength(this.sequenceBuffer, 4);
            this.sequenceBuffer.writeByte((byte)(intValue >> 24));
            this.sequenceBuffer.writeByte((byte)(intValue >> 16));
            this.sequenceBuffer.writeByte((byte)(intValue >> 8));
            this.sequenceBuffer.writeByte((byte)intValue);
            if (logger.isTraceEnabled()) {
                logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)4, (Object)intValue);
            }
        }
        return this;
    }

    @Override
    public ASN1Writer writeInteger(byte type, long longValue) throws IOException {
        this.sequenceBuffer.writeByte(type);
        if (longValue < 0L && (longValue & 0xFFFFFFFFFFFFFF80L) == -128L || (longValue & 0x7FL) == longValue) {
            this.writeLength(this.sequenceBuffer, 1);
            this.sequenceBuffer.writeByte((byte)longValue);
            if (logger.isTraceEnabled()) {
                logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)1, (Object)longValue);
            }
        } else if (longValue < 0L && (longValue & 0xFFFFFFFFFFFF8000L) == -32768L || (longValue & 0x7FFFL) == longValue) {
            this.writeLength(this.sequenceBuffer, 2);
            this.sequenceBuffer.writeByte((byte)(longValue >> 8));
            this.sequenceBuffer.writeByte((byte)longValue);
            if (logger.isTraceEnabled()) {
                logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)2, (Object)longValue);
            }
        } else if (longValue < 0L && (longValue & 0xFFFFFFFFFF800000L) == -8388608L || (longValue & 0x7FFFFFL) == longValue) {
            this.writeLength(this.sequenceBuffer, 3);
            this.sequenceBuffer.writeByte((byte)(longValue >> 16));
            this.sequenceBuffer.writeByte((byte)(longValue >> 8));
            this.sequenceBuffer.writeByte((byte)longValue);
            if (logger.isTraceEnabled()) {
                logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)3, (Object)longValue);
            }
        } else if (longValue < 0L && (longValue & Integer.MIN_VALUE) == Integer.MIN_VALUE || (longValue & Integer.MAX_VALUE) == longValue) {
            this.writeLength(this.sequenceBuffer, 4);
            this.sequenceBuffer.writeByte((byte)(longValue >> 24));
            this.sequenceBuffer.writeByte((byte)(longValue >> 16));
            this.sequenceBuffer.writeByte((byte)(longValue >> 8));
            this.sequenceBuffer.writeByte((byte)longValue);
            if (logger.isTraceEnabled()) {
                logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)4, (Object)longValue);
            }
        } else if (longValue < 0L && (longValue & 0xFFFFFF8000000000L) == -549755813888L || (longValue & 0x7FFFFFFFFFL) == longValue) {
            this.writeLength(this.sequenceBuffer, 5);
            this.sequenceBuffer.writeByte((byte)(longValue >> 32));
            this.sequenceBuffer.writeByte((byte)(longValue >> 24));
            this.sequenceBuffer.writeByte((byte)(longValue >> 16));
            this.sequenceBuffer.writeByte((byte)(longValue >> 8));
            this.sequenceBuffer.writeByte((byte)longValue);
            if (logger.isTraceEnabled()) {
                logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)5, (Object)longValue);
            }
        } else if (longValue < 0L && (longValue & 0xFFFF800000000000L) == -140737488355328L || (longValue & 0x7FFFFFFFFFFFL) == longValue) {
            this.writeLength(this.sequenceBuffer, 6);
            this.sequenceBuffer.writeByte((byte)(longValue >> 40));
            this.sequenceBuffer.writeByte((byte)(longValue >> 32));
            this.sequenceBuffer.writeByte((byte)(longValue >> 24));
            this.sequenceBuffer.writeByte((byte)(longValue >> 16));
            this.sequenceBuffer.writeByte((byte)(longValue >> 8));
            this.sequenceBuffer.writeByte((byte)longValue);
            if (logger.isTraceEnabled()) {
                logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)6, (Object)longValue);
            }
        } else if (longValue < 0L && (longValue & 0xFF80000000000000L) == -36028797018963968L || (longValue & 0x7FFFFFFFFFFFFFL) == longValue) {
            this.writeLength(this.sequenceBuffer, 7);
            this.sequenceBuffer.writeByte((byte)(longValue >> 48));
            this.sequenceBuffer.writeByte((byte)(longValue >> 40));
            this.sequenceBuffer.writeByte((byte)(longValue >> 32));
            this.sequenceBuffer.writeByte((byte)(longValue >> 24));
            this.sequenceBuffer.writeByte((byte)(longValue >> 16));
            this.sequenceBuffer.writeByte((byte)(longValue >> 8));
            this.sequenceBuffer.writeByte((byte)longValue);
            if (logger.isTraceEnabled()) {
                logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)7, (Object)longValue);
            }
        } else {
            this.writeLength(this.sequenceBuffer, 8);
            this.sequenceBuffer.writeByte((byte)(longValue >> 56));
            this.sequenceBuffer.writeByte((byte)(longValue >> 48));
            this.sequenceBuffer.writeByte((byte)(longValue >> 40));
            this.sequenceBuffer.writeByte((byte)(longValue >> 32));
            this.sequenceBuffer.writeByte((byte)(longValue >> 24));
            this.sequenceBuffer.writeByte((byte)(longValue >> 16));
            this.sequenceBuffer.writeByte((byte)(longValue >> 8));
            this.sequenceBuffer.writeByte((byte)longValue);
            if (logger.isTraceEnabled()) {
                logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)8, (Object)longValue);
            }
        }
        return this;
    }

    @Override
    public ASN1Writer writeNull(byte type) throws IOException {
        this.sequenceBuffer.writeByte(type);
        this.writeLength(this.sequenceBuffer, 0);
        if (logger.isTraceEnabled()) {
            logger.trace("WRITE ASN.1 NULL(type=0x%x, length=%d)", (Object)type, (Object)0);
        }
        return this;
    }

    @Override
    public ASN1Writer writeOctetString(byte type, byte[] value, int offset, int length) throws IOException {
        this.sequenceBuffer.writeByte(type);
        this.writeLength(this.sequenceBuffer, length);
        this.sequenceBuffer.writeByteArray(value, offset, length);
        if (logger.isTraceEnabled()) {
            logger.trace("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d)", (Object)type, (Object)length);
        }
        return this;
    }

    @Override
    public ASN1Writer writeOctetString(byte type, ByteSequence value) throws IOException {
        this.sequenceBuffer.writeByte(type);
        this.writeLength(this.sequenceBuffer, value.length());
        this.sequenceBuffer.writeByteSequence(value);
        if (logger.isTraceEnabled()) {
            logger.trace("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d)", (Object)type, (Object)value.length());
        }
        return this;
    }

    @Override
    public ASN1Writer writeOctetString(byte type, String value) throws IOException {
        this.sequenceBuffer.writeByte(type);
        if (value == null) {
            this.writeLength(this.sequenceBuffer, 0);
            return this;
        }
        byte[] bytes = StaticUtils.getBytes(value);
        this.writeLength(this.sequenceBuffer, bytes.length);
        this.sequenceBuffer.writeByteArray(bytes, 0, bytes.length);
        if (logger.isTraceEnabled()) {
            logger.trace("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d, value=%s)", (Object)type, (Object)bytes.length, (Object)value);
        }
        return this;
    }

    @Override
    public ASN1Writer writeStartSequence(byte type) throws IOException {
        this.sequenceBuffer = this.sequenceBuffer.startSequence(type);
        if (logger.isTraceEnabled()) {
            logger.trace("WRITE ASN.1 START SEQUENCE(type=0x%x)", (Object)type);
        }
        return this;
    }

    @Override
    public ASN1Writer writeStartSet(byte type) throws IOException {
        return this.writeStartSequence(type);
    }

    public Buffer getBuffer() {
        this.outBuffer.allowBufferDispose(true);
        return this.outBuffer.flip();
    }

    private void writeLength(SequenceBuffer buffer, int length) throws IOException {
        if (length < 128) {
            buffer.writeByte((byte)length);
        } else if ((length & 0xFF) == length) {
            buffer.writeByte((byte)-127);
            buffer.writeByte((byte)length);
        } else if ((length & 0xFFFF) == length) {
            buffer.writeByte((byte)-126);
            buffer.writeByte((byte)(length >> 8));
            buffer.writeByte((byte)length);
        } else if ((length & 0xFFFFFF) == length) {
            buffer.writeByte((byte)-125);
            buffer.writeByte((byte)(length >> 16));
            buffer.writeByte((byte)(length >> 8));
            buffer.writeByte((byte)length);
        } else {
            buffer.writeByte((byte)-124);
            buffer.writeByte((byte)(length >> 24));
            buffer.writeByte((byte)(length >> 16));
            buffer.writeByte((byte)(length >> 8));
            buffer.writeByte((byte)length);
        }
    }

    private static interface SequenceBuffer {
        public SequenceBuffer endSequence() throws IOException;

        public SequenceBuffer startSequence(byte var1) throws IOException;

        public void writeByte(byte var1) throws IOException;

        public void writeByteSequence(ByteSequence var1) throws IOException;

        public void writeByteArray(byte[] var1, int var2, int var3) throws IOException;
    }

    private class RootSequenceBuffer
    implements SequenceBuffer {
        private ChildSequenceBuffer child;

        private RootSequenceBuffer() {
        }

        @Override
        public SequenceBuffer endSequence() throws IOException {
            LocalizableMessage message = CoreMessages.ERR_ASN1_SEQUENCE_WRITE_NOT_STARTED.get();
            throw new IllegalStateException(message.toString());
        }

        @Override
        public SequenceBuffer startSequence(byte type) throws IOException {
            if (this.child == null) {
                this.child = new ChildSequenceBuffer();
                this.child.parent = this;
            }
            ASN1BufferWriter.this.ensureAdditionalCapacity(1);
            ASN1BufferWriter.this.outBuffer.put(type);
            this.child.buffer.clear();
            return this.child;
        }

        @Override
        public void writeByte(byte b) throws IOException {
            ASN1BufferWriter.this.ensureAdditionalCapacity(1);
            ASN1BufferWriter.this.outBuffer.put(b);
        }

        @Override
        public void writeByteSequence(ByteSequence bs) {
            ASN1BufferWriter.this.ensureAdditionalCapacity(bs.length());
            bs.copyTo(ASN1BufferWriter.this.outBuffer.toByteBuffer());
            ASN1BufferWriter.this.outBuffer.position(ASN1BufferWriter.this.outBuffer.position() + bs.length());
        }

        @Override
        public void writeByteArray(byte[] bs, int offset, int length) throws IOException {
            ASN1BufferWriter.this.ensureAdditionalCapacity(length);
            ASN1BufferWriter.this.outBuffer.put(bs, offset, length);
        }
    }

    private class ChildSequenceBuffer
    implements SequenceBuffer {
        private SequenceBuffer parent;
        private ChildSequenceBuffer child;
        private final ByteStringBuilder buffer = new ByteStringBuilder(1024);

        private ChildSequenceBuffer() {
        }

        @Override
        public SequenceBuffer endSequence() throws IOException {
            ASN1BufferWriter.this.writeLength(this.parent, this.buffer.length());
            this.parent.writeByteArray(this.buffer.getBackingArray(), 0, this.buffer.length());
            this.buffer.clearAndTruncate(32768, 1024);
            if (logger.isTraceEnabled()) {
                logger.trace("WRITE ASN.1 END SEQUENCE(length=%d)", (Object)this.buffer.length());
            }
            return this.parent;
        }

        @Override
        public SequenceBuffer startSequence(byte type) throws IOException {
            if (this.child == null) {
                this.child = new ChildSequenceBuffer();
                this.child.parent = this;
            }
            this.buffer.appendByte(type);
            this.child.buffer.clear();
            return this.child;
        }

        @Override
        public void writeByte(byte b) throws IOException {
            this.buffer.appendByte(b);
        }

        @Override
        public void writeByteSequence(ByteSequence bs) {
            this.buffer.appendBytes(bs);
        }

        @Override
        public void writeByteArray(byte[] bs, int offset, int length) throws IOException {
            this.buffer.appendBytes(bs, offset, length);
        }
    }
}

