/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.AbstractASN1Reader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.glassfish.grizzly.Buffer;

final class ASN1BufferReader
extends AbstractASN1Reader {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private int markState;
    private SequenceLimiter markReadLimiter;
    private int state = 0;
    private byte peekType;
    private int peekLength = -1;
    private int lengthBytesNeeded;
    private final int maxElementSize;
    private final Buffer buffer;
    private SequenceLimiter readLimiter = new RootSequenceLimiter();

    ASN1BufferReader(int maxElementSize, Buffer buffer) {
        this.buffer = buffer;
        this.maxElementSize = maxElementSize;
    }

    @Override
    public void close() throws IOException {
        this.buffer.tryDispose();
    }

    @Override
    public boolean elementAvailable() throws IOException {
        return !(this.state == 0 && !this.needTypeState(true) || this.state == 1 && !this.needFirstLengthByteState(true) || this.state == 2 && !this.needAdditionalLengthBytesState(true) || this.peekLength > this.readLimiter.remaining());
    }

    @Override
    public boolean hasNextElement() throws IOException {
        return this.state != 0 || this.needTypeState(true);
    }

    @Override
    public int peekLength() throws IOException {
        this.peekType();
        switch (this.state) {
            case 1: {
                this.needFirstLengthByteState(false);
                break;
            }
            case 2: {
                this.needAdditionalLengthBytesState(false);
            }
        }
        return this.peekLength;
    }

    @Override
    public byte peekType() throws IOException {
        if (this.state == 0) {
            this.needTypeState(false);
        }
        return this.peekType;
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.peekLength();
        if (this.peekLength != 1) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_BOOLEAN_INVALID_LENGTH.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        this.readLimiter.checkLimit(this.peekLength);
        byte readByte = this.buffer.get();
        logger.trace("READ ASN.1 BOOLEAN(type=0x%x, length=%d, value=%s)", (Object)this.peekType, (Object)this.peekLength, (Object)(readByte != 0 ? 1 : 0));
        this.state = 0;
        return readByte != 0;
    }

    @Override
    public void readEndSequence() throws IOException {
        this.readLimiter = this.readLimiter.endSequence();
        logger.trace("READ ASN.1 END SEQUENCE");
        this.state = 0;
    }

    @Override
    public void readEndExplicitTag() throws DecodeException, IOException {
        this.readEndSequence();
    }

    @Override
    public void readEndSet() throws IOException {
        this.readEndSequence();
    }

    @Override
    public int readEnumerated() throws IOException {
        this.peekLength();
        if (this.peekLength < 1 || this.peekLength > 4) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_INTEGER_INVALID_LENGTH.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        return (int)this.readInteger();
    }

    @Override
    public long readInteger() throws IOException {
        this.peekLength();
        if (this.peekLength < 1 || this.peekLength > 8) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_INTEGER_INVALID_LENGTH.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        this.readLimiter.checkLimit(this.peekLength);
        if (this.peekLength > 4) {
            long longValue = 0L;
            for (int i = 0; i < this.peekLength; ++i) {
                byte readByte = this.buffer.get();
                if (i == 0 && (byte)readByte < 0) {
                    longValue = -1L;
                }
                longValue = longValue << 8 | (long)(readByte & 0xFF);
            }
            this.state = 0;
            return longValue;
        }
        int intValue = 0;
        for (int i = 0; i < this.peekLength; ++i) {
            byte readByte = this.buffer.get();
            if (i == 0 && (byte)readByte < 0) {
                intValue = -1;
            }
            intValue = intValue << 8 | readByte & 0xFF;
        }
        logger.trace("READ ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)this.peekType, (Object)this.peekLength, (Object)intValue);
        this.state = 0;
        return intValue;
    }

    @Override
    public void readNull() throws IOException {
        this.peekLength();
        if (this.peekLength != 0) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_NULL_INVALID_LENGTH.get(this.peekLength);
            throw DecodeException.fatalError(message);
        }
        logger.trace("READ ASN.1 NULL(type=0x%x, length=%d)", (Object)this.peekType, (Object)this.peekLength);
        this.state = 0;
    }

    @Override
    public ByteString readOctetString() throws IOException {
        this.peekLength();
        if (this.peekLength == 0) {
            this.state = 0;
            return ByteString.empty();
        }
        this.readLimiter.checkLimit(this.peekLength);
        byte[] value = new byte[this.peekLength];
        this.buffer.get(value);
        logger.trace("READ ASN.1 OCTETSTRING(type=0x%x, length=%d)", (Object)this.peekType, (Object)this.peekLength);
        this.state = 0;
        return ByteString.wrap(value);
    }

    @Override
    public ByteStringBuilder readOctetString(ByteStringBuilder builder) throws IOException {
        this.peekLength();
        if (this.peekLength == 0) {
            this.state = 0;
            return builder;
        }
        this.readLimiter.checkLimit(this.peekLength);
        for (int i = 0; i < this.peekLength; ++i) {
            builder.appendByte(this.buffer.get());
        }
        logger.trace("READ ASN.1 OCTETSTRING(type=0x%x, length=%d)", (Object)this.peekType, (Object)this.peekLength);
        this.state = 0;
        return builder;
    }

    @Override
    public String readOctetStringAsString() throws IOException {
        String str;
        this.peekLength();
        if (this.peekLength == 0) {
            this.state = 0;
            return "";
        }
        this.readLimiter.checkLimit(this.peekLength);
        this.state = 0;
        try {
            str = this.buffer.toStringContent(StandardCharsets.UTF_8, this.buffer.position(), this.buffer.position() + this.peekLength);
        }
        catch (Exception e) {
            logger.warn(LocalizableMessage.raw("Unable to decode ASN.1 OCTETSTRING bytes as UTF-8 string: %s", e));
            str = this.buffer.toStringContent(Charset.defaultCharset(), this.buffer.position(), this.buffer.position() + this.peekLength);
        }
        finally {
            this.buffer.position(this.buffer.position() + this.peekLength);
        }
        logger.trace("READ ASN.1 OCTETSTRING(type=0x%x, length=%d, value=%s)", (Object)this.peekType, (Object)this.peekLength, (Object)str);
        return str;
    }

    @Override
    public void readStartSequence() throws IOException {
        this.peekLength();
        this.readLimiter = this.readLimiter.startSequence(this.peekLength);
        logger.trace("READ ASN.1 START SEQUENCE(type=0x%x, length=%d)", (Object)this.peekType, (Object)this.peekLength);
        this.state = 0;
    }

    @Override
    public void readStartExplicitTag() throws DecodeException, IOException {
        this.readStartSequence();
    }

    @Override
    public void readStartSet() throws IOException {
        this.readStartSequence();
    }

    @Override
    public ASN1Reader skipElement() throws IOException {
        this.peekLength();
        this.readLimiter.checkLimit(this.peekLength);
        for (int i = 0; i < this.peekLength; ++i) {
            this.buffer.get();
        }
        this.state = 0;
        return this;
    }

    void mark() {
        this.buffer.mark();
        this.markState = this.state;
        this.markReadLimiter = this.readLimiter;
    }

    void reset() {
        this.buffer.reset();
        this.state = this.markState;
        this.readLimiter = this.markReadLimiter;
    }

    private boolean needAdditionalLengthBytesState(boolean ensureRead) throws IOException {
        if (ensureRead && this.readLimiter.remaining() < this.lengthBytesNeeded) {
            return false;
        }
        this.readLimiter.checkLimit(this.lengthBytesNeeded);
        while (this.lengthBytesNeeded > 0) {
            byte readByte = this.buffer.get();
            this.peekLength = this.peekLength << 8 | readByte & 0xFF;
            --this.lengthBytesNeeded;
        }
        if (this.maxElementSize > 0 && this.peekLength > this.maxElementSize) {
            LocalizableMessage m = CoreMessages.ERR_LDAP_CLIENT_DECODE_MAX_REQUEST_SIZE_EXCEEDED.get(this.peekLength, this.maxElementSize);
            throw DecodeException.fatalError(m);
        }
        this.state = 3;
        return true;
    }

    private boolean needFirstLengthByteState(boolean ensureRead) throws IOException {
        if (ensureRead && this.readLimiter.remaining() <= 0) {
            return false;
        }
        this.readLimiter.checkLimit(1);
        byte readByte = this.buffer.get();
        this.peekLength = readByte & 0x7F;
        if (this.peekLength != readByte) {
            this.lengthBytesNeeded = this.peekLength;
            if (this.lengthBytesNeeded > 4) {
                LocalizableMessage message = CoreMessages.ERR_ASN1_INVALID_NUM_LENGTH_BYTES.get(this.lengthBytesNeeded);
                throw DecodeException.fatalError(message);
            }
            this.peekLength = 0;
            if (ensureRead && this.readLimiter.remaining() < this.lengthBytesNeeded) {
                this.state = 2;
                return false;
            }
            this.readLimiter.checkLimit(this.lengthBytesNeeded);
            while (this.lengthBytesNeeded > 0) {
                readByte = this.buffer.get();
                this.peekLength = this.peekLength << 8 | readByte & 0xFF;
                --this.lengthBytesNeeded;
            }
        }
        if (this.maxElementSize > 0 && this.peekLength > this.maxElementSize) {
            LocalizableMessage m = CoreMessages.ERR_LDAP_CLIENT_DECODE_MAX_REQUEST_SIZE_EXCEEDED.get(this.peekLength, this.maxElementSize);
            throw DecodeException.fatalError(m);
        }
        this.state = 3;
        return true;
    }

    private boolean needTypeState(boolean ensureRead) throws IOException {
        if (ensureRead && this.readLimiter.remaining() <= 0) {
            return false;
        }
        this.readLimiter.checkLimit(1);
        this.peekType = this.buffer.get();
        this.state = 1;
        return true;
    }

    private static interface SequenceLimiter {
        public void checkLimit(int var1) throws IOException;

        public SequenceLimiter endSequence() throws IOException;

        public int remaining();

        public SequenceLimiter startSequence(int var1);
    }

    private final class RootSequenceLimiter
    implements SequenceLimiter {
        private ChildSequenceLimiter child;

        private RootSequenceLimiter() {
        }

        @Override
        public void checkLimit(int readSize) throws IOException {
            if (ASN1BufferReader.this.buffer.remaining() < readSize) {
                LocalizableMessage message = CoreMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTE.get();
                throw DecodeException.fatalError(message);
            }
        }

        @Override
        public ChildSequenceLimiter endSequence() throws DecodeException {
            LocalizableMessage message = CoreMessages.ERR_ASN1_SEQUENCE_READ_NOT_STARTED.get();
            throw new IllegalStateException(message.toString());
        }

        @Override
        public int remaining() {
            return ASN1BufferReader.this.buffer.remaining();
        }

        @Override
        public ChildSequenceLimiter startSequence(int readLimit) {
            if (this.child == null) {
                this.child = new ChildSequenceLimiter();
                this.child.parent = this;
            }
            this.child.readLimit = readLimit;
            this.child.bytesRead = 0;
            return this.child;
        }
    }

    private final class ChildSequenceLimiter
    implements SequenceLimiter {
        private SequenceLimiter parent;
        private ChildSequenceLimiter child;
        private int readLimit;
        private int bytesRead;

        private ChildSequenceLimiter() {
        }

        @Override
        public void checkLimit(int readSize) throws IOException {
            if (0 < this.readLimit && this.readLimit < this.bytesRead + readSize) {
                LocalizableMessage message = CoreMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTE.get();
                throw DecodeException.fatalError(message);
            }
            this.parent.checkLimit(readSize);
            this.bytesRead += readSize;
        }

        @Override
        public SequenceLimiter endSequence() throws IOException {
            this.parent.checkLimit(this.remaining());
            if (this.remaining() > 0) {
                logger.debug(LocalizableMessage.raw("Ignoring %d unused trailing bytes in ASN.1 SEQUENCE", this.remaining()));
            }
            for (int i = 0; i < this.remaining(); ++i) {
                ASN1BufferReader.this.buffer.get();
            }
            return this.parent;
        }

        @Override
        public int remaining() {
            return this.readLimit - this.bytesRead;
        }

        @Override
        public ChildSequenceLimiter startSequence(int readLimit) {
            if (this.child == null) {
                this.child = new ChildSequenceLimiter();
                this.child.parent = this;
            }
            this.child.readLimit = readLimit;
            this.child.bytesRead = 0;
            return this.child;
        }
    }
}

