/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.io.IOException;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.controls.PreReadResponseControl;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldif.LDIFEntryWriter;

public final class UseGenericControl {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 5) {
            System.err.println("Usage: host port username password userDN");
            System.exit(1);
        }
        String hostName = args[0];
        int port = Integer.parseInt(args[1]);
        String userName = args[2];
        String password = args[3];
        String userDN = args[4];
        LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
        LDAPConnectionFactory factory = new LDAPConnectionFactory(hostName, port);
        Connection connection = null;
        ByteStringBuilder builder = new ByteStringBuilder();
        ASN1Writer asn1Writer = ASN1.getWriter(builder);
        try {
            asn1Writer.writeStartSequence();
            asn1Writer.writeOctetString("description");
            asn1Writer.writeEndSequence();
            asn1Writer.flush();
            asn1Writer.close();
        }
        catch (Exception e) {
            System.out.println("Failed to prepare control value: " + e.getCause());
            System.exit(-1);
        }
        try {
            connection = factory.getConnection();
            connection.bind(userName, password.toCharArray());
            ModifyRequest request = Requests.newModifyRequest(userDN).addModification(ModificationType.REPLACE, "description", "A new description").addControl(GenericControl.newControl("1.3.6.1.1.13.1", true, builder.toByteString()));
            Result result = connection.modify(request);
            if (result.isSuccess()) {
                PreReadResponseControl control = result.getControl(PreReadResponseControl.DECODER, new DecodeOptions());
                Entry unmodifiedEntry = control.getEntry();
                writer.writeComment("Before modification");
                writer.writeEntry(unmodifiedEntry);
                writer.flush();
                SearchResultEntry modifiedEntry = connection.searchSingleEntry(userDN, SearchScope.BASE_OBJECT, "(objectclass=*)", "description");
                writer.writeComment("After modification");
                writer.writeEntry(modifiedEntry);
                writer.flush();
            }
        }
        catch (LdapException e) {
            System.err.println(e.getMessage());
            System.exit(e.getResult().getResultCode().intValue());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private UseGenericControl() {
    }
}

