/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.util.Collection;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.RootDSE;
import org.forgerock.opendj.ldap.controls.PermissiveModifyRequestControl;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.CompareResult;

public final class UpdateGroup {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 5) {
            UpdateGroup.printUsage();
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String groupDN = args[2];
        String memberDN = args[3];
        ModificationType modType = UpdateGroup.getModificationType(args[4]);
        LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port);
        try (Connection connection = null;){
            Request request;
            connection = factory.getConnection();
            Collection<String> controls = RootDSE.readRootDSE(connection).getSupportedControls();
            String user = "cn=Directory Manager";
            char[] password = "password".toCharArray();
            connection.bind("cn=Directory Manager", password);
            if (controls.contains("1.2.840.113556.1.4.1413")) {
                request = Requests.newModifyRequest(groupDN).addControl(PermissiveModifyRequestControl.newControl(true)).addModification(modType, "member", memberDN);
                connection.modify((ModifyRequest)request);
            } else {
                System.out.println("Checking whether the entry with DN " + memberDN + " belongs to the group with DN " + groupDN + "...");
                request = Requests.newCompareRequest(groupDN, "member", (Object)memberDN);
                CompareResult result = connection.compare((CompareRequest)request);
                if (modType == ModificationType.ADD && result.getResultCode() == ResultCode.COMPARE_FALSE) {
                    System.out.println("Member does not yet belong to group. Adding it...");
                    ModifyRequest addMember = Requests.newModifyRequest(groupDN).addModification(modType, "member", memberDN);
                    connection.modify(addMember);
                }
                if (modType == ModificationType.DELETE && result.getResultCode() == ResultCode.COMPARE_TRUE) {
                    System.out.println("Member belongs to group. Removing it...");
                    ModifyRequest delMember = Requests.newModifyRequest(groupDN).addModification(modType, "member", memberDN);
                    connection.modify(delMember);
                }
            }
            String op = modType == ModificationType.ADD ? "added to" : "deleted from";
            System.out.println("The entry with DN " + memberDN + " has been " + op + " the group with DN " + groupDN + ".");
        }
    }

    private static ModificationType getModificationType(String operation) {
        boolean isAdd = "add".equalsIgnoreCase(operation);
        if (!isAdd && !"del".equalsIgnoreCase(operation)) {
            UpdateGroup.printUsage();
        }
        return isAdd ? ModificationType.ADD : ModificationType.DELETE;
    }

    private static void printUsage() {
        System.err.println("Usage: host port group-dn member-dn {add|del}");
        System.err.println("For example: localhost 1389 cn=Static,ou=Groups,dc=example,dc=com uid=user.5150,ou=People,dc=example,dc=com del");
        System.exit(1);
    }

    private UpdateGroup() {
    }
}

