/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.util.Options;

public final class SimpleAuth {
    private static String host;
    private static int port;
    private static String bindDN;
    private static String bindPassword;
    private static boolean useStartTLS;
    private static boolean useSSL;
    private static String keystore;
    private static String storepass;

    public static void main(String[] args) {
        SimpleAuth.parseArgs(args);
        if (useStartTLS) {
            SimpleAuth.connectStartTLS();
        } else if (useSSL) {
            SimpleAuth.connectSSL();
        } else {
            SimpleAuth.connect();
        }
    }

    private static void connect() {
        LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port);
        try (Connection connection = null;){
            connection = factory.getConnection();
            connection.bind(bindDN, bindPassword.toCharArray());
            System.out.println("Authenticated as " + bindDN + ".");
        }
    }

    private static Options getTrustOptions(String hostname, String truststore, String storepass) throws GeneralSecurityException {
        Options options = Options.defaultOptions();
        X509TrustManager trustManager = null;
        try {
            trustManager = TrustManagers.checkValidityDates(TrustManagers.checkHostName(hostname, TrustManagers.checkUsingTrustStore(truststore, storepass.toCharArray(), null)));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (trustManager != null) {
            SSLContext sslContext = new SSLContextBuilder().setTrustManager(trustManager).getSSLContext();
            options.set(LDAPConnectionFactory.SSL_CONTEXT, sslContext);
        }
        options.set(LDAPConnectionFactory.SSL_USE_STARTTLS, useStartTLS);
        return options;
    }

    private static void secureConnect() {
        try (Connection connection = null;){
            LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port, SimpleAuth.getTrustOptions(host, keystore, storepass));
            connection = factory.getConnection();
            connection.bind(bindDN, bindPassword.toCharArray());
            System.out.println("Authenticated as " + bindDN + ".");
        }
    }

    private static Options getTrustAllOptions() throws GeneralSecurityException {
        Options options = Options.defaultOptions();
        SSLContext sslContext = new SSLContextBuilder().setTrustManager(TrustManagers.trustAll()).getSSLContext();
        options.set(LDAPConnectionFactory.SSL_CONTEXT, sslContext);
        options.set(LDAPConnectionFactory.SSL_USE_STARTTLS, useStartTLS);
        return options;
    }

    private static void trustAllConnect() {
        try (Connection connection = null;){
            LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port, SimpleAuth.getTrustAllOptions());
            connection = factory.getConnection();
            connection.bind(bindDN, bindPassword.toCharArray());
            System.out.println("Authenticated as " + bindDN + ".");
        }
    }

    private static void connectStartTLS() {
        SimpleAuth.secureConnect();
    }

    private static void connectSSL() {
        SimpleAuth.secureConnect();
    }

    private static void parseArgs(String[] args) {
        if (args.length < 4 || args.length > 5) {
            SimpleAuth.giveUp();
        }
        host = args[0];
        port = Integer.parseInt(args[1]);
        bindDN = args[2];
        bindPassword = args[3];
        if (args.length == 5) {
            if ("use-starttls".equals(args[4].toLowerCase())) {
                useStartTLS = true;
                useSSL = false;
            } else if ("use-ssl".equals(args[4].toLowerCase())) {
                useStartTLS = false;
                useSSL = true;
            } else {
                SimpleAuth.giveUp();
            }
        }
        keystore = System.getProperty("javax.net.ssl.trustStore");
        storepass = System.getProperty("javax.net.ssl.trustStorePassword");
        if (keystore == null) {
            keystore = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
            storepass = "changeit";
        }
    }

    private static void giveUp() {
        SimpleAuth.printUsage();
        System.exit(1);
    }

    private static void printUsage() {
        System.err.println("Usage: host port bind-dn bind-password [ use-starttls | use-ssl ]");
        System.err.println("\thost, port, bind-dn, and bind-password arguments are required.");
        System.err.println("\tuse-starttls and use-ssl are optional and mutually exclusive.");
        System.err.println("\tOptionally set javax.net.ssl.trustStore and javax.net.ssl.trustStorePassword.");
    }

    private SimpleAuth() {
    }
}

