/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import com.forgerock.reactive.ServerConnectionFactoryAdapter;
import java.io.FileInputStream;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.KeyManagers;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LDAPListener;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.MemoryBackend;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.forgerock.util.Options;

public final class Server {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        MemoryBackend backend;
        if (args.length != 3 && args.length != 6) {
            System.err.println("Usage: listenAddress listenPort ldifFile [keyStoreFile keyStorePassword certNickname]");
            System.exit(1);
        }
        String localAddress = args[0];
        int localPort = Integer.parseInt(args[1]);
        String ldifFileName = args[2];
        String keyStoreFileName = args.length == 6 ? args[3] : null;
        String keyStorePassword = args.length == 6 ? args[4] : null;
        String certNickname = args.length == 6 ? args[5] : null;
        try {
            backend = new MemoryBackend(new LDIFEntryReader(new FileInputStream(ldifFileName)));
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue());
            return;
        }
        final ServerConnectionFactory<LDAPClientContext, Integer> connectionHandler = Connections.newServerConnectionFactory(backend);
        try (LDAPListener listener = null;){
            Options options = Options.defaultOptions().set(LDAPListener.CONNECT_MAX_BACKLOG, 4096);
            if (keyStoreFileName != null) {
                final SSLContext sslContext = new SSLContextBuilder().setKeyManager(KeyManagers.useSingleCertificate(certNickname, KeyManagers.useKeyStoreFile(keyStoreFileName, keyStorePassword.toCharArray(), null))).setTrustManager(TrustManagers.trustAll()).getSSLContext();
                ServerConnectionFactory<LDAPClientContext, Integer> sslWrapper = new ServerConnectionFactory<LDAPClientContext, Integer>(){

                    @Override
                    public ServerConnection<Integer> handleAccept(LDAPClientContext clientContext) throws LdapException {
                        clientContext.enableTLS(sslContext.createSSLEngine(), false);
                        return connectionHandler.handleAccept(clientContext);
                    }
                };
                listener = new LDAPListener(localAddress, localPort, new ServerConnectionFactoryAdapter((DecodeOptions)options.get(LDAPListener.LDAP_DECODE_OPTIONS), sslWrapper), options);
            } else {
                listener = new LDAPListener(localAddress, localPort, new ServerConnectionFactoryAdapter((DecodeOptions)options.get(LDAPListener.LDAP_DECODE_OPTIONS), connectionHandler), options);
            }
            System.out.println("Press any key to stop the server...");
            System.in.read();
        }
    }

    private Server() {
    }
}

