/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.CountDownLatch;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;

public final class SearchBindAsync {
    private static Connection connection;
    private static String mail;
    private static char[] password;
    private static String bindDn;
    private static int resultCode;
    private static final CountDownLatch COMPLETION_LATCH;

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: host port base-dn");
            System.err.println("For example: localhost 1389 dc=example,dc=com");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        final String baseDn = args[2];
        try {
            mail = SearchBindAsync.getInputLine("Email address:");
            password = SearchBindAsync.getInputLine("Password:").toCharArray();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue());
            return;
        }
        new LDAPConnectionFactory(host, port).getConnectionAsync().thenAsync(new AsyncFunction<Connection, SearchResultEntry, LdapException>(){

            @Override
            public Promise<SearchResultEntry, LdapException> apply(Connection connection) throws LdapException {
                connection = connection;
                return connection.searchSingleEntryAsync(Requests.newSingleEntrySearchRequest(baseDn, SearchScope.WHOLE_SUBTREE, Filter.equality("mail", mail).toString(), "cn"));
            }
        }).thenAsync(new AsyncFunction<SearchResultEntry, BindResult, LdapException>(){

            @Override
            public Promise<BindResult, LdapException> apply(SearchResultEntry searchResultEntry) throws LdapException {
                bindDn = searchResultEntry.getName().toString();
                return connection.bindAsync(Requests.newSimpleBindRequest(bindDn, password));
            }
        }).thenOnResult((ResultHandler<BindResult>)new ResultHandler<Result>(){

            @Override
            public void handleResult(Result result) {
                if (result.getResultCode() == ResultCode.SUCCESS) {
                    System.out.println("Authenticated as " + bindDn + ".");
                }
                resultCode = result.getResultCode().intValue();
                COMPLETION_LATCH.countDown();
            }
        }).thenOnException(new ExceptionHandler<LdapException>(){

            @Override
            public void handleException(LdapException e) {
                System.err.println(e.getMessage());
                resultCode = e.getResult().getResultCode().intValue();
                COMPLETION_LATCH.countDown();
            }
        });
        try {
            COMPLETION_LATCH.await();
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_USER_CANCELLED.intValue());
            return;
        }
        Utils.closeSilently(connection);
        System.exit(resultCode);
    }

    private static String getInputLine(String prompt) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(prompt + " ");
        return reader.readLine();
    }

    private SearchBindAsync() {
    }

    static {
        COMPLETION_LATCH = new CountDownLatch(1);
    }
}

