/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.CancelExtendedRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.LDIFEntryWriter;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;

public final class SearchAsync {
    private static final CountDownLatch COMPLETION_LATCH = new CountDownLatch(1);
    private static final CountDownLatch CANCEL_LATCH = new CountDownLatch(1);
    private static final LDIFEntryWriter WRITER = new LDIFEntryWriter(System.out);
    private static String userName;
    private static String password;
    private static String baseDN;
    private static SearchScope scope;
    private static String filter;
    private static String[] attributes;
    private static Connection connection;
    private static int resultCode;
    static int requestID;
    static int entryCount;

    public static void main(String[] args) {
        if (args.length < 7) {
            System.err.println("Usage: host port username password baseDN scope filter [attribute ...]");
            System.exit(1);
        }
        String hostName = args[0];
        int port = Integer.parseInt(args[1]);
        userName = args[2];
        password = args[3];
        baseDN = args[4];
        String scopeString = args[5];
        filter = args[6];
        attributes = args.length > 7 ? Arrays.copyOfRange(args, 7, args.length) : new String[0];
        scope = SearchScope.valueOf(scopeString);
        if (scope == null) {
            System.err.println("Unknown scope: " + scopeString);
            System.exit(ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue());
            return;
        }
        LDAPConnectionFactory factory = new LDAPConnectionFactory(hostName, port);
        factory.getConnectionAsync().thenAsync(new AsyncFunction<Connection, BindResult, LdapException>(){

            @Override
            public Promise<BindResult, LdapException> apply(Connection connection) throws LdapException {
                connection = connection;
                return connection.bindAsync(Requests.newSimpleBindRequest(userName, password.toCharArray()));
            }
        }).thenAsync(new AsyncFunction<BindResult, Result, LdapException>(){

            @Override
            public Promise<Result, LdapException> apply(BindResult result) throws LdapException {
                LdapPromise<Result> promise = connection.searchAsync(Requests.newSearchRequest(baseDN, scope, filter, attributes), new SearchResultHandlerImpl());
                requestID = promise.getRequestID();
                return promise;
            }
        }).thenOnResult(new ResultHandler<Result>(){

            @Override
            public void handleResult(Result result) {
                resultCode = result.getResultCode().intValue();
                COMPLETION_LATCH.countDown();
            }
        }).thenOnException(new ExceptionHandler<LdapException>(){

            @Override
            public void handleException(LdapException exception) {
                System.err.println(exception.getMessage());
                resultCode = exception.getResult().getResultCode().intValue();
                COMPLETION_LATCH.countDown();
            }
        });
        try {
            COMPLETION_LATCH.await();
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_USER_CANCELLED.intValue());
            return;
        }
        try {
            WRITER.flush();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            return;
        }
        try {
            CANCEL_LATCH.await();
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_USER_CANCELLED.intValue());
            return;
        }
        if (connection != null) {
            connection.close();
        }
        System.exit(resultCode);
    }

    private SearchAsync() {
    }

    private static final class SearchResultHandlerImpl
    implements SearchResultHandler {
        private SearchResultHandlerImpl() {
        }

        @Override
        public synchronized boolean handleEntry(SearchResultEntry entry) {
            block3: {
                try {
                    if (entryCount < 10) {
                        WRITER.writeComment("Search result entry: " + entry.getName());
                        WRITER.writeEntry(entry);
                        ++entryCount;
                        break block3;
                    }
                    CancelExtendedRequest request = Requests.newCancelExtendedRequest(requestID);
                    connection.extendedRequestAsync(request).thenOnResult((ResultHandler)new ResultHandler<ExtendedResult>(){

                        @Override
                        public void handleResult(ExtendedResult result) {
                            System.err.println("Cancel request succeeded");
                            CANCEL_LATCH.countDown();
                        }
                    }).thenOnException(new ExceptionHandler<LdapException>(){

                        @Override
                        public void handleException(LdapException exception) {
                            System.err.println("Cancel request failed: " + exception.getResult().getResultCode().intValue() + " " + exception.getResult().getDiagnosticMessage());
                            CANCEL_LATCH.countDown();
                        }
                    });
                    return false;
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                    resultCode = ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue();
                    COMPLETION_LATCH.countDown();
                    return false;
                }
            }
            return true;
        }

        @Override
        public synchronized boolean handleReference(SearchResultReference reference) {
            try {
                WRITER.writeComment("Search result reference: " + reference.getURIs());
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                resultCode = ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue();
                COMPLETION_LATCH.countDown();
                return false;
            }
            return true;
        }
    }
}

