/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.util.Arrays;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.ConnectionEntryReader;
import org.forgerock.opendj.ldif.LDIFEntryWriter;

public final class Search {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 7) {
            System.err.println("Usage: host port username password baseDN scope filter [attribute ...]");
            System.exit(1);
        }
        String hostName = args[0];
        int port = Integer.parseInt(args[1]);
        String userName = args[2];
        String password = args[3];
        String baseDN = args[4];
        String scopeString = args[5];
        String filter = args[6];
        String[] attributes = args.length > 7 ? Arrays.copyOfRange(args, 7, args.length) : new String[]{};
        SearchScope scope = SearchScope.valueOf(scopeString);
        if (scope == null) {
            System.err.println("Unknown scope: " + scopeString);
            System.exit(ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue());
            return;
        }
        LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
        LDAPConnectionFactory factory = new LDAPConnectionFactory(hostName, port);
        try (Connection connection = null;){
            connection = factory.getConnection();
            connection.bind(userName, password.toCharArray());
            ConnectionEntryReader reader = connection.search(baseDN, scope, filter, attributes);
            while (reader.hasNext()) {
                if (!reader.isReference()) {
                    SearchResultEntry entry = reader.readEntry();
                    writer.writeComment("Search result entry: " + entry.getName());
                    writer.writeEntry(entry);
                    continue;
                }
                SearchResultReference ref = reader.readReference();
                writer.writeComment("Search result reference: " + ref.getURIs());
            }
            writer.flush();
        }
    }

    private Search() {
    }
}

