/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.opendj.ldap.requests.PlainSASLBindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.util.Options;

public final class SASLAuth {
    private static String host;
    private static int port;
    private static String authzid;
    private static String authcid;
    private static String passwd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        SASLAuth.parseArgs(args);
        try (Connection connection = null;){
            LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port, SASLAuth.getTrustAllOptions());
            connection = factory.getConnection();
            PlainSASLBindRequest request = Requests.newPlainSASLBindRequest(authcid, passwd.toCharArray()).setAuthorizationID(authzid);
            connection.bind(request);
            System.out.println("Authenticated as " + authcid + ".");
        }
    }

    private static Options getTrustAllOptions() throws GeneralSecurityException {
        Options options = Options.defaultOptions();
        SSLContext sslContext = new SSLContextBuilder().setTrustManager(TrustManagers.trustAll()).getSSLContext();
        options.set(LDAPConnectionFactory.SSL_CONTEXT, sslContext);
        options.set(LDAPConnectionFactory.SSL_USE_STARTTLS, true);
        return options;
    }

    private static void parseArgs(String[] args) {
        if (args.length < 4 || args.length > 5) {
            SASLAuth.giveUp();
        }
        host = args[0];
        port = Integer.parseInt(args[1]);
        if (args.length == 5) {
            authzid = args[2];
            authcid = args[3];
            passwd = args[4];
        } else {
            authzid = null;
            authcid = args[2];
            passwd = args[3];
        }
    }

    private static void giveUp() {
        SASLAuth.printUsage();
        System.exit(1);
    }

    private static void printUsage() {
        System.err.println("Usage: host port [authzid] authcid passwd");
        System.err.println("\tThe port must be able to handle LDAP with StartTLS.");
        System.err.println("\tSee http://www.ietf.org/rfc/rfc4616.txt for more on SASL PLAIN.");
    }

    private SASLAuth() {
    }
}

