/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.Syntax;

public final class ReadSchema {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("Usage: host port username password");
            System.exit(1);
        }
        String hostName = args[0];
        int port = Integer.parseInt(args[1]);
        String userName = args[2];
        String password = args[3];
        LDAPConnectionFactory factory = new LDAPConnectionFactory(hostName, port);
        try (Connection connection = null;){
            connection = factory.getConnection();
            connection.bind(userName, password.toCharArray());
            Schema schema = Schema.readSchemaForEntry(connection, DN.rootDN());
            System.out.println("Attribute types");
            for (AttributeType at : schema.getAttributeTypes()) {
                System.out.println("  " + at.getNameOrOID());
            }
            System.out.println();
            System.out.println("Object classes");
            for (ObjectClass oc : schema.getObjectClasses()) {
                System.out.println("  " + oc.getNameOrOID());
            }
            System.out.println();
            System.out.println("Matching rules");
            for (MatchingRule mr : schema.getMatchingRules()) {
                System.out.println("  " + mr.getNameOrOID());
            }
            System.out.println();
            System.out.println("Syntaxes");
            for (Syntax s : schema.getSyntaxes()) {
                System.out.println("  " + s.getDescription());
            }
            System.out.println();
            System.out.println("WARNINGS");
            for (LocalizableMessage m : schema.getWarnings()) {
                System.out.println("  " + m);
            }
            System.out.println();
        }
    }

    private ReadSchema() {
    }
}

