/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.util.Calendar;
import java.util.Set;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldif.LDIFEntryWriter;

public final class ParseAttributes {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: host port");
            System.err.println("For example: localhost 1389");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port);
        try (Connection connection = null;){
            connection = factory.getConnection();
            String name = "uid=kvaughan,ou=People,dc=example,dc=com";
            char[] password = "bribery".toCharArray();
            connection.bind(name, password);
            ParseAttributes.updateEntry(connection, name, "description");
            SearchResultEntry entry = connection.readEntry(name, "cn", "objectClass", "hasSubordinates", "numSubordinates", "isMemberOf", "modifyTimestamp");
            DN dn = entry.getName();
            Set<String> cn = entry.parseAttribute("cn").asSetOfString("");
            Set<AttributeDescription> objectClasses = entry.parseAttribute("objectClass").asSetOfAttributeDescription();
            boolean hasChildren = entry.parseAttribute("hasSubordinates").asBoolean();
            int numChildren = entry.parseAttribute("numSubordinates").asInteger(0);
            Set<DN> groups = entry.parseAttribute("isMemberOf").usingSchema(Schema.getDefaultSchema()).asSetOfDN();
            Calendar timestamp = entry.parseAttribute("modifyTimestamp").asGeneralizedTime().toCalendar();
            entry.setName(dn);
            Entry newEntry = new LinkedHashMapEntry(name).addAttribute("cn", cn.toArray()).addAttribute("objectClass", objectClasses.toArray()).addAttribute("hasChildren", hasChildren).addAttribute("numChildren", numChildren).addAttribute("groups", groups.toArray()).addAttribute("timestamp", timestamp.getTimeInMillis());
            LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
            writer.writeEntry(newEntry);
            writer.close();
        }
    }

    private static void updateEntry(Connection connection, String name, String attributeDescription) throws LdapException {
        ModifyRequest request = Requests.newModifyRequest(name).addModification(ModificationType.REPLACE, attributeDescription, "This is a String.");
        connection.modify(request);
    }

    private ParseAttributes() {
    }
}

