/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ConnectionChangeRecordWriter;
import org.forgerock.opendj.ldif.LDIFChangeRecordReader;

public final class Modify {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        InputStream ldif;
        if (args.length < 4 || args.length > 5) {
            System.err.println("Usage: host port username password [ldifFileName]");
            System.exit(1);
        }
        String hostName = args[0];
        int port = Integer.parseInt(args[1]);
        String userName = args[2];
        String password = args[3];
        if (args.length > 4) {
            try {
                ldif = new FileInputStream(args[4]);
            }
            catch (FileNotFoundException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue());
                return;
            }
        } else {
            ldif = System.in;
        }
        LDIFChangeRecordReader reader = new LDIFChangeRecordReader(ldif);
        LDAPConnectionFactory factory = new LDAPConnectionFactory(hostName, port);
        Connection connection = null;
        try {
            connection = factory.getConnection();
            connection.bind(userName, password.toCharArray());
            ConnectionChangeRecordWriter writer = new ConnectionChangeRecordWriter(connection);
            while (reader.hasNext()) {
                ChangeRecord changeRecord = reader.readChangeRecord();
                writer.writeChangeRecord(changeRecord);
                System.err.println("Successfully modified entry " + changeRecord.getName());
            }
        }
        catch (LdapException e) {
            System.err.println(e.getMessage());
            System.exit(e.getResult().getResultCode().intValue());
            return;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            return;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Modify() {
    }
}

