/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.ConnectionEntryReader;
import org.forgerock.opendj.ldif.LDIFEntryWriter;

public final class GetADChangeNotifications {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 5) {
            System.err.println("Usage: host port username password baseDN");
            System.exit(1);
        }
        String hostName = args[0];
        int port = Integer.parseInt(args[1]);
        String userName = args[2];
        String password = args[3];
        String baseDN = args[4];
        SearchScope scope = SearchScope.WHOLE_SUBTREE;
        String filter = "(objectclass=*)";
        String[] attributes = new String[]{"objectclass", "objectGUID", "isDeleted", "uSNChanged"};
        LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
        LDAPConnectionFactory factory = new LDAPConnectionFactory(hostName, port);
        try (Connection connection = null;){
            connection = factory.getConnection();
            connection.bind(userName, password.toCharArray());
            SearchRequest request = Requests.newSearchRequest(baseDN, scope, "(objectclass=*)", attributes).addControl(GenericControl.newControl("1.2.840.113556.1.4.528", true));
            ConnectionEntryReader reader = connection.search(request);
            while (reader.hasNext()) {
                if (!reader.isReference()) {
                    SearchResultEntry entry = reader.readEntry();
                    writer.writeComment("Search result entry: " + entry.getName());
                    writer.writeEntry(entry);
                    writer.flush();
                    continue;
                }
                SearchResultReference ref = reader.readReference();
                writer.writeComment("Search result reference: " + ref.getURIs());
            }
        }
    }

    private GetADChangeNotifications() {
    }
}

