/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.examples;

import com.forgerock.opendj.ldap.controls.AffinityControl;
import java.io.IOException;
import java.util.Collection;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.RootDSE;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchResultReferenceIOException;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.SortKey;
import org.forgerock.opendj.ldap.controls.ADNotificationRequestControl;
import org.forgerock.opendj.ldap.controls.AssertionRequestControl;
import org.forgerock.opendj.ldap.controls.AuthorizationIdentityRequestControl;
import org.forgerock.opendj.ldap.controls.AuthorizationIdentityResponseControl;
import org.forgerock.opendj.ldap.controls.EntryChangeNotificationResponseControl;
import org.forgerock.opendj.ldap.controls.GetEffectiveRightsRequestControl;
import org.forgerock.opendj.ldap.controls.ManageDsaITRequestControl;
import org.forgerock.opendj.ldap.controls.MatchedValuesRequestControl;
import org.forgerock.opendj.ldap.controls.PasswordExpiredResponseControl;
import org.forgerock.opendj.ldap.controls.PasswordExpiringResponseControl;
import org.forgerock.opendj.ldap.controls.PasswordPolicyRequestControl;
import org.forgerock.opendj.ldap.controls.PasswordPolicyResponseControl;
import org.forgerock.opendj.ldap.controls.PermissiveModifyRequestControl;
import org.forgerock.opendj.ldap.controls.PersistentSearchChangeType;
import org.forgerock.opendj.ldap.controls.PersistentSearchRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadResponseControl;
import org.forgerock.opendj.ldap.controls.PreReadRequestControl;
import org.forgerock.opendj.ldap.controls.PreReadResponseControl;
import org.forgerock.opendj.ldap.controls.ProxiedAuthV2RequestControl;
import org.forgerock.opendj.ldap.controls.ServerSideSortRequestControl;
import org.forgerock.opendj.ldap.controls.ServerSideSortResponseControl;
import org.forgerock.opendj.ldap.controls.SimplePagedResultsControl;
import org.forgerock.opendj.ldap.controls.SubentriesRequestControl;
import org.forgerock.opendj.ldap.controls.SubtreeDeleteRequestControl;
import org.forgerock.opendj.ldap.controls.VirtualListViewRequestControl;
import org.forgerock.opendj.ldap.controls.VirtualListViewResponseControl;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.ConnectionEntryReader;
import org.forgerock.opendj.ldif.LDIFEntryWriter;

public final class Controls {
    private static Collection<String> controls;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: host port");
            System.err.println("For example: localhost 1389");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port);
        try (Connection connection = factory.getConnection();){
            Controls.checkSupportedControls(connection);
            String user = "cn=Directory Manager";
            char[] password = "password".toCharArray();
            connection.bind("cn=Directory Manager", password);
            Controls.useAuthorizationIdentityRequestControl(connection);
        }
        catch (LdapException e) {
            System.err.println(e.getMessage());
            System.exit(e.getResult().getResultCode().intValue());
            return;
        }
    }

    static void useAffinityControl(Connection connection) throws LdapException {
        if (Controls.isSupported("1.3.6.1.4.1.36733.2.1.5.2")) {
            String dn = "uid=bjensen,ou=People,dc=example,dc=com";
            AffinityControl control = AffinityControl.newControl(true);
            ModifyRequest modification = Requests.newModifyRequest("uid=bjensen,ou=People,dc=example,dc=com").addControl(control).addModification(ModificationType.ADD, "description", "Added with an Affinity control");
            connection.modify(modification);
            SearchRequest read = Requests.newSearchRequest("uid=bjensen,ou=People,dc=example,dc=com", SearchScope.BASE_OBJECT, "(&)", "description").addControl(control);
            try (ConnectionEntryReader reader = connection.search(read);
                 LDIFEntryWriter writer = new LDIFEntryWriter(System.out);){
                while (reader.hasNext()) {
                    writer.writeEntry(reader.readEntry());
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            }
        } else {
            System.err.println("AffinityControl not supported.");
        }
    }

    static void useADNotificationRequestControl(Connection connection) throws LdapException {
        String user = "cn=Administrator,cn=users,dc=example,dc=com";
        char[] password = "password".toCharArray();
        connection.bind("cn=Administrator,cn=users,dc=example,dc=com", password);
        String[] attributes = new String[]{"cn", "isDeleted", "whenChanged", "whenCreated"};
        SearchRequest request = Requests.newSearchRequest("dc=example,dc=com", SearchScope.WHOLE_SUBTREE, "(objectclass=*)", attributes).addControl(ADNotificationRequestControl.newControl(true));
        ConnectionEntryReader reader = connection.search(request);
        try {
            while (reader.hasNext()) {
                if (!reader.isReference()) {
                    SearchResultEntry entry = reader.readEntry();
                    LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
                    Boolean isDeleted = entry.parseAttribute("isDeleted").asBoolean();
                    if (isDeleted != null && isDeleted.booleanValue()) {
                        writer.writeComment("Deleted entry: " + entry.getName());
                        writer.writeEntry(entry);
                        writer.flush();
                    }
                    String whenCreated = entry.parseAttribute("whenCreated").asString();
                    String whenChanged = entry.parseAttribute("whenChanged").asString();
                    if (whenCreated == null || whenChanged == null) continue;
                    if (whenCreated.equals(whenChanged)) {
                        writer.writeComment("Added entry: " + entry.getName());
                        writer.writeEntry(entry);
                        writer.flush();
                        continue;
                    }
                    writer.writeComment("Modified entry: " + entry.getName());
                    writer.writeEntry(entry);
                    writer.flush();
                    continue;
                }
                reader.readReference();
            }
        }
        catch (LdapException e) {
            System.err.println(e.getMessage());
            System.exit(e.getResult().getResultCode().intValue());
        }
        catch (SearchResultReferenceIOException e) {
            System.err.println("Got search reference(s): " + e.getReference().getURIs());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
        }
    }

    static void useAssertionControl(Connection connection) throws LdapException {
        if (Controls.isSupported("1.3.6.1.1.12")) {
            String dn = "uid=bjensen,ou=People,dc=example,dc=com";
            ModifyRequest request = Requests.newModifyRequest("uid=bjensen,ou=People,dc=example,dc=com").addControl(AssertionRequestControl.newControl(true, Filter.valueOf("!(description=*)"))).addModification(ModificationType.ADD, "description", "Created using LDAP assertion control");
            connection.modify(request);
            try (LDIFEntryWriter writer = new LDIFEntryWriter(System.out);){
                writer.writeEntry(connection.readEntry("uid=bjensen,ou=People,dc=example,dc=com", "description"));
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            }
        } else {
            System.err.println("AssertionRequestControl not supported.");
        }
    }

    static void useAuthorizationIdentityRequestControl(Connection connection) throws LdapException {
        if (Controls.isSupported("2.16.840.1.113730.3.4.16")) {
            String dn = "uid=bjensen,ou=People,dc=example,dc=com";
            char[] pwd = "hifalutin".toCharArray();
            System.out.println("Binding as uid=bjensen,ou=People,dc=example,dc=com");
            SimpleBindRequest request = Requests.newSimpleBindRequest("uid=bjensen,ou=People,dc=example,dc=com", pwd).addControl(AuthorizationIdentityRequestControl.newControl(true));
            BindResult result = connection.bind(request);
            try {
                AuthorizationIdentityResponseControl control = result.getControl(AuthorizationIdentityResponseControl.DECODER, new DecodeOptions());
                System.out.println("Authorization ID returned: " + control.getAuthorizationID());
            }
            catch (DecodeException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_DECODING_ERROR.intValue());
            }
        } else {
            System.err.println("AuthorizationIdentityRequestControl not supported.");
        }
    }

    static void useGetEffectiveRightsRequestControl(Connection connection) throws LdapException {
        if (Controls.isSupported("1.3.6.1.4.1.42.2.27.9.5.2")) {
            String authDN = "uid=kvaughan,ou=People,dc=example,dc=com";
            SearchRequest request = Requests.newSearchRequest("dc=example,dc=com", SearchScope.WHOLE_SUBTREE, "(uid=bjensen)", "cn", "aclRights", "aclRightsInfo").addControl(GetEffectiveRightsRequestControl.newControl(true, "uid=kvaughan,ou=People,dc=example,dc=com", "cn"));
            ConnectionEntryReader reader = connection.search(request);
            try (LDIFEntryWriter writer = new LDIFEntryWriter(System.out);){
                while (reader.hasNext()) {
                    if (reader.isReference()) continue;
                    SearchResultEntry entry = reader.readEntry();
                    writer.writeEntry(entry);
                }
            }
            catch (LdapException e) {
                System.err.println(e.getMessage());
                System.exit(e.getResult().getResultCode().intValue());
            }
            catch (SearchResultReferenceIOException e) {
                System.err.println("Got search reference(s): " + e.getReference().getURIs());
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            }
        } else {
            System.err.println("GetEffectiveRightsRequestControl not supported.");
        }
    }

    static void useManageDsaITRequestControl(Connection connection) throws LdapException {
        if (Controls.isSupported("2.16.840.1.113730.3.4.2")) {
            String dn = "dc=ref,dc=com";
            LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
            try {
                System.out.println("Referral without the ManageDsaIT control.");
                SearchRequest request = Requests.newSearchRequest("dc=ref,dc=com", SearchScope.SUBORDINATES, "(objectclass=*)", "");
                ConnectionEntryReader reader = connection.search(request);
                while (reader.hasNext()) {
                    if (!reader.isReference()) continue;
                    SearchResultReference ref = reader.readReference();
                    System.out.println("Reference: " + ref.getURIs());
                }
                System.out.println("Referral with the ManageDsaIT control.");
                request.addControl(ManageDsaITRequestControl.newControl(true));
                SearchResultEntry entry = connection.searchSingleEntry(request);
                writer.writeEntry(entry);
                writer.close();
            }
            catch (LdapException e) {
                System.err.println(e.getMessage());
                System.exit(e.getResult().getResultCode().intValue());
            }
            catch (SearchResultReferenceIOException e) {
                System.err.println("Got search reference(s): " + e.getReference().getURIs());
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            }
        } else {
            System.err.println("ManageDsaITRequestControl not supported.");
        }
    }

    static void useMatchedValuesRequestControl(Connection connection) throws LdapException {
        if (Controls.isSupported("1.2.826.0.1.3344810.2.3")) {
            String dn = "uid=bjensen,ou=People,dc=example,dc=com";
            SearchRequest request = Requests.newSearchRequest("uid=bjensen,ou=People,dc=example,dc=com", SearchScope.BASE_OBJECT, "(objectclass=*)", "cn").addControl(MatchedValuesRequestControl.newControl(true, "(cn=Babs Jensen)"));
            SearchResultEntry entry = connection.searchSingleEntry(request);
            System.out.println("Reading entry with matched values request.");
            LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
            try {
                writer.writeEntry(entry);
                writer.close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            }
        } else {
            System.err.println("MatchedValuesRequestControl not supported.");
        }
    }

    static void usePasswordExpiredResponseControl(Connection connection) {
        if (Controls.isSupported("2.16.840.1.113730.3.4.4")) {
            String dn = "uid=bjensen,ou=People,dc=example,dc=com";
            char[] pwd = "hifalutin".toCharArray();
            try {
                connection.bind("uid=bjensen,ou=People,dc=example,dc=com", pwd);
            }
            catch (LdapException e) {
                Result result = e.getResult();
                try {
                    PasswordExpiredResponseControl control = result.getControl(PasswordExpiredResponseControl.DECODER, new DecodeOptions());
                    if (control != null && control.hasValue()) {
                        System.out.println("Password expired for uid=bjensen,ou=People,dc=example,dc=com");
                    }
                }
                catch (DecodeException de) {
                    System.err.println(de.getMessage());
                    System.exit(ResultCode.CLIENT_SIDE_DECODING_ERROR.intValue());
                }
            }
        } else {
            System.err.println("PasswordExpiredResponseControl not supported.");
        }
    }

    static void usePasswordExpiringResponseControl(Connection connection) throws LdapException {
        if (Controls.isSupported("2.16.840.1.113730.3.4.5")) {
            String dn = "uid=bjensen,ou=People,dc=example,dc=com";
            char[] pwd = "hifalutin".toCharArray();
            BindResult result = connection.bind("uid=bjensen,ou=People,dc=example,dc=com", pwd);
            try {
                PasswordExpiringResponseControl control = result.getControl(PasswordExpiringResponseControl.DECODER, new DecodeOptions());
                if (control != null && control.hasValue()) {
                    System.out.println("Password for uid=bjensen,ou=People,dc=example,dc=com expires in " + control.getSecondsUntilExpiration() + " seconds.");
                }
            }
            catch (DecodeException de) {
                System.err.println(de.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_DECODING_ERROR.intValue());
            }
        } else {
            System.err.println("PasswordExpiringResponseControl not supported");
        }
    }

    static void usePasswordPolicyRequestControl(Connection connection) {
        if (Controls.isSupported("1.3.6.1.4.1.42.2.27.8.5.1")) {
            String dn = "uid=bjensen,ou=People,dc=example,dc=com";
            char[] pwd = "hifalutin".toCharArray();
            try {
                SimpleBindRequest request = Requests.newSimpleBindRequest("uid=bjensen,ou=People,dc=example,dc=com", pwd).addControl(PasswordPolicyRequestControl.newControl(true));
                BindResult result = connection.bind(request);
                PasswordPolicyResponseControl control = result.getControl(PasswordPolicyResponseControl.DECODER, new DecodeOptions());
                if (control != null && control.getWarningType() != null) {
                    System.out.println("Password policy warning " + (Object)((Object)control.getWarningType()) + ", value " + control.getWarningValue() + " for " + "uid=bjensen,ou=People,dc=example,dc=com");
                }
            }
            catch (LdapException e) {
                Result result = e.getResult();
                try {
                    PasswordPolicyResponseControl control = result.getControl(PasswordPolicyResponseControl.DECODER, new DecodeOptions());
                    if (control != null) {
                        System.out.println("Password policy error " + (Object)((Object)control.getErrorType()) + " for " + "uid=bjensen,ou=People,dc=example,dc=com");
                    }
                }
                catch (DecodeException de) {
                    System.err.println(de.getMessage());
                    System.exit(ResultCode.CLIENT_SIDE_DECODING_ERROR.intValue());
                }
            }
            catch (DecodeException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_DECODING_ERROR.intValue());
            }
        } else {
            System.err.println("PasswordPolicyRequestControl not supported");
        }
    }

    static void usePermissiveModifyRequestControl(Connection connection) throws LdapException {
        if (Controls.isSupported("1.2.840.113556.1.4.1413")) {
            String dn = "uid=bjensen,ou=People,dc=example,dc=com";
            ModifyRequest request = Requests.newModifyRequest("uid=bjensen,ou=People,dc=example,dc=com").addControl(PermissiveModifyRequestControl.newControl(true)).addModification(ModificationType.ADD, "uid", "bjensen");
            connection.modify(request);
            System.out.println("Permissive modify did not complain about attempt to add uid: bjensen to uid=bjensen,ou=People,dc=example,dc=com.");
        } else {
            System.err.println("PermissiveModifyRequestControl not supported");
        }
    }

    static void usePersistentSearchRequestControl(Connection connection) throws LdapException {
        if (Controls.isSupported("2.16.840.1.113730.3.4.3")) {
            SearchRequest request = Requests.newSearchRequest("dc=example,dc=com", SearchScope.WHOLE_SUBTREE, "(objectclass=inetOrgPerson)", "cn").addControl(PersistentSearchRequestControl.newControl(true, true, true, PersistentSearchChangeType.ADD, PersistentSearchChangeType.DELETE, PersistentSearchChangeType.MODIFY, PersistentSearchChangeType.MODIFY_DN));
            ConnectionEntryReader reader = connection.search(request);
            try {
                while (reader.hasNext()) {
                    if (reader.isReference()) continue;
                    SearchResultEntry entry = reader.readEntry();
                    System.out.println("Entry changed: " + entry.getName());
                    EntryChangeNotificationResponseControl control = entry.getControl(EntryChangeNotificationResponseControl.DECODER, new DecodeOptions());
                    PersistentSearchChangeType type = control.getChangeType();
                    System.out.println("Change type: " + (Object)((Object)type));
                    if (type.equals((Object)PersistentSearchChangeType.MODIFY_DN)) {
                        System.out.println("Previous DN: " + control.getPreviousName());
                    }
                    System.out.println("Change number: " + control.getChangeNumber());
                    System.out.println();
                }
            }
            catch (DecodeException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_DECODING_ERROR.intValue());
            }
            catch (LdapException e) {
                System.err.println(e.getMessage());
                System.exit(e.getResult().getResultCode().intValue());
            }
            catch (SearchResultReferenceIOException e) {
                System.err.println("Got search reference(s): " + e.getReference().getURIs());
            }
        } else {
            System.err.println("PersistentSearchRequestControl not supported.");
        }
    }

    static void usePostReadRequestControl(Connection connection) throws LdapException {
        if (Controls.isSupported("1.3.6.1.1.13.2")) {
            String dn = "uid=bjensen,ou=People,dc=example,dc=com";
            ModifyRequest request = Requests.newModifyRequest("uid=bjensen,ou=People,dc=example,dc=com").addControl(PostReadRequestControl.newControl(true, "description")).addModification(ModificationType.REPLACE, "description", "Using the PostReadRequestControl");
            Result result = connection.modify(request);
            try {
                PostReadResponseControl control = result.getControl(PostReadResponseControl.DECODER, new DecodeOptions());
                Entry entry = control.getEntry();
                LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
                writer.writeEntry(entry);
                writer.close();
            }
            catch (DecodeException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_DECODING_ERROR.intValue());
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            }
        } else {
            System.err.println("PostReadRequestControl not supported");
        }
    }

    static void usePreReadRequestControl(Connection connection) throws LdapException {
        if (Controls.isSupported("1.3.6.1.1.13.1")) {
            String dn = "uid=bjensen,ou=People,dc=example,dc=com";
            ModifyRequest request = Requests.newModifyRequest("uid=bjensen,ou=People,dc=example,dc=com").addControl(PreReadRequestControl.newControl(true, "mail")).addModification(ModificationType.REPLACE, "mail", "modified@example.com");
            Result result = connection.modify(request);
            try {
                PreReadResponseControl control = result.getControl(PreReadResponseControl.DECODER, new DecodeOptions());
                Entry entry = control.getEntry();
                LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
                writer.writeEntry(entry);
                writer.close();
            }
            catch (DecodeException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_DECODING_ERROR.intValue());
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            }
        } else {
            System.err.println("PreReadRequestControl not supported");
        }
    }

    static void useProxiedAuthV2RequestControl(Connection connection) throws LdapException {
        if (Controls.isSupported("2.16.840.1.113730.3.4.18")) {
            String bindDN = "cn=My App,ou=Apps,dc=example,dc=com";
            String targetDn = "uid=bjensen,ou=People,dc=example,dc=com";
            String authzId = "dn:uid=kvaughan,ou=People,dc=example,dc=com";
            ModifyRequest request = Requests.newModifyRequest("uid=bjensen,ou=People,dc=example,dc=com").addControl(ProxiedAuthV2RequestControl.newControl("dn:uid=kvaughan,ou=People,dc=example,dc=com")).addModification(ModificationType.REPLACE, "description", "Done with proxied authz");
            connection.bind("cn=My App,ou=Apps,dc=example,dc=com", "password".toCharArray());
            connection.modify(request);
            SearchResultEntry entry = connection.readEntry("uid=bjensen,ou=People,dc=example,dc=com", "description");
            LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
            try {
                writer.writeEntry(entry);
                writer.close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            }
        } else {
            System.err.println("ProxiedAuthV2RequestControl not supported");
        }
    }

    static void useServerSideSortRequestControl(Connection connection) throws LdapException {
        block5: {
            if (Controls.isSupported("1.2.840.113556.1.4.473")) {
                SearchRequest request = Requests.newSearchRequest("ou=People,dc=example,dc=com", SearchScope.WHOLE_SUBTREE, "(sn=Jensen)", "cn").addControl(ServerSideSortRequestControl.newControl(true, new SortKey("cn")));
                MySearchResultHandler resultHandler = new MySearchResultHandler();
                Result result = connection.search(request, resultHandler);
                try {
                    ServerSideSortResponseControl control = result.getControl(ServerSideSortResponseControl.DECODER, new DecodeOptions());
                    if (control != null && control.getResult() == ResultCode.SUCCESS) {
                        System.out.println("# Entries are sorted.");
                        break block5;
                    }
                    System.out.println("# Entries not necessarily sorted");
                }
                catch (DecodeException e) {
                    System.err.println(e.getMessage());
                    System.exit(ResultCode.CLIENT_SIDE_DECODING_ERROR.intValue());
                }
            } else {
                System.err.println("ServerSideSortRequestControl not supported");
            }
        }
    }

    static void useSimplePagedResultsControl(Connection connection) throws LdapException {
        if (Controls.isSupported("1.2.840.113556.1.4.319")) {
            ByteString cookie = ByteString.empty();
            MySearchResultHandler resultHandler = new MySearchResultHandler();
            int page = 1;
            do {
                System.out.println("# Simple paged results: Page " + page);
                SearchRequest request = Requests.newSearchRequest("dc=example,dc=com", SearchScope.WHOLE_SUBTREE, "(sn=Jensen)", "cn").addControl(SimplePagedResultsControl.newControl(true, 3, cookie));
                Result result = connection.search(request, resultHandler);
                try {
                    SimplePagedResultsControl control = result.getControl(SimplePagedResultsControl.DECODER, new DecodeOptions());
                    cookie = control.getCookie();
                }
                catch (DecodeException e) {
                    System.err.println(e.getMessage());
                    System.exit(ResultCode.CLIENT_SIDE_DECODING_ERROR.intValue());
                }
                ++page;
            } while (cookie.length() != 0);
        } else {
            System.err.println("SimplePagedResultsControl not supported");
        }
    }

    static void useSubentriesRequestControl(Connection connection) throws LdapException {
        if (Controls.isSupported("1.3.6.1.4.1.4203.1.10.1")) {
            SearchRequest request = Requests.newSearchRequest("dc=example,dc=com", SearchScope.WHOLE_SUBTREE, "cn=*Class of Service", "cn", "subtreeSpecification").addControl(SubentriesRequestControl.newControl(true, true));
            ConnectionEntryReader reader = connection.search(request);
            LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
            try {
                while (reader.hasNext()) {
                    if (!reader.isEntry()) continue;
                    SearchResultEntry entry = reader.readEntry();
                    writer.writeEntry(entry);
                }
                writer.close();
            }
            catch (LdapException e) {
                System.err.println(e.getMessage());
                System.exit(e.getResult().getResultCode().intValue());
            }
            catch (SearchResultReferenceIOException e) {
                System.err.println("Got search reference(s): " + e.getReference().getURIs());
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue());
            }
        } else {
            System.err.println("SubentriesRequestControl not supported");
        }
    }

    static void useSubtreeDeleteRequestControl(Connection connection) throws LdapException {
        if (Controls.isSupported("1.2.840.113556.1.4.805")) {
            String dn = "ou=Apps,dc=example,dc=com";
            DeleteRequest request = Requests.newDeleteRequest("ou=Apps,dc=example,dc=com").addControl(SubtreeDeleteRequestControl.newControl(true));
            Result result = connection.delete(request);
            if (result.isSuccess()) {
                System.out.println("Successfully deleted ou=Apps,dc=example,dc=com and all entries below.");
            } else {
                System.err.println("Result: " + result.getDiagnosticMessage());
            }
        } else {
            System.err.println("SubtreeDeleteRequestControl not supported");
        }
    }

    static void useVirtualListViewRequestControl(Connection connection) throws LdapException {
        if (Controls.isSupported("2.16.840.1.113730.3.4.9")) {
            ByteString contextID = ByteString.empty();
            SearchRequest request = Requests.newSearchRequest("ou=People,dc=example,dc=com", SearchScope.WHOLE_SUBTREE, "(sn=*)", "sn", "givenName").addControl(ServerSideSortRequestControl.newControl(true, new SortKey("sn"))).addControl(VirtualListViewRequestControl.newAssertionControl(true, ByteString.valueOfUtf8("Jensen"), 2, 2, contextID));
            MySearchResultHandler resultHandler = new MySearchResultHandler();
            Result result = connection.search(request, resultHandler);
            try {
                ServerSideSortResponseControl sssControl = result.getControl(ServerSideSortResponseControl.DECODER, new DecodeOptions());
                if (sssControl != null && sssControl.getResult() == ResultCode.SUCCESS) {
                    System.out.println("# Entries are sorted.");
                } else {
                    System.out.println("# Entries not necessarily sorted");
                }
                VirtualListViewResponseControl vlvControl = result.getControl(VirtualListViewResponseControl.DECODER, new DecodeOptions());
                System.out.println("# Position in list: " + vlvControl.getTargetPosition() + "/" + vlvControl.getContentCount());
            }
            catch (DecodeException e) {
                System.err.println(e.getMessage());
                System.exit(ResultCode.CLIENT_SIDE_DECODING_ERROR.intValue());
            }
        } else {
            System.err.println("VirtualListViewRequestControl not supported");
        }
    }

    static void checkSupportedControls(Connection connection) throws LdapException {
        controls = RootDSE.readRootDSE(connection).getSupportedControls();
    }

    static boolean isSupported(String control) {
        return controls != null && controls.contains(control);
    }

    private Controls() {
    }

    private static class MySearchResultHandler
    implements SearchResultHandler {
        private MySearchResultHandler() {
        }

        @Override
        public boolean handleEntry(SearchResultEntry entry) {
            LDIFEntryWriter writer = new LDIFEntryWriter(System.out);
            try {
                writer.writeEntry(entry);
                writer.flush();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                return false;
            }
            return true;
        }

        @Override
        public boolean handleReference(SearchResultReference reference) {
            System.out.println("Got a reference: " + reference);
            return false;
        }
    }
}

