/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json;

import org.forgerock.json.JsonException;
import org.forgerock.json.JsonValue;

public class JsonValueException
extends JsonException {
    static final long serialVersionUID = 1L;
    private final JsonValue value;

    public JsonValueException(JsonValue value) {
        this.value = value;
    }

    public JsonValueException(JsonValue value, String message) {
        super(message);
        this.value = value;
    }

    public JsonValueException(JsonValue value, Throwable cause) {
        super(cause);
        this.value = value;
    }

    public JsonValueException(JsonValue value, String message, Throwable cause) {
        super(message, cause);
        this.value = value;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        String message = super.getMessage();
        if (this.value != null) {
            sb.append(this.value.getPointer().toString());
        }
        if (this.value != null && message != null) {
            sb.append(": ");
        }
        if (message != null) {
            sb.append(message);
        }
        return sb.toString();
    }

    public JsonValue getJsonValue() {
        return this.value;
    }
}

